/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.uri;

import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;

public class PlatformXMLURIHandler
extends URIHandlerImpl {
    private URI _basePluginURI;

    public URI resolve(URI uri) {
        if (uri.isPlatformPlugin()) {
            return uri;
        }
        if (uri.isPlatformResource()) {
            String pathName = URI.decode((String)uri.toString().substring(URIHelper.PLATFORM_RESOURCE_URI.toString().length(), uri.toString().length()));
            URI decodedURI = URI.createPlatformPluginURI((String)pathName, (boolean)false);
            return decodedURI;
        }
        return this.resolve && uri.isRelative() && uri.hasRelativePath() ? uri.resolve(this.baseURI) : uri;
    }

    public URI deresolve(URI uri) {
        if (uri.isPlatformPlugin()) {
            URI deresolve = uri.deresolve(this._basePluginURI);
            if (deresolve.isCurrentDocumentReference()) {
                return deresolve;
            }
            String fragment = uri.fragment();
            String pathName = uri.trimFragment().toString().substring(URIHelper.PLATFORM_PLUGIN_URI.toString().length(), uri.trimFragment().toString().length());
            URI encodedURI = URI.createPlatformPluginURI((String)pathName, (boolean)true);
            if (fragment != null) {
                encodedURI = encodedURI.appendFragment(fragment);
            }
            return encodedURI;
        }
        return !uri.isPlatform() || uri.segmentCount() > 0 && this.baseURI.segmentCount() > 0 && uri.segment(0).equals(this.baseURI.segment(0)) ? super.deresolve(uri) : uri;
    }

    public void setBaseURI(URI uri) {
        super.setBaseURI(uri);
        this._basePluginURI = URI.createPlatformPluginURI((String)this.baseURI.toPlatformString(true), (boolean)false);
    }
}

