/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;

abstract class RowColumnRenderer
extends AbstractRenderer {
    protected static final int TABLE_STYLE = 0;
    protected static final int CAPTION_STYLE = 1;
    protected static final int ROWEVEN_STYLE = 2;
    protected static final int ROWODD_STYLE = 3;
    protected static final int CELLEVEN_STYLE = 4;
    protected static final int CELLODD_STYLE = 5;

    RowColumnRenderer() {
    }

    protected void renderRowColumnLayout(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, int rows, int columns) throws IOException {
        writer.startElement("table", component);
        writer.writeAttribute("id", (Object)component.getClientId(context), "id");
        this.writeStyleAttribute(component, writer, null);
        String styles = RenderingUtilities.getStyleClasses(context, component, this.getRowColumnStyle(theme, 0));
        if (styles != null) {
            writer.writeAttribute("class", (Object)styles, null);
        }
        RowColumnRenderer.addStringAttributes(context, component, writer, I18N_ATTRIBUTES);
        this.renderRows(context, component, theme, writer, rows, columns);
        writer.endElement("table");
    }

    private void renderRows(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, int rows, int columns) throws IOException {
        writer.startElement("tr", component);
        writer.writeAttribute("class", (Object)this.getRowColumnStyle(theme, 3), null);
        writer.startElement("td", component);
        String style = this.getRowColumnStyle(theme, 1);
        if (style != null) {
            writer.writeAttribute("class", (Object)style, null);
        }
        this.renderCaption(context, component, theme, writer);
        writer.endElement("td");
        int itemN = 0;
        for (int row = 1; row <= rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                writer.startElement("td", component);
                String styles = (column & 1) == 0 ? this.getRowColumnStyle(theme, 4) : this.getRowColumnStyle(theme, 5);
                if (styles != null) {
                    writer.writeAttribute("class", (Object)styles, null);
                }
                this.renderCellContent(context, component, theme, writer, itemN);
                ++itemN;
                writer.endElement("td");
            }
            writer.endElement("tr");
            if (row + 1 > rows) continue;
            writer.startElement("tr", component);
            String styles = (row & 1) == 0 ? this.getRowColumnStyle(theme, 2) : this.getRowColumnStyle(theme, 3);
            if (styles != null) {
                writer.writeAttribute("class", (Object)styles, "class");
            }
            writer.startElement("td", component);
            writer.endElement("td");
        }
        if (rows == 0) {
            writer.endElement("tr");
        }
    }

    protected abstract void renderCellContent(FacesContext var1, UIComponent var2, Theme var3, ResponseWriter var4, int var5) throws IOException;

    protected abstract void renderCaption(FacesContext var1, UIComponent var2, Theme var3, ResponseWriter var4) throws IOException;

    protected abstract String getRowColumnStyle(Theme var1, int var2);

    private void writeStyleAttribute(UIComponent component, ResponseWriter writer, String style) throws IOException {
        StringBuilder styleBuf = new StringBuilder();
        String compStyle = (String)component.getAttributes().get("style");
        if (compStyle != null) {
            styleBuf.append(compStyle);
        }
        if (style != null) {
            if (styleBuf.length() != 0) {
                styleBuf.append(" ");
            }
            styleBuf.append(style);
        }
        if (styleBuf.length() != 0) {
            writer.writeAttribute("style", (Object)styleBuf.toString(), "style");
        }
    }
}

