/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.vendor;

import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.util.FacesLogger;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebContainerInjectionProvider
implements InjectionProvider {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final Map<Class<?>, ConcurrentHashMap<Class<? extends Annotation>, MethodHolder>> methodsPerClazz = new ConcurrentHashMap();

    @Override
    public void inject(Object managedBean) throws InjectionProviderException {
    }

    @Override
    public void invokePreDestroy(Object managedBean) throws InjectionProviderException {
        if (managedBean != null) {
            WebContainerInjectionProvider.invokeAnnotatedMethod(WebContainerInjectionProvider.getAnnotatedMethod(managedBean, PreDestroy.class), managedBean);
        }
    }

    @Override
    public void invokePostConstruct(Object managedBean) throws InjectionProviderException {
        if (managedBean != null) {
            WebContainerInjectionProvider.invokeAnnotatedMethod(WebContainerInjectionProvider.getAnnotatedMethod(managedBean, PostConstruct.class), managedBean);
        }
    }

    private static void invokeAnnotatedMethod(Method method, Object managedBean) throws InjectionProviderException {
        if (method != null) {
            boolean accessible = method.canAccess(managedBean);
            method.setAccessible(true);
            try {
                method.invoke(managedBean, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new InjectionProviderException(e.getMessage(), e);
            }
            finally {
                method.setAccessible(accessible);
            }
        }
    }

    private static Method getAnnotatedMethod(Object managedBean, Class<? extends Annotation> annotation) {
        Class<?> clazz = managedBean.getClass();
        while (!Object.class.equals(clazz)) {
            Method[] methods;
            Method method;
            MethodHolder newMethodHolder;
            MethodHolder methodHolder;
            ConcurrentHashMap newMethodsMap;
            ConcurrentHashMap<Class<Annotation>, MethodHolder> methodsMap = methodsPerClazz.get(clazz);
            if (methodsMap == null && (methodsMap = methodsPerClazz.putIfAbsent(clazz, newMethodsMap = new ConcurrentHashMap())) == null) {
                methodsMap = newMethodsMap;
            }
            if ((methodHolder = methodsMap.get(annotation)) == null && (methodHolder = methodsMap.putIfAbsent(annotation, newMethodHolder = new MethodHolder(method = WebContainerInjectionProvider.getAnnotatedMethodForMethodArr(methods = clazz.getDeclaredMethods(), annotation)))) == null) {
                methodHolder = newMethodHolder;
            }
            if (methodHolder.getMethod() != null) {
                return methodHolder.getMethod();
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static Method getAnnotatedMethodForMethodArr(Method[] methods, Class<? extends Annotation> annotation) {
        for (Method method : methods) {
            if (!method.isAnnotationPresent(annotation)) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "faces.core.web.injection.method_not_static", new Object[]{method.toString(), annotation.getName()});
                continue;
            }
            if (!Void.TYPE.equals(method.getReturnType())) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "faces.core.web.injection.method_return_not_void", new Object[]{method.toString(), annotation.getName()});
                continue;
            }
            if (method.getParameterTypes().length != 0) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "faces.core.web.injection.method_no_params", new Object[]{method.toString(), annotation.getName()});
                continue;
            }
            Class<?>[] exceptions = method.getExceptionTypes();
            if (method.getExceptionTypes().length != 0) {
                boolean hasChecked = false;
                for (Class<?> excClass : exceptions) {
                    if (RuntimeException.class.isAssignableFrom(excClass)) continue;
                    hasChecked = true;
                    break;
                }
                if (hasChecked) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "faces.core.web.injection.method_no_checked_exceptions", new Object[]{method.toString(), annotation.getName()});
                    continue;
                }
            }
            return method;
        }
        return null;
    }

    private static class MethodHolder {
        private final Method method;

        public MethodHolder(Method method) {
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

