/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model.customization;

import org.eclipse.yasson.internal.JsonbDateFormatter;
import org.eclipse.yasson.internal.JsonbNumberFormatter;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.model.customization.CustomizationBase;

public class CreatorCustomization
extends CustomizationBase {
    private final JsonbNumberFormatter numberFormatter;
    private final JsonbDateFormatter dateFormatter;
    private final boolean required;
    private PropertyModel propertyModel;

    private CreatorCustomization(Builder builder) {
        super(builder);
        this.numberFormatter = builder.numberFormatter;
        this.dateFormatter = builder.dateFormatter;
        this.required = builder.required;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public JsonbNumberFormatter getSerializeNumberFormatter() {
        throw new UnsupportedOperationException("Serialization is not supported for creator parameters.");
    }

    @Override
    public JsonbNumberFormatter getDeserializeNumberFormatter() {
        if (this.numberFormatter != null) {
            return this.numberFormatter;
        }
        if (this.propertyModel != null) {
            return this.propertyModel.getCustomization().getDeserializeNumberFormatter();
        }
        return null;
    }

    @Override
    public JsonbDateFormatter getSerializeDateFormatter() {
        throw new UnsupportedOperationException("Serialization is not supported for creator parameters.");
    }

    @Override
    public JsonbDateFormatter getDeserializeDateFormatter() {
        if (this.dateFormatter != null) {
            return this.dateFormatter;
        }
        if (this.propertyModel != null) {
            return this.propertyModel.getCustomization().getDeserializeDateFormatter();
        }
        return null;
    }

    @Override
    public boolean isNillable() {
        throw new UnsupportedOperationException("Not supported for creator parameters.");
    }

    public void setPropertyModel(PropertyModel propertyModel) {
        this.propertyModel = propertyModel;
    }

    public boolean isRequired() {
        return this.required;
    }

    public static final class Builder
    extends CustomizationBase.Builder<Builder, CreatorCustomization> {
        private JsonbNumberFormatter numberFormatter;
        private JsonbDateFormatter dateFormatter;
        private boolean required = false;

        private Builder() {
        }

        @Override
        public Builder of(CreatorCustomization customization) {
            super.of(customization);
            this.numberFormatter = customization.numberFormatter;
            this.dateFormatter = customization.dateFormatter;
            return this;
        }

        public Builder numberFormatter(JsonbNumberFormatter numberFormatter) {
            this.numberFormatter = numberFormatter;
            return this;
        }

        public Builder dateFormatter(JsonbDateFormatter dateFormatter) {
            this.dateFormatter = dateFormatter;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @Override
        public CreatorCustomization build() {
            return new CreatorCustomization(this);
        }
    }
}

