/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.collections.Iterators;

abstract class ImmutableTinySet<T>
extends ImmutableSet<T> {
    ImmutableTinySet() {
    }

    static class Tripleton<T>
    extends ImmutableTinySet<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final T element1;
        private final T element2;
        private final T element3;

        Tripleton(Set<T> set) {
            Preconditions.checkNotNull(set);
            Preconditions.checkArgument(set.size() == 3, set);
            Iterator<T> iterator = set.iterator();
            this.element1 = iterator.next();
            this.element2 = iterator.next();
            this.element3 = iterator.next();
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            return o.equals(this.element1) || o.equals(this.element2) || o.equals(this.element3);
        }

        @Override
        public int hashCode() {
            return this.element1.hashCode() + this.element2.hashCode() + this.element3.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterators.IndexIterator<T>(this.size()){

                @Override
                T getElement(int position) {
                    switch (position) {
                        case 0: {
                            return element1;
                        }
                        case 1: {
                            return element2;
                        }
                        case 2: {
                            return element3;
                        }
                    }
                    throw new NoSuchElementException();
                }
            };
        }
    }

    static class Doubleton<T>
    extends ImmutableTinySet<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final T element1;
        private final T element2;

        Doubleton(Set<T> set) {
            Preconditions.checkNotNull(set);
            Preconditions.checkArgument(set.size() == 2, set);
            Iterator<T> iterator = set.iterator();
            this.element1 = iterator.next();
            this.element2 = iterator.next();
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            return o.equals(this.element1) || o.equals(this.element2);
        }

        @Override
        public int hashCode() {
            return this.element1.hashCode() + this.element2.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterators.IndexIterator<T>(this.size()){

                @Override
                T getElement(int position) {
                    switch (position) {
                        case 0: {
                            return element1;
                        }
                        case 1: {
                            return element2;
                        }
                    }
                    throw new NoSuchElementException();
                }
            };
        }
    }

    static class Singleton<T>
    extends ImmutableTinySet<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final T element;

        Singleton(Set<T> set) {
            Preconditions.checkNotNull(set);
            Preconditions.checkArgument(set.size() == 1, set);
            this.element = set.iterator().next();
        }

        Singleton(T element) {
            Preconditions.checkNotNull(element);
            this.element = element;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            return o.equals(this.element);
        }

        @Override
        public int hashCode() {
            return this.element.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterators.IndexIterator<T>(this.size()){

                @Override
                T getElement(int position) {
                    return element;
                }
            };
        }
    }
}

