/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.ejb;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.weld.bean.proxy.CommonProxiedMethodFilters;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.module.ejb.EnterpriseBeanInstance;
import org.jboss.weld.module.ejb.InternalEjbDescriptor;
import org.jboss.weld.module.ejb.SessionBeanImpl;
import org.jboss.weld.util.bytecode.RuntimeMethodInformation;
import org.jboss.weld.util.collections.ImmutableSet;

class EnterpriseProxyFactory<T>
extends ProxyFactory<T> {
    private static final String SUFFIX = "$EnterpriseProxy$";

    EnterpriseProxyFactory(Class<T> proxiedBeanType, SessionBeanImpl<T> bean) {
        super(bean.getBeanManager().getContextId(), proxiedBeanType, ImmutableSet.builder().addAll((Iterable<Type>)bean.getTypes()).addAll((Iterable<Type>)((InternalEjbDescriptor)bean.getEjbDescriptor()).getRemoteBusinessInterfacesAsClasses()).build(), bean);
    }

    @Override
    protected void addSpecialMethods(ClassFile proxyClassType, ClassMethod staticConstructor) {
        super.addSpecialMethods(proxyClassType, staticConstructor);
        try {
            proxyClassType.addInterface(EnterpriseBeanInstance.class.getName());
            for (Method method : EnterpriseBeanInstance.class.getMethods()) {
                BeanLogger.LOG.addingMethodToEnterpriseProxy(method);
                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                this.createInterceptorBody(proxyClassType.addMethod(method), methodInfo, staticConstructor);
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    @Override
    protected String getProxyNameSuffix() {
        return SUFFIX;
    }

    @Override
    protected boolean isMethodAccepted(Method method, Class<?> proxySuperclass) {
        return super.isMethodAccepted(method, proxySuperclass) && CommonProxiedMethodFilters.NON_PRIVATE.accept(method, proxySuperclass);
    }

    @Override
    protected boolean isUsingProxyInstantiator() {
        return false;
    }
}

