/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm.statistics;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.glassfish.admin.monitor.cli.MonitorContract;
import org.glassfish.api.ActionReport;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class JVMStatsImpl
implements MonitorContract {
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    @Named(value="default-instance-name")
    @Optional
    MonitoringService monitoringService = null;
    private final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JVMStatsImpl.class);
    private final String name = "jvm";

    @Override
    public String getName() {
        return "jvm";
    }

    @Override
    public ActionReport process(ActionReport report, String filter) {
        String level;
        if (this.monitoringService != null && (level = this.monitoringService.getMonitoringLevel("jvm")) != null && level.equals("OFF")) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(this.localStrings.getLocalString("level.off", "Monitoring level for jvm is off"));
            return report;
        }
        if (this.mrdr == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(this.localStrings.getLocalString("mrdr.null", "MonitoringRuntimeDataRegistry is null"));
            return report;
        }
        TreeNode serverNode = this.mrdr.get("server");
        if (serverNode == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(this.localStrings.getLocalString("mrdr.null", "MonitoringRuntimeDataRegistry server node is null"));
            return report;
        }
        if (filter != null && filter.length() > 0) {
            if ("heapmemory".equals(filter)) {
                return this.heapMemory(report, serverNode);
            }
            if ("nonheapmemory".equals(filter)) {
                return this.nonHeapMemory(report, serverNode);
            }
        } else {
            return this.v2JVM(report, serverNode);
        }
        return null;
    }

    private ActionReport heapMemory(ActionReport report, TreeNode serverNode) {
        long init = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.initheapsize-count");
        long used = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.usedheapsize-count");
        long committed = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.committedheapsize-count");
        long max = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.maxheapsize-count");
        String displayFormat = "%1$-10s %2$-10s %3$-10s %4$-10s";
        report.setMessage(String.format(displayFormat, init, used, committed, max));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    private ActionReport nonHeapMemory(ActionReport report, TreeNode serverNode) {
        long init = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.initnonheapsize-count");
        long used = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.usednonheapsize-count");
        long committed = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.committednonheapsize-count");
        long max = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.maxnonheapsize-count");
        String displayFormat = "%1$-10s %2$-10s %3$-10s %4$-10s";
        report.setMessage(String.format(displayFormat, init, used, committed, max));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    private long getFirstTreeNodeAsLong(TreeNode parent, String name) {
        TreeNode node;
        Object val;
        List nodes = parent.getNodes(name);
        if (!nodes.isEmpty() && (val = (node = (TreeNode)nodes.get(0)).getValue()) != null) {
            try {
                CountStatistic cs = (CountStatistic)val;
                return cs.getCount();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    private ActionReport v2JVM(ActionReport report, TreeNode serverNode) {
        long uptime = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.runtime.uptime-count");
        long min = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.initnonheapsize-count");
        long max = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.maxheapsize-count");
        long count = this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.committedheapsize-count");
        String displayFormat = "%1$-25s %2$-10s %3$-10s %4$-10s %5$-10s %6$-10s";
        report.setMessage(String.format(displayFormat, uptime, min += this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.initheapsize-count"), max += this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.maxnonheapsize-count"), 0, 0, count += this.getFirstTreeNodeAsLong(serverNode, "server.jvm.memory.committednonheapsize-count")));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    public Statistic[] getStatistics() {
        return null;
    }

    public String[] getStatisticNames() {
        return null;
    }

    public Statistic getStatistic(String statisticName) {
        return null;
    }
}

