/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.LogUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class IncludeInputStream
extends FilterInputStream {
    private boolean eol = true;
    private IncludeInputStream redirStream = null;
    private static final Class[] GET_REAL_PATH_ARGS = new Class[]{String.class};
    private static final String INCLUDE = "include";
    private static final int INCLUDE_LEN = "include".length();
    private static final Class FACES_CONTEXT = IncludeInputStream.getFacesContextClass();

    public IncludeInputStream(InputStream input) {
        super(input);
    }

    @Override
    public int read() throws IOException {
        int intChar;
        if (this.redirStream != null) {
            intChar = this.redirStream.read();
            if (intChar != -1) {
                return intChar;
            }
            this.redirStream = null;
        }
        intChar = super.read();
        char ch = (char)intChar;
        if (this.eol) {
            if (ch == '#') {
                intChar = this.startInclude();
            } else {
                this.eol = false;
            }
        }
        if (ch == '\n' || ch == '\r') {
            this.eol = true;
        }
        return intChar;
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        int i;
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > bytes.length || len < 0 || off + len > bytes.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        bytes[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                bytes[off + i] = (byte)c;
            }
        }
        catch (IOException ex) {
            LogUtil.severe(null, ex);
        }
        return i;
    }

    private int startInclude() throws IOException {
        File file;
        char ch;
        for (int count = 0; count < INCLUDE_LEN; ++count) {
            ch = (char)super.read();
            if (Character.toLowerCase(ch) == INCLUDE.charAt(count)) continue;
            throw new RuntimeException("\"#include\" expected in IncludeInputStream.");
        }
        ch = (char)super.read();
        while (ch == ' ' || ch == '\t') {
            ch = (char)super.read();
        }
        if (ch == '\"' || ch == '\'') {
            ch = (char)super.read();
        }
        StringBuilder buf = new StringBuilder("");
        while (ch != '\"' && ch != '\'' && ch != '\n' && ch != '\r' && ch != '\uffffffff') {
            buf.append(ch);
            ch = (char)super.read();
        }
        if (ch == '\"' || ch == '\'') {
            ch = (char)super.read();
        }
        String filename = buf.toString();
        if (FACES_CONTEXT != null) {
            filename = this.convertRelativePath(filename);
        }
        if ((file = new File(filename)).exists()) {
            this.redirStream = new IncludeInputStream(new BufferedInputStream(new FileInputStream(file)));
        } else {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
            if (stream == null) {
                stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("/" + filename);
            }
            if (stream == null) {
                throw new FileNotFoundException(filename);
            }
            this.redirStream = new IncludeInputStream(new BufferedInputStream(stream));
        }
        return this.redirStream.read();
    }

    protected String convertRelativePath(String filename) {
        String newFilename = null;
        try {
            Method method = FACES_CONTEXT.getMethod("getCurrentInstance", null);
            Object ctx = method.invoke(null, (Object[])null);
            method = ctx.getClass().getMethod("getExternalContext", null);
            ctx = method.invoke(ctx, (Object[])null);
            method = ctx.getClass().getMethod("getContext", null);
            ctx = method.invoke(ctx, (Object[])null);
            method = ctx.getClass().getMethod("getRealPath", GET_REAL_PATH_ARGS);
            newFilename = (String)method.invoke(ctx, filename);
            if (!new File(newFilename).exists()) {
                newFilename = filename;
            }
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return newFilename;
    }

    public static void main(String[] args) {
        try {
            IncludeInputStream stream = new IncludeInputStream(new FileInputStream(args[0]));
            int ch = 10;
            while (ch != -1) {
                System.out.print((char)ch);
                ch = stream.read();
            }
        }
        catch (IOException ex) {
            LogUtil.severe(null, ex);
        }
    }

    private static Class getFacesContextClass() {
        try {
            return Class.forName("jakarta.faces.context.FacesContext");
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }
}

