/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup.util;

import com.sun.enterprise.util.OS;
import java.io.File;

public class BackupUtils {
    private BackupUtils() {
    }

    public static boolean protect(File f) {
        if (!f.exists()) {
            return true;
        }
        try {
            File[] files = null;
            boolean ret = true;
            if (f.isDirectory()) {
                if (!f.setExecutable(true, true)) {
                    ret = false;
                }
                if (!f.setReadable(true, true)) {
                    ret = false;
                }
                if (!f.setWritable(true, true)) {
                    ret = false;
                }
                if ((files = f.listFiles()) == null || files.length < 1) {
                    return ret;
                }
            } else {
                files = new File[]{f};
            }
            for (File file : files) {
                if (file.isDirectory()) {
                    if (!file.setExecutable(true, false)) {
                        ret = false;
                    }
                    if (!file.setReadable(true, false)) {
                        ret = false;
                    }
                    if (file.setWritable(true, true)) continue;
                    ret = false;
                    continue;
                }
                if (!file.setExecutable(false, false)) {
                    ret = false;
                }
                if (!file.setReadable(true, true)) {
                    ret = false;
                }
                if (file.setWritable(true, true)) continue;
                ret = false;
            }
            return ret;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean makeExecutable(File f) {
        if (!OS.isUNIX()) {
            return true;
        }
        if (!f.exists()) {
            return true;
        }
        if (!f.isDirectory()) {
            return BackupUtils.makeExecutable(new File[]{f});
        }
        return BackupUtils.makeExecutable(f.listFiles());
    }

    private static boolean makeExecutable(File[] files) {
        boolean ret = true;
        if (files == null || files.length <= 0) {
            return true;
        }
        for (File f : files) {
            if (!f.setExecutable(true, true)) {
                ret = false;
            }
            if (!f.setReadable(true, false)) {
                ret = false;
            }
            if (f.setWritable(false, false)) continue;
            ret = false;
        }
        return ret;
    }
}

