/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import jakarta.enterprise.inject.CreationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.security.GetDeclaredConstructorAction;
import org.jboss.weld.security.NewInstanceAction;

class Exceptions {
    private Exceptions() {
    }

    private static void rethrowException(Throwable t, Class<? extends RuntimeException> exceptionToThrow) {
        RuntimeException e;
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        try {
            e = (RuntimeException)AccessController.doPrivileged(NewInstanceAction.of((Constructor)((Object)AccessController.doPrivileged(GetDeclaredConstructorAction.of(exceptionToThrow, new Class[0]))), new Object[0]));
        }
        catch (PrivilegedActionException ex) {
            throw new WeldException(ex.getCause());
        }
        e.initCause(t);
        throw e;
    }

    private static void rethrowException(Throwable t) {
        Exceptions.rethrowException(t, CreationException.class);
    }

    public static void rethrowException(IllegalArgumentException e) {
        Exceptions.rethrowException(e.getCause() != null ? e.getCause() : e);
    }

    public static void rethrowException(IllegalArgumentException e, Class<? extends RuntimeException> exceptionToThrow) {
        Exceptions.rethrowException(e.getCause() != null ? e.getCause() : e, exceptionToThrow);
    }

    public static void rethrowException(InstantiationException e, Class<? extends RuntimeException> exceptionToThrow) {
        Exceptions.rethrowException(e.getCause() != null ? e.getCause() : e, exceptionToThrow);
    }

    public static void rethrowException(InstantiationException e) {
        Exceptions.rethrowException(e.getCause() != null ? e.getCause() : e);
    }

    public static void rethrowException(IllegalAccessException e) {
        Exceptions.rethrowException(e.getCause() != null ? e.getCause() : e);
    }

    public static void rethrowException(IllegalAccessException e, Class<? extends RuntimeException> exceptionToThrow) {
        Exceptions.rethrowException(e.getCause() != null ? e.getCause() : e, exceptionToThrow);
    }

    public static void rethrowException(InvocationTargetException e, Class<? extends RuntimeException> exceptionToThrow) {
        Exceptions.rethrowException(e.getCause() != null ? e.getCause() : e, exceptionToThrow);
    }

    public static void rethrowException(SecurityException e, Class<? extends RuntimeException> exceptionToThrow) {
        Exceptions.rethrowException(e.getCause() != null ? e.getCause() : e, exceptionToThrow);
    }

    public static void rethrowException(NoSuchMethodException e, Class<? extends RuntimeException> exceptionToThrow) {
        Exceptions.rethrowException(e.getCause() != null ? e.getCause() : e, exceptionToThrow);
    }

    public static void rethrowException(InvocationTargetException e) {
        Exceptions.rethrowException(e.getCause() != null ? e.getCause() : e);
    }
}

