/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import java.util.ArrayList;
import java.util.List;

final class ExceptionAnalyzer {
    private final Exception exc;
    private final List<Throwable> chain;

    ExceptionAnalyzer(Exception e) {
        if (e == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.exc = e;
        this.chain = new ArrayList<Throwable>();
        this.chain.add(this.exc);
        this.build();
    }

    private void build() {
        for (Throwable t = this.exc.getCause(); t != null; t = t.getCause()) {
            this.chain.add(t);
        }
    }

    Throwable getFirstInstanceOf(Class<? extends Exception> ac) {
        for (Throwable t : this.chain) {
            try {
                ac.cast(t);
                return t;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return null;
    }
}

