/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.FieldConfig;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.function.Predicate;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.AnnotationProxy;
import org.jboss.weld.lite.extension.translator.FieldInfoImpl;

class FieldConfigImpl
implements FieldConfig {
    private final AnnotatedFieldConfigurator<?> configurator;
    private final BeanManager bm;

    FieldConfigImpl(AnnotatedFieldConfigurator<?> configurator, BeanManager bm) {
        this.configurator = configurator;
        this.bm = bm;
    }

    @Override
    public FieldInfo info() {
        return new FieldInfoImpl(this.configurator.getAnnotated(), this.bm);
    }

    @Override
    public FieldConfig addAnnotation(Class<? extends Annotation> annotationType) {
        this.configurator.add(AnnotationProxy.create(annotationType, Collections.emptyMap()));
        return this;
    }

    @Override
    public FieldConfig addAnnotation(AnnotationInfo annotation) {
        this.configurator.add(((AnnotationInfoImpl)annotation).annotation);
        return this;
    }

    @Override
    public FieldConfig addAnnotation(Annotation annotation) {
        this.configurator.add(annotation);
        return this;
    }

    @Override
    public FieldConfig removeAnnotation(Predicate<AnnotationInfo> predicate) {
        this.configurator.remove(annotation -> predicate.test(new AnnotationInfoImpl((Annotation)annotation, this.bm)));
        return this;
    }

    @Override
    public FieldConfig removeAllAnnotations() {
        this.configurator.removeAll();
        return this;
    }
}

