/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.IntExpression;
import org.glassfish.rmic.tools.tree.LongExpression;
import org.glassfish.rmic.tools.tree.UnaryExpression;

public class BitNotExpression
extends UnaryExpression {
    public BitNotExpression(long where, Expression right) {
        super(38, where, right.type, right);
    }

    @Override
    void selectType(Environment env, Context ctx, int tm) {
        this.type = (tm & 0x20) != 0 ? Type.tLong : Type.tInt;
        this.right = this.convert(env, ctx, this.type, this.right);
    }

    @Override
    Expression eval(int a) {
        return new IntExpression(this.where, ~a);
    }

    @Override
    Expression eval(long a) {
        return new LongExpression(this.where, a ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    Expression simplify() {
        if (this.right.op == 38) {
            return ((BitNotExpression)this.right).right;
        }
        return this;
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        this.right.codeValue(env, ctx, asm);
        if (this.type.isType(4)) {
            asm.add(this.where, 18, -1);
            asm.add(this.where, 130);
        } else {
            asm.add(this.where, 20, -1L);
            asm.add(this.where, 131);
        }
    }
}

