/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.adapter;

import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.ws.rs.core.Feature;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.admin.rest.JavadocWadlGeneratorConfig;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.RestResource;
import org.glassfish.admin.rest.adapter.AbstractRestResourceProvider;
import org.glassfish.admin.rest.adapter.ExceptionFilter;
import org.glassfish.admin.rest.generator.ASMResourcesGenerator;
import org.glassfish.admin.rest.provider.ActionReportResultHtmlProvider;
import org.glassfish.admin.rest.provider.ActionReportResultJsonProvider;
import org.glassfish.admin.rest.provider.ActionReportResultXmlProvider;
import org.glassfish.admin.rest.provider.AdminCommandStateJsonProvider;
import org.glassfish.admin.rest.provider.CollectionWriter;
import org.glassfish.admin.rest.provider.FormWriter;
import org.glassfish.admin.rest.provider.GetResultListHtmlProvider;
import org.glassfish.admin.rest.provider.GetResultListJsonProvider;
import org.glassfish.admin.rest.provider.GetResultListXmlProvider;
import org.glassfish.admin.rest.provider.JsonStringReaderWriter;
import org.glassfish.admin.rest.provider.MapWriter;
import org.glassfish.admin.rest.provider.OptionsResultJsonProvider;
import org.glassfish.admin.rest.provider.OptionsResultXmlProvider;
import org.glassfish.admin.rest.provider.ProgressStatusEventJsonProvider;
import org.glassfish.admin.rest.provider.ProgressStatusJsonProvider;
import org.glassfish.admin.rest.provider.ResponseBodyWriter;
import org.glassfish.admin.rest.provider.RestCollectionProvider;
import org.glassfish.admin.rest.provider.RestModelWriter;
import org.glassfish.admin.rest.readers.FormReader;
import org.glassfish.admin.rest.readers.JsonHashMapProvider;
import org.glassfish.admin.rest.readers.JsonParameterMapProvider;
import org.glassfish.admin.rest.readers.JsonPropertyListReader;
import org.glassfish.admin.rest.readers.ParameterMapFormReader;
import org.glassfish.admin.rest.readers.RestModelListReader;
import org.glassfish.admin.rest.readers.RestModelReader;
import org.glassfish.admin.rest.readers.XmlHashMapProvider;
import org.glassfish.admin.rest.readers.XmlPropertyListReader;
import org.glassfish.admin.rest.resources.GeneratorResource;
import org.glassfish.admin.rest.resources.SessionsResource;
import org.glassfish.admin.rest.resources.StaticResource;
import org.glassfish.admin.rest.resources.StatusGenerator;
import org.glassfish.admin.rest.resources.custom.ManagementProxyResource;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jersey.media.sse.SseFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;

public class RestManagementResourceProvider
extends AbstractRestResourceProvider {
    @Override
    public Feature getJsonFeature() {
        RestLogging.restLogger.log(Level.SEVERE, "Hey, you... FIX ME!!! {0}", RestManagementResourceProvider.class.getName());
        return super.getJsonFeature();
    }

    @Override
    public String getContextRoot() {
        return "/management";
    }

    @Override
    public ResourceConfig getResourceConfig(Set<Class<?>> classes, ServerContext serverContext, ServiceLocator serviceLocator, Set<? extends Binder> additionalBinders) throws EndpointRegistrationException {
        ResourceConfig rc = super.getResourceConfig(classes, serverContext, serviceLocator, additionalBinders);
        RestLogging.restLogger.log(Level.FINEST, () -> "Extending binding configuration with " + String.valueOf(this));
        this.registerExtendedWadlConfig(classes, rc, serviceLocator);
        rc.register(ExceptionFilter.class);
        rc.property("jersey.config.server.resource.validation.disable", (Object)Boolean.TRUE);
        return rc;
    }

    @Override
    public Set<Class<?>> getResourceClasses(ServiceLocator serviceLocator) {
        this.generateASM(serviceLocator);
        Class<?> domainResourceClass = null;
        try {
            domainResourceClass = Class.forName("org.glassfish.admin.rest.resources.generatedASM.DomainResource");
        }
        catch (ClassNotFoundException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        HashSet r = new HashSet();
        this.addCompositeResources(r, serviceLocator);
        if ("true".equals(System.getenv("REST_DEBUG"))) {
            r.add(GeneratorResource.class);
        }
        r.add(StatusGenerator.class);
        r.add(domainResourceClass);
        r.add(ManagementProxyResource.class);
        r.add(SessionsResource.class);
        r.add(StaticResource.class);
        r.add(RestModelReader.class);
        r.add(RestModelListReader.class);
        r.add(FormReader.class);
        r.add(ParameterMapFormReader.class);
        r.add(JsonHashMapProvider.class);
        r.add(JsonPropertyListReader.class);
        r.add(JsonParameterMapProvider.class);
        r.add(XmlHashMapProvider.class);
        r.add(XmlPropertyListReader.class);
        r.add(ActionReportResultHtmlProvider.class);
        r.add(ActionReportResultJsonProvider.class);
        r.add(ActionReportResultXmlProvider.class);
        r.add(CollectionWriter.class);
        r.add(MapWriter.class);
        r.add(ResponseBodyWriter.class);
        r.add(RestCollectionProvider.class);
        r.add(RestModelWriter.class);
        r.add(FormWriter.class);
        r.add(GetResultListHtmlProvider.class);
        r.add(GetResultListJsonProvider.class);
        r.add(GetResultListXmlProvider.class);
        r.add(JsonStringReaderWriter.class);
        r.add(OptionsResultJsonProvider.class);
        r.add(OptionsResultXmlProvider.class);
        r.add(SseFeature.class);
        r.add(AdminCommandStateJsonProvider.class);
        r.add(ProgressStatusJsonProvider.class);
        r.add(ProgressStatusEventJsonProvider.class);
        return r;
    }

    private void registerExtendedWadlConfig(Set<Class<?>> classes, ResourceConfig rc, ServiceLocator serviceLocator) {
        List handles = serviceLocator.getAllServiceHandles(JavadocWadlGeneratorConfig.class, new Annotation[0]);
        for (ServiceHandle handle : handles) {
            ActiveDescriptor ad = handle.getActiveDescriptor();
            if (!ad.isReified()) {
                ad = serviceLocator.reifyDescriptor((Descriptor)ad);
            }
            Class implementationClass = ad.getImplementationClass();
            rc.property("jersey.config.server.wadl.generatorConfig", (Object)implementationClass.getName());
            classes.add(implementationClass);
        }
    }

    private void generateASM(ServiceLocator habitat) {
        try {
            Domain entity = (Domain)habitat.getService(Domain.class, new Annotation[0]);
            Dom dom = Dom.unwrap((ConfigBeanProxy)entity);
            ASMResourcesGenerator resourcesGenerator = new ASMResourcesGenerator(habitat);
            resourcesGenerator.generateSingle(dom.document.getRoot().model, dom.document);
            resourcesGenerator.endGeneration();
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
    }

    private void addCompositeResources(Set<Class<?>> r, ServiceLocator locator) {
        List handles = locator.getAllServiceHandles(RestResource.class, new Annotation[0]);
        for (ServiceHandle handle : handles) {
            ActiveDescriptor ad = handle.getActiveDescriptor();
            if (!ad.isReified()) {
                ad = locator.reifyDescriptor((Descriptor)ad);
            }
            r.add(ad.getImplementationClass());
        }
    }
}

