/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core.reference;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.ReferenceElement;
import com.sun.xml.wss.impl.XMLUtil;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectReference
extends ReferenceElement {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public DirectReference() throws XWSSecurityException {
        try {
            this.setSOAPElement(soapFactory.createElement("Reference", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"));
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0750.soap.exception", new Object[]{"wsse:Reference", e.getMessage()});
            throw new XWSSecurityException(e);
        }
    }

    public DirectReference(SOAPElement element, boolean isBSP) throws XWSSecurityException {
        this.setSOAPElement(element);
        if (!element.getLocalName().equals("Reference") || !XMLUtil.inWsseNS(element)) {
            log.log(Level.SEVERE, "WSS0751.invalid.direct.reference", "{" + element.getNamespaceURI() + "}" + element.getLocalName());
            throw new XWSSecurityException("Invalid DirectReference passed");
        }
        if (isBSP && this.getURI() == null) {
            throw new XWSSecurityException("Violation of BSP R3062: A wsse:Reference element in a SECURITY_TOKEN_REFERENCE MUST specify a URI attribute");
        }
    }

    public DirectReference(SOAPElement element) throws XWSSecurityException {
        this(element, false);
    }

    public String getValueType() {
        String valueType = this.getAttribute("ValueType");
        if (valueType.equals("")) {
            return null;
        }
        return valueType;
    }

    public void setValueType(String valueType) {
        this.setAttribute("ValueType", valueType);
    }

    public String getURI() {
        String uri = this.getAttribute("URI");
        if (uri.equals("")) {
            return null;
        }
        return uri;
    }

    public void setURI(String uri) {
        this.setAttribute("URI", uri);
    }

    public void setSCTURI(String uri, String instance) {
        this.setAttribute("URI", uri);
        this.setAttribute("ValueType", "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
    }
}

