/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.stereotype.priority;

import jakarta.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.stereotype.priority.Bar;
import org.jboss.cdi.tck.tests.definition.stereotype.priority.BarExtended;
import org.jboss.cdi.tck.tests.definition.stereotype.priority.Baz;
import org.jboss.cdi.tck.tests.definition.stereotype.priority.BazAlternative2;
import org.jboss.cdi.tck.tests.definition.stereotype.priority.Charlie;
import org.jboss.cdi.tck.tests.definition.stereotype.priority.CharlieAlternative;
import org.jboss.cdi.tck.tests.definition.stereotype.priority.Foo;
import org.jboss.cdi.tck.tests.definition.stereotype.priority.FooAlternative;
import org.jboss.cdi.tck.tests.definition.stereotype.priority.Qux;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.0")
public class StereotypeWithPriorityTest
extends AbstractTest {
    @Inject
    Foo foo;
    @Inject
    Bar bar;
    @Inject
    Baz baz;
    @Inject
    Charlie charlie;
    @Inject
    Qux qux;

    @Deployment
    public static WebArchive deploy() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(StereotypeWithPriorityTest.class)).withBeansXml(new BeansXml())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="stereotypes", id="ac"), @SpecAssertion(section="declaring_stereotype_with_priority", id="a")})
    public void testStereotypeWithPriority() {
        Assert.assertEquals((String)this.foo.ping(), (String)FooAlternative.class.getSimpleName());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="stereotypes", id="ac"), @SpecAssertion(section="declaring_stereotype_with_priority", id="a"), @SpecAssertion(section="alternative_stereotype", id="a")})
    public void testStereotypeWithAlternativeAndPriority() {
        Assert.assertEquals((String)this.bar.ping(), (String)BarExtended.class.getSimpleName());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="stereotypes", id="ac"), @SpecAssertion(section="declaring_stereotype_with_priority", id="a"), @SpecAssertion(section="alternative_stereotype", id="a", note="PriorityStereotype overrides BazAlternative")})
    public void testBeanPriorityFromStereotypeOverridesOtherAlternative() {
        Assert.assertEquals((String)this.baz.ping(), (String)BazAlternative2.class.getSimpleName());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="stereotypes", id="ac"), @SpecAssertion(section="declaring_selected_alternatives_application", id="aa")})
    public void testBeanOverridesPriorityFromStereotype() {
        Assert.assertEquals((String)this.charlie.ping(), (String)CharlieAlternative.class.getSimpleName());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="stereotypes", id="ac"), @SpecAssertion(section="declaring_stereotype_with_priority", id="a"), @SpecAssertion(section="reserve_stereotype", id="a")})
    public void testStereotypeWithReserveAndPriority() {
        Assert.assertEquals((String)this.qux.ping(), (String)Qux.class.getSimpleName());
    }
}

