/**
 * 
 */
package org.eclipse.e4.emf.ecore.javascript;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DependencyTracker {

	private class EObjectFeatureDependency extends AdapterImpl {
		private EObject eObject;
		private EStructuralFeature feature;
		private Object value;

		public EObjectFeatureDependency(EObject eObject, EStructuralFeature feature, Object value) {
			super();
			this.eObject = eObject;
			this.feature = feature;
		}

		void attach() {
			eObject.eAdapters().add(this);
		}
		void dispose() {
			eObject.eAdapters().remove(this);
			eObject = null;
			feature = null;
			value = null;
		}

		public void notifyChanged(Notification notification) {
			if (dependencyListener != null && (! dependencyListener.isDisposed())) {
				if (notification.getNotifier() == eObject && notification.getFeature() == feature) {
					dependencyListener.notifyDependent(eObject, feature, notification.getNewValue(), DependencyTracker.this);
				}
			}
		}
	}

	private DependencyListener dependencyListener = null;

	public interface DependencyListener {
		public void notifyDependent(EObject eObject, EStructuralFeature feature, Object value, DependencyTracker dependencyTracker);
		public boolean isNotifyAsync();
		public boolean isDisposed();
	}
	public static class DependencyAdapter implements DependencyListener {
		public void notifyDependent(EObject eObject, EStructuralFeature feature, Object value, DependencyTracker dependencyTracker) {
			notifyDependent(dependencyTracker);
		}
		protected void notifyDependent(DependencyTracker dependencyTracker) {
		}
		public boolean isNotifyAsync() {
			return false;
		}
		private boolean disposed = false;
		protected void dispose() {
			disposed = true;
		}
		public boolean isDisposed() {
			return disposed;
		}
	}

	private List<EObjectFeatureDependency> attachedDependencies = new ArrayList<EObjectFeatureDependency>();
	private List<EObjectFeatureDependency> newDependencies = null;

	public void startAddingDependencies() {
		newDependencies = new ArrayList<EObjectFeatureDependency>();
	}

	public void stopAddingDependencies(DependencyListener dependencyListener) {
		if (newDependencies != null) {
			this.dependencyListener = dependencyListener;
			if (dependencyListener != null) {
				for (Iterator<EObjectFeatureDependency> it = newDependencies.iterator(); it.hasNext();) {
					EObjectFeatureDependency dependency = (EObjectFeatureDependency)it.next();
					dependency.attach();
					attachedDependencies.add(dependency);
				}
			}
			newDependencies = null;
		}
	}

	public void addDependency(EObject eObject, EStructuralFeature feature, Object value) {
		if (newDependencies != null) {
			EObjectFeatureDependency dependency = new EObjectFeatureDependency(eObject, feature, value);
			newDependencies.add(dependency);
		}
	}

	public void clearDependencies() {
		for (Iterator<EObjectFeatureDependency> it = attachedDependencies.iterator(); it.hasNext();) {
			EObjectFeatureDependency dependency = (EObjectFeatureDependency)it.next();
			dependency.dispose();
		}
		attachedDependencies.clear();
		if (newDependencies != null) {
			for (Iterator<EObjectFeatureDependency> it = newDependencies.iterator(); it.hasNext();) {
				EObjectFeatureDependency dependency = (EObjectFeatureDependency)it.next();
				dependency.dispose();
			}
			newDependencies = null;
		}
		dependencyListener = null;
	}
}
