package org.eclipse.e4.tools.emf.editor3x;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ModelEditorPreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {
	private BooleanFieldEditor fAutoGeneratedId;
	private BooleanFieldEditor fShowXMIId;
	private ColorFieldEditor fColorValueNotRendered;
	private ColorFieldEditor fColorValueNotVisible;
	private ColorFieldEditor fColorValueNotVisibleAndRendered;

	public ModelEditorPreferencePage() {
	}

	public ModelEditorPreferencePage(String title) {
		super(title);
	}

	public ModelEditorPreferencePage(String title, ImageDescriptor image) {
		super(title, image);
	}

	public void init(IWorkbench workbench) {
		setPreferenceStore(new ScopedPreferenceStore(InstanceScope.INSTANCE,"org.eclipse.e4.tools.emf.ui"));
	}

	@Override
	protected Control createContents(Composite parent) {
		Composite result = new Composite(parent, SWT.NONE);
		result.setLayout(new GridLayout());
		
		{
			fColorValueNotRendered = new ColorFieldEditor("notRenderedColor", "Not rendered color", result);
			fColorValueNotRendered.setPage(this);
			fColorValueNotRendered.setPreferenceStore(getPreferenceStore());
			fColorValueNotRendered.load();			
		}

		{
			fColorValueNotVisible = new ColorFieldEditor("notVisibleColor", "Not visible color", result);
			fColorValueNotVisible.setPage(this);
			fColorValueNotVisible.setPreferenceStore(getPreferenceStore());
			fColorValueNotVisible.load();			
		}
		
		{
			fColorValueNotVisibleAndRendered = new ColorFieldEditor("notVisibleAndRenderedColor", "Not visible and not rendered color", result);
			fColorValueNotVisibleAndRendered.setPage(this);
			fColorValueNotVisibleAndRendered.setPreferenceStore(getPreferenceStore());
			fColorValueNotVisibleAndRendered.load();			
		}
		
		{
			Composite container = new Composite(result, SWT.NONE);
			container.setLayoutData(new GridData(GridData.FILL,GridData.CENTER,false,false,2,1));
			fAutoGeneratedId = new BooleanFieldEditor("autoCreateElementId", "Autogenerate Element-Id", container);
			fAutoGeneratedId.setPage(this);
			fAutoGeneratedId.setPreferenceStore(getPreferenceStore());
			fAutoGeneratedId.load();			
		}
		
		{
			Composite container = new Composite(result, SWT.NONE);
			container.setLayoutData(new GridData(GridData.FILL,GridData.CENTER,false,false,2,1));
			fShowXMIId = new BooleanFieldEditor("showXMIId", "Show XMI:ID", container);
			fShowXMIId.setPage(this);
			fShowXMIId.setPreferenceStore(getPreferenceStore());
			fShowXMIId.load();			
		}
		
		return result;
	}

	@Override
	public boolean performOk() {
		fAutoGeneratedId.store();
		fShowXMIId.store();
		fColorValueNotRendered.store();
		fColorValueNotVisible.store();
		fColorValueNotVisibleAndRendered.store();
		return super.performOk();
	}

	@Override
	protected void performDefaults() {
		fAutoGeneratedId.loadDefault();
		fShowXMIId.loadDefault();
		fColorValueNotRendered.loadDefault();
		fColorValueNotVisible.loadDefault();
		fColorValueNotVisibleAndRendered.loadDefault();
		super.performDefaults();
	}
	
	@Override
	public void dispose() {
		super.dispose();
	}
}
