/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.animation;

import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.animation.KeyTimeType;
import org.eclipse.e4.xwt.animation.TimeSpan;

public class KeyTime {
    private TimeSpan timeSpan;
    private double percent;
    private KeyTimeType type;
    public static KeyTime Paced = new KeyTime(KeyTimeType.Paced);
    public static KeyTime Uniform = new KeyTime(KeyTimeType.Uniform);

    protected KeyTime(KeyTimeType type) {
        this.type = type;
    }

    protected KeyTime(String content) {
        if (content.endsWith("%")) {
            this.type = KeyTimeType.Percent;
            return;
        }
        int index = content.indexOf(":");
        if (index != -1) {
            this.type = KeyTimeType.TimeSpan;
            this.timeSpan = TimeSpan.parse(content);
            return;
        }
        throw new XWTException("Wrong syntax: " + content);
    }

    public TimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    public double getPercent() {
        return this.percent;
    }

    public KeyTimeType getType() {
        return this.type;
    }

    public static KeyTime fromString(String content) {
        if ("Paced".equalsIgnoreCase(content)) {
            return Paced;
        }
        if ("Uniform".equalsIgnoreCase(content)) {
            return Uniform;
        }
        return new KeyTime(content);
    }
}

