/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.deeplink.api;

import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.deeplink.api.Activator;
import org.eclipse.e4.core.deeplink.api.ParameterProcessResults;

public abstract class AbstractDeepLinkInstanceHandler {
    public abstract Map<String, String> activate(String var1, String var2, Map<String, String[]> var3);

    public void handle(ParameterProcessResults[] results, String handlerInstanceId, String action, Map<String, String[]> params) {
        this.debug("Command received: " + handlerInstanceId);
        this.debug("Running action for app: " + handlerInstanceId);
        try {
            results[0].outputData = this.activate(handlerInstanceId, action, params);
            results[0].activatedParameterCallback = true;
        }
        catch (Throwable t) {
            this.error(handlerInstanceId);
            this.rethrowException(t);
        }
    }

    protected IStatus status(int severity, String message) {
        return new Status(severity, "org.eclipse.e4.core.deeplink.handler", message);
    }

    protected void error(String message) {
        this.getLog().log(this.status(4, message));
    }

    protected void info(String message) {
        this.getLog().log(this.status(1, message));
    }

    protected void debug(String message) {
        this.getLog().log(this.status(2, message));
    }

    private ILog getLog() {
        return Activator.getDefault().getLog();
    }

    private void rethrowException(Throwable terminatingException) {
        if (terminatingException != null) {
            if (!(terminatingException instanceof RuntimeException)) {
                throw new RuntimeException(terminatingException);
            }
            throw (RuntimeException)terminatingException;
        }
    }
}

