/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.core.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.platform.discovery.core.api.ISearchConsoleMasterController;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.core.api.SearchEvent;
import org.eclipse.platform.discovery.core.internal.ISearchSession;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleController;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleControllerOutputView;
import org.eclipse.platform.discovery.core.internal.events.handlers.ISearchEventHandler;
import org.eclipse.platform.discovery.core.internal.plugin.text.DiscoveryCoreMessages;
import org.eclipse.platform.discovery.runtime.api.GroupingHierarchy;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchParameters;
import org.eclipse.platform.discovery.runtime.api.ISearchProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchQuery;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.api.SearchCancelledException;
import org.eclipse.platform.discovery.runtime.api.SearchFailedException;
import org.eclipse.platform.discovery.runtime.internal.DestinationCategoryNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.impl.DescriptionsUtil;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDescriptionsUtil;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.internal.session.ISessionManager;

public class SearchConsoleController
implements ISearchConsoleMasterController,
ISearchConsoleController {
    private final ISearchProviderConfiguration searchProviderConfiguration;
    private final ISearchConsoleControllerOutputView view;
    private final IDescriptionsUtil descriptionsUtil;
    private final IDiscoveryEnvironment consoleEnv;
    private final ISessionManager<ISearchSession> sessionManager;
    private final String defaultSessionId;

    public SearchConsoleController(ISearchProviderConfiguration providerConfiguration, ISearchConsoleControllerOutputView searchConsoleView, IDiscoveryEnvironment consoleEnv, ISessionManager<ISearchSession> sessionManager, String defaultSessionId) {
        this.searchProviderConfiguration = providerConfiguration;
        this.view = searchConsoleView;
        this.descriptionsUtil = new DescriptionsUtil(this.searchProviderConfiguration);
        this.consoleEnv = consoleEnv;
        this.sessionManager = sessionManager;
        this.defaultSessionId = defaultSessionId;
        this.view.showObjectTypes(this.searchProviderConfiguration.getObjectTypes());
    }

    @Override
    public void objectTypeSelected(IObjectTypeDescription selectedObject) {
        if (selectedObject == null) {
            return;
        }
        Set destinationCategories = this.searchProviderConfiguration.getAvailableDestinationCategoriesForObjectType(selectedObject);
        this.view.showDestinationsCategories(destinationCategories);
    }

    @Override
    public void search(SearchEvent event) throws ProviderNotFoundException, SearchFailedException {
        this.createSearchEventHandler().handleSearch(event);
    }

    protected ISearchEventHandler createSearchEventHandler() {
        return new SearchEventHandler();
    }

    @Override
    public void searchDestinationsChanged() {
        this.view.updateDestinationsSelector();
    }

    @Override
    public void searchDestinationSelected(IObjectTypeDescription objectType, ISearchDestination selectedDestination) {
        this.updateGroupHierarchies(objectType, selectedDestination);
    }

    @Override
    public void subdestinationActivationChanged(IObjectTypeDescription searchObjectType, ISearchDestination searchDestination, ISearchSubdestination subDestination, boolean newActivationState) {
        this.updateGroupHierarchies(searchObjectType, searchDestination);
    }

    private IDestinationCategoryDescription getDestinationCategory(ISearchDestination destination) {
        try {
            return (IDestinationCategoryDescription)this.searchProviderConfiguration.getDestinationCategoriesForDestination(destination).iterator().next();
        }
        catch (DestinationCategoryNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private Set<ISearchSubdestination> filterActiveSubdestinations(Set<ISearchSubdestination> allSubdestinations, IObjectTypeDescription objectType, IDestinationCategoryDescription destCategory, ISearchProviderDescription searchProvider) {
        HashSet<ISearchSubdestination> result = new HashSet<ISearchSubdestination>();
        for (ISearchSubdestination subDest : allSubdestinations) {
            if (!this.searchProviderConfiguration.isSubdestinationActive(subDest, objectType, destCategory, searchProvider)) continue;
            result.add(subDest);
        }
        return result;
    }

    private void updateGroupHierarchies(IObjectTypeDescription objectType, ISearchDestination destination) {
        if (objectType != null && destination != null) {
            this.view.showGroupingHierarchies(this.determineGroupingHierarchy(objectType, destination));
        } else {
            this.view.showGroupingHierarchies(new HashSet<GroupingHierarchy>());
        }
    }

    private Set<GroupingHierarchy> determineGroupingHierarchy(IObjectTypeDescription objectType, ISearchDestination destination) {
        try {
            ISearchProviderDescription searchProviderDescr = this.searchProviderConfiguration.getActiveSearchProvider(objectType, this.getDestinationCategory(destination));
            ISearchProvider providerInstance = searchProviderDescr.createInstance();
            Set allSubdestintations = this.searchProviderConfiguration.getAvailableSearchSubdestinations(objectType, this.getDestinationCategory(destination), searchProviderDescr);
            Set<ISearchSubdestination> activeSubdestinations = this.filterActiveSubdestinations(allSubdestintations, objectType, this.getDestinationCategory(destination), searchProviderDescr);
            return providerInstance.getGroupingHierarchies(destination, activeSubdestinations);
        }
        catch (ProviderNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public IDiscoveryEnvironment getEnvironment() {
        return this.consoleEnv;
    }

    private class SearchEventHandler
    implements ISearchEventHandler {
        private SearchEventHandler() {
        }

        @Override
        public void handleSearch(SearchEvent event) throws ProviderNotFoundException, SearchFailedException {
            Set<IDestinationCategoryDescription> destCategories = this.destinationCategories(event.getSearchParameters().getSearchDestination());
            IDestinationCategoryDescription category = destCategories.iterator().next();
            ISearchQuery searchQuery = this.createQuery(event.getSearchParameters());
            IObjectTypeDescription objectType = SearchConsoleController.this.descriptionsUtil.objectTypeForId(event.getSearchParameters().getObjectTypeId());
            ISearchProviderDescription searchProvider = this.searchProvider(objectType, category);
            try {
                ISearchContext sc = this.executeQuery(searchQuery, searchProvider, event);
                SearchConsoleController.this.view.showResult(sc);
            }
            catch (SearchCancelledException searchCancelledException) {
                SearchConsoleController.this.view.setStatusMessage(DiscoveryCoreMessages.SearchConsoleController_SEARCH_CANCELLED);
            }
        }

        private ISearchContext executeQuery(ISearchQuery searchQuery, final ISearchProviderDescription searchProvider, final SearchEvent event) throws SearchFailedException {
            final Object result = searchQuery.execute(SearchConsoleController.this.consoleEnv.operationRunner());
            ISearchContext sc = new ISearchContext(){
                private Map<Object, Object> data = new HashMap<Object, Object>();

                @Override
                public ISearchParameters searchParameters() {
                    return event.getSearchParameters();
                }

                @Override
                public String searchProviderId() {
                    return searchProvider.getId();
                }

                @Override
                public Object searchResult() {
                    return result;
                }

                @Override
                public ISearchSession session() {
                    return (ISearchSession)SearchConsoleController.this.sessionManager.session(event.sessionId(), this.historySize(event.sessionId()));
                }

                @Override
                public String description() {
                    return event.searchDescription();
                }

                @Override
                public String title() {
                    return event.searchTitle();
                }

                @Override
                public Map<Object, Object> data() {
                    return this.data;
                }

                private int historySize(String sessionId) {
                    return sessionId.equals(SearchConsoleController.this.defaultSessionId) ? 1 : 5;
                }
            };
            sc.session().historyTrack().track((Object)sc);
            return sc;
        }

        private Set<IDestinationCategoryDescription> destinationCategories(ISearchDestination destination) {
            Set destCategories;
            try {
                destCategories = SearchConsoleController.this.searchProviderConfiguration.getDestinationCategoriesForDestination(destination);
            }
            catch (DestinationCategoryNotFoundException e) {
                throw new IllegalStateException(e);
            }
            if (destCategories.size() != 1) {
                throw new IllegalStateException("One destination category expected, found " + destCategories.size());
            }
            return destCategories;
        }

        private ISearchQuery createQuery(ISearchParameters searchParams) throws ProviderNotFoundException {
            ISearchProviderDescription searchProvider = this.searchProvider(SearchConsoleController.this.descriptionsUtil.objectTypeForId(searchParams.getObjectTypeId()), this.destinationCategories(searchParams.getSearchDestination()).iterator().next());
            ISearchProvider searchProviderInstance = searchProvider.createInstance();
            return searchProviderInstance.createQuery(searchParams);
        }

        private ISearchProviderDescription searchProvider(IObjectTypeDescription objectType, IDestinationCategoryDescription category) throws ProviderNotFoundException {
            return SearchConsoleController.this.searchProviderConfiguration.getActiveSearchProvider(objectType, category);
        }
    }
}

