/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.nebula.properties.css2;

import org.eclipse.e4.ui.css.core.dom.properties.css2.AbstractCSSPropertyTextHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyTextHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.nebula.helpers.GalleryHelpers;
import org.eclipse.e4.ui.css.nebula.helpers.NebulaElementHelpers;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyTextNebulaHandler
extends AbstractCSSPropertyTextHandler {
    public static final ICSSPropertyTextHandler INSTANCE = new CSSPropertyTextNebulaHandler();

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!NebulaElementHelpers.isNebulaWidget(element)) {
            return false;
        }
        Widget widget = SWTElementHelpers.getWidget((Object)element);
        if (widget != null) {
            super.applyCSSProperty((Object)widget, property, value, pseudo, engine);
            return true;
        }
        return false;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        if (!NebulaElementHelpers.isNebulaWidget(element)) {
            return null;
        }
        Widget widget = SWTElementHelpers.getWidget((Object)element);
        if (widget != null) {
            return super.retrieveCSSProperty((Object)widget, property, pseudo, engine);
        }
        return null;
    }

    public void applyCSSPropertyColor(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = (Widget)element;
        if (value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)widget.getDisplay());
            if (widget instanceof GalleryItem) {
                GalleryItem galleryItem = (GalleryItem)widget;
                if ("selected".equals(pseudo)) {
                    GalleryHelpers.setSelectionForegroundColor(galleryItem.getParent(), newColor);
                } else {
                    galleryItem.setForeground(newColor);
                }
            } else if (widget instanceof Control) {
                ((Control)widget).setForeground(newColor);
            }
        }
    }

    public String retrieveCSSPropertyColor(Object element, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = (Widget)element;
        Color color = null;
        if (widget instanceof GalleryItem) {
            GalleryItem galleryItem = (GalleryItem)widget;
            color = "selected".equals(pseudo) ? GalleryHelpers.getSelectionForegroundColor(galleryItem.getParent()) : galleryItem.getForeground();
        }
        if (color != null) {
            return engine.convert(color, Color.class, null);
        }
        return null;
    }
}

