/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.tests;

import java.util.Collections;
import java.util.Map;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.commands.ParameterValuesException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.tests.TestActivator;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public class HandlerTest
extends TestCase {
    private static final String ACTIVE_INFO_ID = "activeInfo";
    private static final String TEST_ID3 = "test.id3";
    private static final String TEST_ID2 = "test.id2";
    private static final String TEST_ID1 = "test.id1";
    private static final String TEST_CAT1 = "test.cat1";
    private IEclipseContext workbenchContext;

    public void testCallHandler() throws Exception {
        EHandlerService hs = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        CallHandler handler = new CallHandler();
        hs.activateHandler(TEST_ID1, (Object)handler);
        HandlerTest.assertFalse((boolean)handler.q1);
        HandlerTest.assertFalse((boolean)handler.q2);
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        HandlerTest.assertTrue((boolean)hs.canExecute(cmd));
        HandlerTest.assertFalse((boolean)handler.q2);
        HandlerTest.assertEquals((Object)Boolean.TRUE, (Object)hs.executeHandler(cmd));
        HandlerTest.assertTrue((boolean)handler.q1);
        HandlerTest.assertTrue((boolean)handler.q2);
    }

    public void testDeactivateHandler() throws Exception {
        EHandlerService hs = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        CallHandler handler = new CallHandler();
        hs.activateHandler(TEST_ID1, (Object)handler);
        HandlerTest.assertFalse((boolean)handler.q1);
        HandlerTest.assertFalse((boolean)handler.q2);
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        HandlerTest.assertTrue((boolean)hs.canExecute(cmd));
        HandlerTest.assertFalse((boolean)handler.q2);
        hs.deactivateHandler(TEST_ID1, (Object)handler);
        HandlerTest.assertNull((Object)hs.executeHandler(cmd));
        HandlerTest.assertTrue((boolean)handler.q1);
        HandlerTest.assertFalse((boolean)handler.q2);
    }

    public void testActiveHandlerExecuteWorkbench() throws Exception {
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EHandlerService h1 = (EHandlerService)c1.get(EHandlerService.class.getName());
        CallHandler handler1 = new CallHandler();
        h1.activateHandler(TEST_ID1, (Object)handler1);
        ECommandService cs = (ECommandService)c1.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        HandlerTest.assertTrue((boolean)h1.canExecute(cmd));
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        HandlerTest.assertTrue((boolean)wHS.canExecute(cmd));
    }

    public void testQueryTwoHandlers() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EHandlerService h1 = (EHandlerService)c1.get(EHandlerService.class.getName());
        CallHandler handler1 = new CallHandler();
        h1.activateHandler(TEST_ID1, (Object)handler1);
        IEclipseContext c2 = this.workbenchContext.createChild("c2");
        EHandlerService h2 = (EHandlerService)c2.get(EHandlerService.class.getName());
        CallHandler handler2 = new CallHandler();
        h2.activateHandler(TEST_ID1, (Object)handler2);
        HandlerTest.assertFalse((boolean)handler1.q1);
        HandlerTest.assertFalse((boolean)handler2.q1);
        HandlerTest.assertEquals((Object)Boolean.TRUE, (Object)wHS.executeHandler(cmd));
        HandlerTest.assertTrue((boolean)handler1.q1);
        HandlerTest.assertTrue((boolean)handler1.q2);
        HandlerTest.assertFalse((boolean)handler2.q1);
        HandlerTest.assertFalse((boolean)handler2.q2);
    }

    public void testExecuteTwoActiveHandlers() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EHandlerService h1 = (EHandlerService)c1.get(EHandlerService.class.getName());
        CallHandler handler1 = new CallHandler();
        h1.activateHandler(TEST_ID1, (Object)handler1);
        IEclipseContext c2 = this.workbenchContext.createChild("c2");
        EHandlerService h2 = (EHandlerService)c2.get(EHandlerService.class.getName());
        CallHandler handler2 = new CallHandler();
        h2.activateHandler(TEST_ID1, (Object)handler2);
        HandlerTest.assertTrue((boolean)h1.canExecute(cmd));
        HandlerTest.assertTrue((boolean)handler1.q1);
        HandlerTest.assertFalse((boolean)handler2.q1);
        HandlerTest.assertTrue((boolean)h2.canExecute(cmd));
        HandlerTest.assertTrue((boolean)handler2.q1);
        HandlerTest.assertFalse((boolean)handler1.q2);
        HandlerTest.assertFalse((boolean)handler2.q2);
        HandlerTest.assertEquals((Object)Boolean.TRUE, (Object)wHS.executeHandler(cmd));
        HandlerTest.assertTrue((boolean)handler1.q2);
        HandlerTest.assertFalse((boolean)handler2.q2);
    }

    public void testSwitchActivationTwoHandlers() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EHandlerService h1 = (EHandlerService)c1.get(EHandlerService.class.getName());
        CallHandler handler1 = new CallHandler();
        h1.activateHandler(TEST_ID1, (Object)handler1);
        IEclipseContext c2 = this.workbenchContext.createChild("c2");
        EHandlerService h2 = (EHandlerService)c2.get(EHandlerService.class.getName());
        CallHandler handler2 = new CallHandler();
        h2.activateHandler(TEST_ID1, (Object)handler2);
        HandlerTest.assertFalse((boolean)handler1.q1);
        HandlerTest.assertFalse((boolean)handler2.q1);
        HandlerTest.assertEquals((Object)Boolean.TRUE, (Object)wHS.executeHandler(cmd));
        HandlerTest.assertTrue((boolean)handler1.q1);
        HandlerTest.assertTrue((boolean)handler1.q2);
        HandlerTest.assertFalse((boolean)handler2.q1);
        HandlerTest.assertFalse((boolean)handler2.q2);
        handler1.q1 = false;
        handler1.q2 = false;
        c2.activate();
        HandlerTest.assertEquals((Object)Boolean.TRUE, (Object)wHS.executeHandler(cmd));
        HandlerTest.assertTrue((boolean)handler2.q1);
        HandlerTest.assertTrue((boolean)handler2.q2);
        HandlerTest.assertFalse((boolean)handler1.q1);
        HandlerTest.assertFalse((boolean)handler1.q2);
    }

    public void testMethodInfo() throws Exception {
        Info helloInfo = new Info("Hello");
        this.workbenchContext.set(Info.class.getName(), (Object)helloInfo);
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        HandlerWithInfo handler = new HandlerWithInfo();
        wHS.activateHandler(TEST_ID1, (Object)handler);
        HandlerTest.assertEquals((Object)helloInfo, (Object)wHS.executeHandler(cmd));
    }

    public void testMethodWithAnnocation() throws Exception {
        Info helloInfo = new Info("Hello");
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        HandlerWithAnnotations handler = new HandlerWithAnnotations();
        wHS.activateHandler(TEST_ID1, (Object)handler);
        this.workbenchContext.set(Info.class.getName(), (Object)helloInfo);
        HandlerTest.assertNull((Object)wHS.executeHandler(cmd));
        this.workbenchContext.remove(Info.class.getName());
        HandlerTest.assertNull((Object)wHS.executeHandler(cmd));
        this.workbenchContext.set(ACTIVE_INFO_ID, (Object)helloInfo);
        HandlerTest.assertEquals((Object)helloInfo, (Object)wHS.executeHandler(cmd));
        this.workbenchContext.remove(ACTIVE_INFO_ID);
        HandlerTest.assertNull((Object)wHS.executeHandler(cmd));
    }

    public void testBug314847() {
        new Info("Hello");
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class.getName());
        ParameterizedCommand nonparameterizedCmd = cs.createCommand(TEST_ID3, null);
        ParameterizedCommand parameterizedCmd = cs.createCommand(TEST_ID3, Collections.singletonMap(ACTIVE_INFO_ID, "param"));
        HandlerWithParams handler = new HandlerWithParams();
        wHS.activateHandler(TEST_ID3, (Object)handler);
        HandlerTest.assertEquals((boolean)true, (boolean)wHS.canExecute(parameterizedCmd));
        HandlerTest.assertEquals((Object)"param", (Object)wHS.executeHandler(parameterizedCmd));
        HandlerTest.assertEquals((boolean)true, (boolean)wHS.canExecute(nonparameterizedCmd));
        HandlerTest.assertEquals(null, (Object)wHS.executeHandler(nonparameterizedCmd));
    }

    protected void setUp() throws Exception {
        IEclipseContext globalContext = TestActivator.getDefault().getGlobalContext();
        this.workbenchContext = globalContext.createChild("workbenchContext");
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.workbenchContext);
        this.defineCommands(this.workbenchContext);
    }

    protected void tearDown() throws Exception {
        this.workbenchContext.dispose();
    }

    private void defineCommands(IEclipseContext context) {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        Category category = cs.defineCategory(TEST_CAT1, "CAT1", null);
        cs.defineCommand(TEST_ID1, "ID1", null, category, null);
        cs.defineCommand(TEST_ID2, "ID2", null, category, null);
        cs.defineCommand(TEST_ID3, "ID3", null, category, new IParameter[]{new IParameter(){

            public boolean isOptional() {
                return true;
            }

            public IParameterValues getValues() throws ParameterValuesException {
                return new IParameterValues(){

                    public Map<?, ?> getParameterValues() {
                        return Collections.EMPTY_MAP;
                    }
                };
            }

            public String getName() {
                return HandlerTest.ACTIVE_INFO_ID;
            }

            public String getId() {
                return HandlerTest.ACTIVE_INFO_ID;
            }
        }});
    }

    static class CallHandler {
        public boolean q1;
        public boolean q2;

        CallHandler() {
        }

        @CanExecute
        public boolean canExecute() {
            this.q1 = true;
            return true;
        }

        @Execute
        public Object execute() {
            this.q2 = true;
            if (this.q1) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    static class HandlerWithAnnotations {
        HandlerWithAnnotations() {
        }

        @CanExecute
        public boolean canExecute(@Named(value="activeInfo") Info h) {
            return h.name.equals("Hello");
        }

        @Execute
        public Object execute(@Named(value="activeInfo") Info h) {
            return h.name.equals("Hello") ? h : null;
        }
    }

    static class HandlerWithInfo {
        HandlerWithInfo() {
        }

        @CanExecute
        public boolean canExecute(Info h) {
            return h.name.equals("Hello");
        }

        @Execute
        public Object execute(Info h) {
            return h.name.equals("Hello") ? h : null;
        }
    }

    static class HandlerWithParams {
        HandlerWithParams() {
        }

        @CanExecute
        public boolean canExecute(@Optional @Named(value="activeInfo") String param) {
            return true;
        }

        @Execute
        public Object execute(@Optional @Named(value="activeInfo") String param) {
            return param;
        }
    }

    static class Info {
        public String name;

        public Info(String name) {
            this.name = name;
        }
    }
}

