/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.properties.tabbed.sections;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.e4.xwt.IXWTLoader;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.XWTLoaderManager;
import org.eclipse.e4.xwt.core.IBinding;
import org.eclipse.e4.xwt.core.IDynamicBinding;
import org.eclipse.e4.xwt.internal.utils.LoggerManager;
import org.eclipse.e4.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.e4.xwt.tools.ui.designer.commands.ApplyAttributeSettingCommand;
import org.eclipse.e4.xwt.tools.ui.designer.commands.DeleteCommand;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.EditDomain;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.DisplayUtil;
import org.eclipse.e4.xwt.tools.ui.designer.loader.ResourceVisitor;
import org.eclipse.e4.xwt.tools.ui.designer.loader.XWTClassLoaderUtil;
import org.eclipse.e4.xwt.tools.ui.designer.loader.XWTVisualLoader;
import org.eclipse.e4.xwt.tools.ui.designer.model.RefreshAdapter;
import org.eclipse.e4.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.resources.ImageShop;
import org.eclipse.e4.xwt.tools.ui.designer.utils.XWTModelUtil;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractAttributeSection
extends AbstractPropertySection
implements Listener {
    private XamlNode parent;
    private XamlAttribute attribute;
    private WidgetEditPart editPart;
    private Label attrLable;
    static Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    private boolean needToRefresh = false;
    private Map<XamlNode, RefreshAdapter> refresherMap;
    protected Display display;

    public boolean isNeedToRefresh() {
        return this.needToRefresh;
    }

    public void setNeedToRefresh(boolean needToRefresh) {
        this.needToRefresh = needToRefresh;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this._createControls(parent, aTabbedPropertySheetPage);
        Object layoutData = parent.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            GridData gd = (GridData)layoutData;
            gd.verticalAlignment = 1;
            gd.grabExcessVerticalSpace = false;
        }
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.attrLable = this.getWidgetFactory().createLabel(parent, "");
        Control section = this.createSection(parent);
        this.display = section.getDisplay();
        section.setLayoutData((Object)new GridData(768));
        this.createClearButton(parent);
    }

    protected void _createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    protected void handleModelChanged(Notification msg) {
        if (msg.isTouch()) {
            return;
        }
        Object notifier = msg.getNotifier();
        if (notifier == null) {
            return;
        }
        XamlAttribute attribute = this.getAttribute();
        if (notifier == attribute) {
            this.setNeedToRefresh(true);
        } else if (notifier == this.parent && (attribute == msg.getOldValue() || attribute == msg.getNewValue())) {
            this.setNeedToRefresh(true);
        }
        this.refresh();
    }

    protected void createClearButton(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        toolBar.setBackground(parent.getDisplay().getSystemColor(1));
        ToolItem clearAction = new ToolItem(toolBar, 8);
        clearAction.setImage(ImageShop.get("/icons/full/tools/clear_filter.gif"));
        clearAction.setToolTipText("Clear setting values.");
        clearAction.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractAttributeSection.this.clearProperty();
            }
        });
    }

    protected void clearProperty() {
        this.executeCommand(new DeleteCommand((XamlNode)this.getAttribute()));
    }

    public XamlAttribute getAttribute() {
        if (this.attribute != null && this.attribute.eContainer() == null) {
            this.attribute = XWTModelUtil.getAdaptableAttribute(this.parent, this.getAttributeName(), "http://www.eclipse.org/xwt/presentation");
        }
        if (this.attribute == null) {
            this.attribute = this.createAttribute(this.parent);
        }
        return this.attribute;
    }

    public XamlNode getParent() {
        return this.parent;
    }

    protected void applyEditPart(WidgetEditPart editPart) {
        String name;
        if (this.editPart != null && this.editPart == editPart) {
            return;
        }
        this.setNeedToRefresh(true);
        this.editPart = editPart;
        if (this.attrLable != null && !this.attrLable.isDisposed() && (name = this.getAttributeName()) != null && name.length() > 0) {
            this.attrLable.setText(String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1) + ":");
            this.attrLable.getParent().layout();
        }
        this.parent = editPart.getCastModel();
        this.attribute = this.createAttribute(this.parent);
        this.getRefresher().addListenedAttr(this.getAttributeName());
    }

    protected RefreshAdapter getRefresher() {
        RefreshAdapter refreshAdapter;
        if (this.refresherMap == null) {
            this.refresherMap = new HashMap<XamlNode, RefreshAdapter>();
        }
        if ((refreshAdapter = this.refresherMap.get(this.parent)) == null) {
            refreshAdapter = new RefreshAdapter(this.parent){

                protected void performRefresh(Notification msg) {
                    AbstractAttributeSection.this.handleModelChanged(msg);
                }
            };
            this.refresherMap.put(this.parent, refreshAdapter);
        }
        return refreshAdapter;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EditPart editPart;
        IWorkbenchPage activePage;
        IEditorPart activeEditor;
        GraphicalViewer graphicalViewer;
        super.setInput(part, selection);
        Object object = ((IStructuredSelection)selection).getFirstElement();
        if (object instanceof WidgetEditPart) {
            this.applyEditPart((WidgetEditPart)((Object)object));
        } else if (object instanceof EditPart && (graphicalViewer = (GraphicalViewer)(activeEditor = (activePage = part.getSite().getWorkbenchWindow().getActivePage()).getActiveEditor()).getAdapter(GraphicalViewer.class)) != null && (editPart = (EditPart)graphicalViewer.getEditPartRegistry().get(((EditPart)object).getModel())) instanceof WidgetEditPart) {
            this.applyEditPart((WidgetEditPart)editPart);
        }
    }

    public void handleEvent(Event event) {
        XamlAttribute attribute = this.getAttribute();
        Command command = null;
        if (this.parent.getAttributes().contains((Object)attribute)) {
            command = new ApplyAttributeSettingCommand(this.parent, attribute, this.getNewValue(event));
        } else {
            attribute.setValue(this.getNewValue(event));
            command = new AddNewChildCommand(this.parent, (XamlNode)attribute);
        }
        this.executeCommand(command);
    }

    protected void executeCommand(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        this.getRefresher().setRefreshRequired(false);
        EditDomain.getEditDomain((EditPart)this.editPart).getCommandStack().execute(command);
        this.getRefresher().setRefreshRequired(true);
    }

    protected String getValue() {
        XamlAttribute attribute = this.getAttribute();
        if (attribute == null || attribute.eContainer() == null) {
            return null;
        }
        return attribute.getValue();
    }

    protected void setTextValue(Text textWidget) {
        Object value = this.getValue();
        if (value == null) {
            XamlNode[] children = (XamlNode[])this.attribute.getChildNodes().toArray((Object[])new XamlNode[0]);
            IXWTLoader xwtLoader = XWTLoaderManager.getActive();
            XamlNode[] xamlNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                XamlNode child = xamlNodeArray[n2];
                String name = child.getName();
                String ns = child.getNamespace();
                if (name.equalsIgnoreCase("Static") && ns.equals("http://www.eclipse.org/xwt")) {
                    value = (String)this.getStaticValue(child, xwtLoader);
                } else if (name.equals("Binding")) {
                    Class<String> type = String.class;
                    ResourceVisitor resourceVisitor = new ResourceVisitor((XWTVisualLoader)xwtLoader);
                    try {
                        value = resourceVisitor.doCreate(child.getParent(), (XamlElement)child, type, EMPTY_MAP);
                        if (value != null) {
                            if (value instanceof IDynamicBinding) {
                                IDynamicBinding binding = (IDynamicBinding)value;
                                binding.setType("text");
                                binding.setControl((Object)this.editPart.getWidget());
                                binding.setHost(this.editPart.getModel());
                            }
                            if (!type.isAssignableFrom(value.getClass()) || value instanceof IBinding) {
                                Object orginalValue = value;
                                IConverter converter = ((XWTVisualLoader)xwtLoader).findConvertor(value.getClass(), type);
                                if (converter != null && (value = converter.convert(value)) != null && orginalValue instanceof IBinding && !type.isAssignableFrom(value.getClass())) {
                                    converter = ((XWTVisualLoader)xwtLoader).findConvertor(value.getClass(), type);
                                    if (converter != null) {
                                        value = converter.convert(value);
                                    } else {
                                        LoggerManager.log((Throwable)new XWTException("Convertor " + value.getClass().getSimpleName() + "->" + type.getSimpleName() + " is not found"));
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        LoggerManager.log((Throwable)e);
                    }
                }
                ++n2;
            }
        }
        textWidget.setText((String)(value == null ? "" : value));
    }

    protected Object getStaticValue(XamlNode child, IXWTLoader xwtLoader) {
        XamlElement element;
        XamlNode[] children = (XamlNode[])child.getChildNodes().toArray((Object[])new XamlNode[0]);
        if (children.length == 1 && (element = (XamlElement)children[0]) != null) {
            return XWTClassLoaderUtil.loadStaticMember(((XWTVisualLoader)xwtLoader).getLoadingContext(), (XamlNode)element);
        }
        return null;
    }

    public WidgetEditPart getEditPart() {
        return this.editPart;
    }

    protected XamlAttribute createAttribute(XamlNode parent) {
        String attrName = this.getAttributeName();
        if (attrName == null) {
            throw new NullPointerException("Attribute name is null");
        }
        XamlAttribute attr = XWTModelUtil.getAdaptableAttribute(parent, attrName, "http://www.eclipse.org/xwt/presentation");
        if (attr == null) {
            attr = XamlFactory.eINSTANCE.createAttribute(attrName, "http://www.eclipse.org/xwt/presentation");
        }
        return attr;
    }

    public final void refresh() {
        if (!this.isNeedToRefresh()) {
            return;
        }
        this.setNeedToRefresh(false);
        DisplayUtil.syncExec((Display)this.display, (Runnable)new Runnable(){

            public void run() {
                AbstractAttributeSection.this.doRefresh();
            }
        });
    }

    protected abstract void doRefresh();

    protected abstract String getNewValue(Event var1);

    protected abstract String getAttributeName();

    protected abstract Control createSection(Composite var1);
}

