/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.javascript;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.WeakHashMap;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactorySpi;
import org.eclipse.e4.demo.javascript.JSUtil;
import org.mozilla.javascript.Scriptable;
import org.osgi.framework.Bundle;

public class JSContributionFactory
implements IContributionFactorySpi {
    private JSUtil js;
    private WeakHashMap contributionDatas = new WeakHashMap();

    public JSContributionFactory() {
        this.js = new JSUtil();
    }

    private static String readString(InputStream is) throws IOException {
        int ch;
        StringBuffer result = new StringBuffer();
        BufferedInputStream bis = new BufferedInputStream(is);
        while ((ch = bis.read()) != -1) {
            result.append((char)ch);
        }
        bis.close();
        return result.toString();
    }

    public Object create(Bundle bundle, String name, IEclipseContext context) {
        ContributionData cd = new ContributionData();
        cd.bundle = bundle;
        cd.name = name;
        cd.context = context;
        Object result = cd.updateContribution(this.js, null);
        ContributionWrapper wrapper = new ContributionWrapper(result);
        this.contributionDatas.put(wrapper, cd);
        return wrapper;
    }

    public Object call(Object o, String methodName, IEclipseContext context, Object defaultValue) {
        ContributionWrapper wrapper = (ContributionWrapper)o;
        ContributionData cd = (ContributionData)this.contributionDatas.get(wrapper);
        wrapper.contribution = cd.updateContribution(this.js, wrapper.contribution);
        Object runargs = this.js.get(wrapper.contribution, String.valueOf(methodName) + "args");
        int len = this.js.length(runargs);
        Object[] args = new Object[len];
        int i = 0;
        while (i < len) {
            args[i] = context.get((String)this.js.get(runargs, i));
            ++i;
        }
        Object function = this.js.get(wrapper.contribution, methodName);
        if (function == null || !(function instanceof Scriptable)) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new RuntimeException("could not find function " + methodName + " in " + cd.name);
        }
        Object result = this.js.call(function, wrapper.contribution, args);
        return result;
    }

    private static class ContributionData {
        Bundle bundle;
        String name;
        String script;
        IEclipseContext context;

        private ContributionData() {
        }

        private Object updateContribution(JSUtil js, Object contribution) {
            try {
                InputStream stream = this.bundle.getResource(this.name).openStream();
                String newScript = JSContributionFactory.readString(stream);
                if (this.script != null && this.script.equals(newScript)) {
                    return contribution;
                }
                this.script = newScript;
                contribution = js.eval(this.script);
                Object initargs = js.get(contribution, "initargs");
                if (initargs instanceof Scriptable) {
                    int len = js.length(initargs);
                    Object[] args = new Object[len];
                    int i = 0;
                    while (i < len) {
                        args[i] = this.context.get((String)js.get(initargs, i));
                        ++i;
                    }
                    js.call(js.get(contribution, "init"), contribution, args);
                }
                return contribution;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static class ContributionWrapper {
        Object contribution;

        public ContributionWrapper(Object c) {
            this.contribution = c;
        }
    }
}

