/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.builder.widgets;

import java.util.List;
import junit.framework.Assert;
import org.eclipse.e4.tm.builder.TmTestCase;
import org.eclipse.e4.tm.builder.widgets.AbstractCompositeTest;
import org.eclipse.e4.tm.widgets.WidgetsFactory;
import org.eclipse.e4.tm.widgets.WidgetsPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SplitPaneTest
extends AbstractCompositeTest {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testHorizontalSplitPane() {
        this.testSplitPane("horizontal", 256);
    }

    public void testVerticalSplitPane() {
        this.testSplitPane("vertical", 512);
    }

    private void testSplitPane(String orientationName, int orientation) {
        WidgetsPackage widgetsPackage = WidgetsPackage.eINSTANCE;
        EObject eSplitPane = WidgetsFactory.eINSTANCE.create(widgetsPackage.getSplitPane());
        eSplitPane.eSet((EStructuralFeature)widgetsPackage.getSplitPane_Orientation(), (Object)orientationName);
        EObject eComp1 = WidgetsFactory.eINSTANCE.create(widgetsPackage.getComposite());
        EObject eComp2 = WidgetsFactory.eINSTANCE.create(widgetsPackage.getComposite());
        ((List)eSplitPane.eGet((EStructuralFeature)widgetsPackage.getAbstractComposite_Controls())).add(eComp1);
        ((List)eSplitPane.eGet((EStructuralFeature)widgetsPackage.getAbstractComposite_Controls())).add(eComp2);
        this.builder.build(eSplitPane, (Object)this.getTopLevel());
        SashForm sashForm = this.getChild(0, SashForm.class);
        Assert.assertNotNull((Object)sashForm);
        int actualOrientation = sashForm.getOrientation();
        SplitPaneTest.assertEquals((int)orientation, (int)actualOrientation);
        Control[] children = sashForm.getChildren();
        SplitPaneTest.assertEquals((int)2, (int)children.length);
        SplitPaneTest.assertTrue((boolean)(children[0] instanceof Composite));
        SplitPaneTest.assertTrue((boolean)(children[1] instanceof Composite));
    }

    public static void main(String[] args) {
        TmTestCase.doRun(SplitPaneTest.class);
    }
}

