/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;

public class InjectBaseTypeTest
extends TestCase {
    public void testPrimitiveTypes() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("test_int", (Object)12);
        context.set("test_long", (Object)124564523466L);
        context.set("test_float", (Object)Float.valueOf(12.34f));
        context.set("test_double", (Object)12.345345345634634);
        context.set("test_short", (Object)10);
        context.set("test_byte", (Object)55);
        context.set("test_boolean", (Object)true);
        context.set("test_char", (Object)Character.valueOf('a'));
        TestClass testClass = (TestClass)ContextInjectionFactory.make(TestClass.class, (IEclipseContext)context);
        InjectBaseTypeTest.assertEquals((int)12, (int)testClass.intField);
        InjectBaseTypeTest.assertEquals((int)0, (int)testClass.intFieldOptional);
        InjectBaseTypeTest.assertEquals((long)124564523466L, (long)testClass.longField);
        InjectBaseTypeTest.assertEquals((Object)Float.valueOf(12.34f), (Object)Float.valueOf(testClass.floatField));
        InjectBaseTypeTest.assertEquals((Object)12.345345345634634, (Object)testClass.doubleField);
        InjectBaseTypeTest.assertEquals((short)10, (short)testClass.shortField);
        InjectBaseTypeTest.assertEquals((byte)55, (byte)testClass.byteField);
        InjectBaseTypeTest.assertEquals((boolean)true, (boolean)testClass.booleanField);
        InjectBaseTypeTest.assertEquals((char)'a', (char)testClass.charField);
        InjectBaseTypeTest.assertEquals((int)12, (int)testClass.intArg);
        InjectBaseTypeTest.assertEquals((char)'a', (char)testClass.charArg);
        InjectBaseTypeTest.assertEquals((boolean)true, (boolean)testClass.booleanArg);
        ContextInjectionFactory.uninject((Object)testClass, (IEclipseContext)context);
        InjectBaseTypeTest.assertEquals((int)12, (int)testClass.intField);
        InjectBaseTypeTest.assertEquals((int)0, (int)testClass.intFieldOptional);
        InjectBaseTypeTest.assertEquals((long)124564523466L, (long)testClass.longField);
        InjectBaseTypeTest.assertEquals((Object)Float.valueOf(12.34f), (Object)Float.valueOf(testClass.floatField));
        InjectBaseTypeTest.assertEquals((Object)12.345345345634634, (Object)testClass.doubleField);
        InjectBaseTypeTest.assertEquals((short)10, (short)testClass.shortField);
        InjectBaseTypeTest.assertEquals((byte)55, (byte)testClass.byteField);
        InjectBaseTypeTest.assertEquals((boolean)false, (boolean)testClass.booleanField);
        InjectBaseTypeTest.assertEquals((char)'a', (char)testClass.charField);
        InjectBaseTypeTest.assertEquals((int)12, (int)testClass.intArg);
        InjectBaseTypeTest.assertEquals((char)'a', (char)testClass.charArg);
        InjectBaseTypeTest.assertEquals((boolean)true, (boolean)testClass.booleanArg);
    }

    static class TestClass {
        @Inject
        @Named(value="test_int")
        public int intField;
        @Inject
        @Named(value="test_int_optional")
        @Optional
        public int intFieldOptional;
        @Inject
        @Named(value="test_long")
        public long longField;
        @Inject
        @Named(value="test_float")
        public float floatField;
        @Inject
        @Named(value="test_double")
        public double doubleField;
        @Inject
        @Named(value="test_short")
        public short shortField;
        @Inject
        @Named(value="test_byte")
        public byte byteField;
        @Inject
        @Optional
        @Named(value="test_boolean")
        public boolean booleanField;
        @Inject
        @Named(value="test_char")
        public char charField;
        public int intArg;
        public char charArg;
        public boolean booleanArg;

        TestClass() {
        }

        @Inject
        public void set(@Named(value="test_int") int intArg, @Named(value="test_char") char charArg, @Named(value="test_boolean") boolean booleanArg) {
            this.intArg = intArg;
            this.charArg = charArg;
            this.booleanArg = booleanArg;
        }
    }
}

