/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.property;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.platform.discovery.util.internal.property.Access;
import org.eclipse.platform.discovery.util.internal.property.AccessCheckingListIterator;
import org.eclipse.platform.discovery.util.internal.property.IListProperty;

class AccessCheckingList<T>
implements List<T> {
    private final List<T> delegate;
    private final IListProperty<T> property;

    public AccessCheckingList(List<T> delegate, IListProperty<T> property) {
        this.delegate = delegate;
        this.property = property;
    }

    private List<T> delegate() {
        return this.delegate;
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate().equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    private Access getListAccess() {
        return this.property.getListAccess();
    }

    @Override
    public void add(int index, T element) {
        this.assertCanWrite();
        this.delegate().add(index, element);
    }

    @Override
    public boolean add(T o) {
        this.assertCanWrite();
        return this.delegate().add(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.assertCanWrite();
        return this.delegate().addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.assertCanWrite();
        return this.delegate().addAll(index, c);
    }

    @Override
    public void clear() {
        this.assertCanWrite();
        this.delegate().clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate().containsAll(c);
    }

    @Override
    public T get(int index) {
        return this.delegate().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate().indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate().lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new AccessCheckingListIterator<T>(this.property, this.delegate().listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new AccessCheckingListIterator<T>(this.property, this.delegate().listIterator(index));
    }

    @Override
    public T remove(int index) {
        this.assertCanWrite();
        return this.delegate().remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.assertCanWrite();
        return this.delegate().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.assertCanWrite();
        return this.delegate().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.assertCanWrite();
        return this.delegate().retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        this.assertCanWrite();
        return this.delegate().set(index, element);
    }

    @Override
    public int size() {
        return this.delegate().size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.delegate().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.delegate().toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.delegate().toArray(a);
    }

    private void assertCanWrite() {
        if (Access.READ_WRITE != this.getListAccess()) {
            throw new UnsupportedOperationException(this.getListAccess().name());
        }
    }
}

