/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.server.bespin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.e4.server.bespin.Activator;
import org.eclipse.e4.server.bespin.JSONUtil;

public class SettingsServlet
extends HttpServlet {
    private File users = Activator.bundleContext.getDataFile("users");

    public SettingsServlet() {
        this.users.mkdir();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        HttpSession session = req.getSession();
        if (session == null) {
            resp.setStatus(401);
            return;
        }
        String username = (String)session.getAttribute("username");
        if (username == null) {
            resp.setStatus(401);
            return;
        }
        Map userMap = this.loadUserSettingsMap(username);
        if (userMap == null) {
            resp.setStatus(401);
            return;
        }
        if (pathInfo.equals("/")) {
            resp.setContentType("application/json; charset=UTF-8");
            resp.getWriter().write(JSONUtil.write(userMap));
            return;
        }
        String key = pathInfo.substring(1);
        String value = (String)userMap.get(key);
        HashMap<String, String> jsonObject = new HashMap<String, String>();
        jsonObject.put(key, value);
        resp.setContentType("application/json; charset=UTF-8");
        resp.getWriter().write(JSONUtil.write(jsonObject));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo.equals("/")) {
            HttpSession session = req.getSession();
            if (session == null) {
                resp.setStatus(401);
                return;
            }
            String username = (String)session.getAttribute("username");
            if (username == null) {
                resp.setStatus(401);
                return;
            }
            Map userMap = this.loadUserSettingsMap(username);
            if (userMap == null) {
                resp.setStatus(401);
                return;
            }
            Enumeration parameterNames = req.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                userMap.put(parameterName, req.getParameter(parameterName));
            }
            this.saveUserSettingsMap(username, userMap);
            return;
        }
        super.doPost(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        HttpSession session = req.getSession();
        if (session == null) {
            resp.setStatus(401);
            return;
        }
        String username = (String)session.getAttribute("username");
        if (username == null) {
            resp.setStatus(401);
            return;
        }
        Map userMap = this.loadUserSettingsMap(username);
        if (userMap == null) {
            resp.setStatus(401);
            return;
        }
        if (pathInfo.equals("/")) {
            userMap.clear();
        }
        String key = pathInfo.substring(1);
        userMap.remove(key);
        this.saveUserSettingsMap(username, userMap);
    }

    private void saveUserSettingsMap(String username, Map userMap) {
        File userFile = new File(this.users, String.valueOf(username) + "_settings.properties");
        Properties props = (Properties)userMap;
        try {
            props.store(new FileOutputStream(userFile), null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Map loadUserSettingsMap(String username) {
        Properties props = new Properties();
        File userFile = new File(this.users, String.valueOf(username) + "_settings.properties");
        if (!userFile.isFile()) {
            return props;
        }
        try {
            props.load(new FileInputStream(userFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }
}

