/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.xaml.tools;

import org.eclipse.e4.xwt.tools.ui.xaml.Annotation;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;

public class AnnotationTools {
    public static void addAnnotation(XamlNode node, String key, String value) {
        if (node == null) {
            return;
        }
        Annotation annotation = node.getAnnotation(key);
        if (annotation == null) {
            annotation = XamlFactory.eINSTANCE.createAnnotation();
            annotation.setSource(key);
            node.getAnnotations().add((Object)annotation);
        }
        annotation.getDetails().put((Object)key, (Object)value);
    }

    public static void removeAnnotation(XamlNode node, String key) {
        if (node == null) {
            return;
        }
        Annotation annotation = node.getAnnotation(key);
        if (annotation != null) {
            node.getAnnotations().remove((Object)annotation);
        }
    }

    public static boolean isAnnotated(XamlNode node, String key) {
        if (node == null) {
            return false;
        }
        Annotation annotation = node.getAnnotation(key);
        return annotation != null && annotation.getDetails().containsKey((Object)key);
    }

    public static String getAnnotationValue(XamlNode node, String key) {
        if (node == null) {
            return null;
        }
        if (AnnotationTools.isAnnotated(node, key)) {
            return (String)node.getAnnotation(key).getDetails().get((Object)key);
        }
        return null;
    }
}

