/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolo.util.PLocator;

public abstract class PAbstractLineLocator
extends PLocator {
    private double lineAlignment;
    private double alongOffset;
    private double perpendicularOffset;
    public static final double START = 0.0;
    public static final double MIDDLE = 0.5;
    public static final double CENTER = 0.5;
    public static final double END = 1.0;

    public PAbstractLineLocator(double lineAlignment) {
        this.lineAlignment = lineAlignment;
    }

    public void setLineOffset(double lineAlignment) {
        this.lineAlignment = lineAlignment;
    }

    public void setLineOffset(double alongOffset, double perpendicularOffset) {
        this.alongOffset = alongOffset;
        this.perpendicularOffset = perpendicularOffset;
    }

    public abstract double getLineStartX();

    public abstract double getLineStartY();

    public abstract double getLineEndX();

    public abstract double getLineEndY();

    public double locateX() {
        double x = this.getLineStartX();
        double y = this.getLineStartY();
        double dx = this.getLineEndX() - x;
        double dy = this.getLineEndY() - y;
        double e = Math.sqrt(dx * dx + dy * dy);
        return x + dx * this.lineAlignment + this.alongOffset * dx / e - this.perpendicularOffset * dy / e + this.offsetX;
    }

    public double locateY() {
        double x = this.getLineStartX();
        double y = this.getLineStartY();
        double dx = this.getLineEndX() - x;
        double dy = this.getLineEndY() - y;
        double e = Math.sqrt(dx * dx + dy * dy);
        return y + dy * this.lineAlignment + this.alongOffset * dy / e + this.perpendicularOffset * dx / e + this.offsetY;
    }
}

