/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.PRoot;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class PDebug {
    public static boolean debugRegionManagement = false;
    public static boolean debugPaintCalls = false;
    public static boolean debugPrintFrameRate = false;
    public static boolean debugPrintUsedMemory = false;
    public static boolean debugBounds = false;
    public static boolean debugFullBounds = false;
    public static boolean debugThreads = false;
    public static int printResultsFrameRate = 10;
    private static int debugPaintColor;
    private static long framesProcessed;
    private static long startProcessingOutputTime;
    private static long startProcessingInputTime;
    private static long processOutputTime;
    private static long processInputTime;
    private static boolean processingOutput;

    private PDebug() {
    }

    public static Color getDebugPaintColor() {
        int color = 100 + debugPaintColor++ % 10 * 10;
        return new Color((Device)Display.getCurrent(), color, color, color);
    }

    public static void scheduleProcessInputs(Display display) {
        if (debugThreads && !PRoot.isEventThread(display)) {
            System.out.println("scene graph manipulated on wrong thread");
        }
    }

    public static void processRepaint(Display display) {
        if (processingOutput && debugPaintCalls) {
            System.err.println("Got repaint while painting scene. This can result in a recursive process that degrades performance.");
        }
        if (debugThreads && !PRoot.isEventThread(display)) {
            System.out.println("repaint called on wrong thread");
        }
    }

    public static boolean getProcessingOutput() {
        return processingOutput;
    }

    public static void startProcessingOutput() {
        processingOutput = true;
        startProcessingOutputTime = System.currentTimeMillis();
    }

    public static void endProcessingOutput(GC g) {
        processOutputTime += System.currentTimeMillis() - startProcessingOutputTime;
        if (debugPrintFrameRate && ++framesProcessed % (long)printResultsFrameRate == 0L) {
            System.out.println("Process output frame rate: " + PDebug.getOutputFPS() + " fps");
            System.out.println("Process input frame rate: " + PDebug.getInputFPS() + " fps");
            System.out.println("Total frame rate: " + PDebug.getTotalFPS() + " fps");
            System.out.println();
            PDebug.resetFPSTiming();
        }
        if (debugPrintUsedMemory && framesProcessed % (long)printResultsFrameRate == 0L) {
            System.out.println("Approximate used memory: " + PDebug.getApproximateUsedMemory() / 1024L + " k");
        }
        if (debugRegionManagement) {
            GC g2 = g;
            g.setBackground(PDebug.getDebugPaintColor());
            g2.fillRectangle(g.getClipping());
        }
        processingOutput = false;
    }

    public static void startProcessingInput() {
        startProcessingInputTime = System.currentTimeMillis();
    }

    public static void endProcessingInput() {
        processInputTime += System.currentTimeMillis() - startProcessingInputTime;
    }

    public static double getTotalFPS() {
        if (framesProcessed > 0L) {
            return 1000.0 / ((double)(processInputTime + processOutputTime) / (double)framesProcessed);
        }
        return 0.0;
    }

    public static double getInputFPS() {
        if (processInputTime > 0L && framesProcessed > 0L) {
            return 1000.0 / ((double)processInputTime / (double)framesProcessed);
        }
        return 0.0;
    }

    public static double getOutputFPS() {
        if (processOutputTime > 0L && framesProcessed > 0L) {
            return 1000.0 / ((double)processOutputTime / (double)framesProcessed);
        }
        return 0.0;
    }

    public long getFramesProcessed() {
        return framesProcessed;
    }

    public static void resetFPSTiming() {
        framesProcessed = 0L;
        processInputTime = 0L;
        processOutputTime = 0L;
    }

    public static long getApproximateUsedMemory() {
        System.gc();
        System.runFinalization();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        return totalMemory - free;
    }
}

