/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.providers.RESTUtil;
import org.eclipse.core.resources.semantic.examples.providers.SampleRESTReadonlyContentProvider;
import org.eclipse.core.resources.semantic.examples.remote.SemanticResourcesPluginExamplesCore;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleWSDLXSDContentProvider
extends SampleRESTReadonlyContentProvider {
    @Override
    public void addFileFromRemoteByURI(ISemanticFileStore parentStore, String name, URI uri, IProgressMonitor monitor) throws CoreException {
        super.addFileFromRemoteByURI(parentStore, name, uri, monitor);
        this.addDependentFiles((ISemanticFileStore)parentStore.getChild(name), uri.toString(), monitor);
    }

    public void addDependentFiles(ISemanticFileStore store, String uri, IProgressMonitor monitor) throws CoreException {
        List<String> uris;
        InputStream is = store.openInputStream(0, monitor);
        try {
            try {
                StringBuffer buf = RESTUtil.readStreamIntoStringBuffer(is, "UTF-8");
                uris = this.findRelativeURLs(buf);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, SemanticResourcesPluginExamplesCore.PLUGIN_ID, e.getMessage(), (Throwable)e));
            }
        }
        finally {
            Util.safeClose((InputStream)is);
        }
        String rootURI = uri.substring(0, uri.lastIndexOf("/"));
        for (String uriString : uris) {
            if (uriString.contains(":") || uriString.contains("?") || uriString.startsWith("/")) continue;
            String[] parts = uriString.split("/");
            this.addDependentFiles((ISemanticFileStore)store.getParent(), rootURI, parts, 0, monitor);
        }
    }

    private void addDependentFiles(ISemanticFileStore parentStore, String rootURI, String[] parts, int index, IProgressMonitor monitor) throws CoreException {
        this.addChildrenHierarchy(parentStore, rootURI, parts, index, monitor);
    }

    private void addChildrenHierarchy(ISemanticFileStore childStore, String rootURI, String[] parts, int index, IProgressMonitor monitor) throws CoreException {
        IFileStore child = childStore.getChild(parts[index]);
        if (parts.length > index + 1) {
            if (!child.fetchInfo().exists()) {
                this.addResource(childStore, parts[index], ISemanticFileStore.ResourceType.FOLDER_TYPE, monitor);
            }
            child = childStore.getChild(parts[index]);
            this.addChildrenHierarchy((ISemanticFileStore)child, String.valueOf(rootURI) + "/" + parts[index], parts, index + 1, monitor);
        } else if (!child.fetchInfo().exists()) {
            super.addFileFromRemoteByURI(childStore, parts[index], URI.create(String.valueOf(rootURI) + "/" + parts[index]), monitor);
            this.addDependentFiles((ISemanticFileStore)childStore.getChild(parts[index]), String.valueOf(rootURI) + "/" + parts[index], monitor);
        }
    }

    private List<String> findRelativeURLs(StringBuffer buf) {
        ArrayList<String> uris = new ArrayList<String>();
        if (buf.indexOf("<wsdl:") < 0) {
            String relativeURLString;
            Pattern pattern = Pattern.compile("(<import)(.*)( schemaLocation=\")([^\"]+)");
            Matcher matcher = pattern.matcher(buf);
            while (matcher.find()) {
                relativeURLString = matcher.group(4);
                uris.add(relativeURLString);
            }
            pattern = Pattern.compile("(<import schemaLocation=\")([^\"]+)");
            matcher = pattern.matcher(buf);
            while (matcher.find()) {
                relativeURLString = matcher.group(2);
                uris.add(relativeURLString);
            }
        } else {
            String relativeURLString;
            Pattern pattern = Pattern.compile("(<xsd:import)(.*)( schemaLocation=\")([^\"]+)");
            Matcher matcher = pattern.matcher(buf);
            while (matcher.find()) {
                relativeURLString = matcher.group(4);
                uris.add(relativeURLString);
            }
            pattern = Pattern.compile("(<xsd:import schemaLocation=\")([^\"]+)");
            matcher = pattern.matcher(buf);
            while (matcher.find()) {
                relativeURLString = matcher.group(2);
                uris.add(relativeURLString);
            }
        }
        return uris;
    }

    @Override
    public void synchronizeContentWithRemote(ISemanticFileStore semanticFileStore, SyncDirection direction, IProgressMonitor monitor, MultiStatus status) {
        super.synchronizeContentWithRemote(semanticFileStore, direction, monitor, status);
        if (semanticFileStore.getType() == 1 && !semanticFileStore.isLocalOnly()) {
            try {
                String uriString = this.getURIStringInternal(semanticFileStore);
                this.addDependentFiles(semanticFileStore, uriString, monitor);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
        }
    }
}

