/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.internal.resources.semantic.ui.actions.ActionBase;
import org.eclipse.core.internal.resources.semantic.ui.actions.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;

public class EditAction
extends ActionBase {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.checkFilesWithReadOnlyFlagOnly(true) && this.checkSelectionNonLocalOnly());
    }

    public void run(IAction action) {
        IRunnableWithProgress outerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor outerMonitor) throws InvocationTargetException, InterruptedException {
                for (final ISemanticFile file : EditAction.this.getSelection()) {
                    outerMonitor.subTask(NLS.bind((String)Messages.EditAction_Editing_XMSG, (Object)file.getAdaptedResource().getName()));
                    if (outerMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    IWorkspaceRunnable wsRunnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            IStatus validationResult = file.validateEdit((Object)EditAction.this.getShell());
                            if (!validationResult.isOK() && validationResult.getSeverity() != 8) {
                                throw new CoreException(validationResult);
                            }
                        }
                    };
                    try {
                        IWorkspace ws = ResourcesPlugin.getWorkspace();
                        ISchedulingRule rule = ws.getRuleFactory().validateEditRule(new IResource[]{file.getAdaptedResource()});
                        ResourcesPlugin.getWorkspace().run(wsRunnable, rule, 1, outerMonitor);
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce, NLS.bind((String)Messages.EditAction_CouldNotOpenForEdit_XMSG, (Object)file.getAdaptedFile().getFullPath().toString()));
                    }
                }
            }
        };
        this.run(outerRunnable);
    }
}

