/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.internal.resources.semantic.ui.Messages;
import org.eclipse.core.internal.resources.semantic.ui.util.SFSBrowserTreeContentProvider;
import org.eclipse.core.internal.resources.semantic.ui.util.SFSBrowserTreeLabelProvider;
import org.eclipse.core.internal.resources.semantic.ui.util.SFSBrowserTreeObject;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class BrowseSFSDialog
extends Dialog {
    String selectedPath;
    private TreeViewer sfsTree;

    public BrowseSFSDialog(Shell parentShell, String initialPath) {
        super(parentShell);
        String subPath;
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.selectedPath = initialPath.startsWith("semanticfs") ? (subPath = initialPath.substring("semanticfs".length() + 1)) : initialPath;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.BrowseSFSDialog_Browser_XGRP);
    }

    public String getSelectedPathString() {
        if (this.selectedPath != null) {
            return "semanticfs:" + this.selectedPath;
        }
        return "";
    }

    protected Control createDialogArea(Composite parent) {
        SFSBrowserTreeObject[] input;
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().hint(400, 300).grab(true, true).applyTo((Control)main);
        try {
            input = this.getRootObjects();
        }
        catch (CoreException e) {
            Label errorLabel = new Label(main, 0);
            errorLabel.setText(e.getStatus().getMessage());
            return main;
        }
        Label pathLabel = new Label(main, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)pathLabel);
        pathLabel.setText(Messages.BrowseSFSDialog_Path_XFLD);
        final Text path = new Text(main, 2056);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)path);
        this.sfsTree = new TreeViewer(main, 2820);
        SFSBrowserTreeLabelProvider treeLabelProvider = new SFSBrowserTreeLabelProvider();
        treeLabelProvider.configureTreeColumns(this.sfsTree);
        this.sfsTree.setContentProvider((IContentProvider)new SFSBrowserTreeContentProvider());
        this.sfsTree.setLabelProvider((IBaseLabelProvider)treeLabelProvider);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).align(4, 4).applyTo((Control)this.sfsTree.getTree());
        this.sfsTree.setInput((Object)input);
        if (this.selectedPath != null && !this.selectedPath.equals("")) {
            try {
                SFSBrowserTreeObject object = this.getTreeObject(this.selectedPath);
                this.sfsTree.setSelection((ISelection)new StructuredSelection((Object)object));
                path.setText(object.getPath().toString());
            }
            catch (CoreException e) {
                Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.ui.resources.semantic")).log(e.getStatus());
            }
        }
        this.sfsTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    path.setText("");
                    BrowseSFSDialog.this.selectedPath = null;
                } else {
                    SFSBrowserTreeObject selected = (SFSBrowserTreeObject)sel.getFirstElement();
                    BrowseSFSDialog.this.selectedPath = selected.getPath().toString();
                    path.setText(BrowseSFSDialog.this.selectedPath);
                }
                BrowseSFSDialog.this.getButton(0).setEnabled(BrowseSFSDialog.this.selectedPath != null);
            }
        });
        return main;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(!this.sfsTree.getSelection().isEmpty());
    }

    private SFSBrowserTreeObject[] getRootObjects() throws CoreException {
        ISemanticFileSystem fs = (ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs");
        String[] roots = fs.getRootNames();
        SFSBrowserTreeObject[] paths = new SFSBrowserTreeObject[roots.length];
        int i = 0;
        while (i < roots.length) {
            Path path = new Path(String.valueOf('/') + roots[i]);
            paths[i] = new SFSBrowserTreeObject((IFileSystem)fs, (IPath)path);
            ++i;
        }
        return paths;
    }

    private SFSBrowserTreeObject getTreeObject(String path) throws CoreException {
        IFileSystem fs = EFS.getFileSystem((String)"semanticfs");
        return new SFSBrowserTreeObject(fs, (IPath)new Path(path));
    }
}

