/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.data;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Scalar;

public class DataPoint {
    private int fStep;
    private Map fScalars;

    public DataPoint(int step, Map values) {
        this.fStep = step;
        this.fScalars = values;
    }

    public int getStep() {
        return this.fStep;
    }

    public Dim[] getDimensions() {
        Set set = this.fScalars.keySet();
        return set.toArray(new Dim[set.size()]);
    }

    public Collection getDimensions2() {
        return this.fScalars.keySet();
    }

    public boolean contains(Dim dimension) {
        return this.fScalars.containsKey(dimension);
    }

    public Scalar[] getScalars() {
        return this.fScalars.values().toArray(new Scalar[this.fScalars.size()]);
    }

    public Scalar getScalar(Dim dimension) {
        return (Scalar)this.fScalars.get(dimension);
    }

    public String toString() {
        return "DataPoint [step= " + this.fStep + ", #dimensions: " + this.fScalars.size() + "]";
    }
}

