/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.xp.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.IDestinationCategoryExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.IDestinationsProviderExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;
import org.osgi.framework.Bundle;

public class DestinationsCategoryExtensionParser
extends AbstractExtensionPointParser
implements IDestinationCategoryExtensionParser {
    private static final String XP_ID = "org.eclipse.platform.discovery.runtime.destinationcategory";
    private static final String XP_ELEMENT_NAME = "destinationcategory";
    private static final String CATEGORY_ID_ATTRIBUTE = "id";
    private static final String CATEGORY_DISPLAY_NAME_ATTRIBUTE = "displayname";
    private static final String DESTINATIONS_CLASS_ATTRIBUTE = "destinationclass";
    private final IDestinationsProviderExtensionParser destinationsProviderExtParser;

    public DestinationsCategoryExtensionParser(IDestinationsProviderExtensionParser destProviderExtParser) {
        super(Platform.getExtensionRegistry(), XP_ID, XP_ELEMENT_NAME);
        this.destinationsProviderExtParser = destProviderExtParser;
    }

    @Override
    public Set<IDestinationCategoryDescription> readContributions() {
        HashSet<IDestinationCategoryDescription> categories = new HashSet<IDestinationCategoryDescription>();
        for (IConfigurationElement element : this.getConfigurationElements()) {
            categories.add(this.createCategory(element));
        }
        return categories;
    }

    private IDestinationCategoryDescription createCategory(final IConfigurationElement element) {
        return new IDestinationCategoryDescription(){

            @Override
            public Set<String> getDestinationProviderIds() {
                return DestinationsCategoryExtensionParser.this.getDestProviderIds(this.getId());
            }

            @Override
            public String getDisplayName() {
                return element.getAttribute(DestinationsCategoryExtensionParser.CATEGORY_DISPLAY_NAME_ATTRIBUTE);
            }

            @Override
            public String getId() {
                return element.getAttribute(DestinationsCategoryExtensionParser.CATEGORY_ID_ATTRIBUTE);
            }

            @Override
            public Class<ISearchDestination> getDestinationsClass() {
                return DestinationsCategoryExtensionParser.this.classForDestinationName(element);
            }
        };
    }

    private Set<String> getDestProviderIds(String categoryId) {
        HashSet<String> result = new HashSet<String>();
        for (IDestinationsProviderDescription provider : this.destinationsProviderExtParser.readContributions()) {
            if (!provider.getDestinationCategoryId().equals(categoryId)) continue;
            result.add(provider.getId());
        }
        return result;
    }

    private Class<ISearchDestination> classForDestinationName(IConfigurationElement configElement) {
        Bundle bundle = Platform.getBundle((String)configElement.getNamespaceIdentifier());
        try {
            return bundle.loadClass(configElement.getAttribute(DESTINATIONS_CLASS_ATTRIBUTE));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

