/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.menu.tests;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.UIEventPublisher;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.menu.tests.CmdService;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.commands.CommandImageManager;
import org.eclipse.ui.internal.commands.CommandImageService;
import org.osgi.framework.ServiceReference;

class TestUtil {
    public static final String ORG_ECLIPSE_UI_CONTEXTS_ACTION_SET = "org.eclipse.ui.contexts.actionSet";

    public static void printContributions(MApplication application) {
        for (MMenuContribution mc : application.getMenuContributions()) {
            System.out.print("\n\nMC: " + mc.getParentId() + "?" + mc.getPositionInParent());
            TestUtil.printMenuOut(1, (MElementContainer<MMenuElement>)mc);
        }
        for (MToolBarContribution tbc : application.getToolBarContributions()) {
            System.out.print("\n\nTC: " + tbc.getParentId() + "?" + tbc.getPositionInParent());
            TestUtil.printToolOut(1, tbc);
        }
    }

    public static void printIcon(int level, MUILabel item) {
        TestUtil.printTabs(level + 2);
        System.out.print("icon: " + item.getIconURI());
    }

    public static void printMenuOut(int level, MElementContainer<MMenuElement> container) {
        for (MMenuElement child : container.getChildren()) {
            TestUtil.printTabs(level);
            System.out.print(String.valueOf(child.getClass().getSimpleName()) + ": " + child.getElementId());
            if (child instanceof MMenu) {
                TestUtil.printMenuOut(level + 1, (MElementContainer<MMenuElement>)((MElementContainer)child));
                continue;
            }
            if (child instanceof MHandledMenuItem) {
                System.out.print(": cmd " + ((MHandledMenuItem)child).getCommand().getElementId());
                TestUtil.printIcon(level, (MUILabel)child);
                continue;
            }
            if (child instanceof MDirectMenuItem) {
                System.out.print(": cmd " + ((MDirectMenuItem)child).getContributionURI());
                TestUtil.printIcon(level, (MUILabel)child);
                continue;
            }
            if (!(child instanceof MMenuSeparator)) continue;
            System.out.print(": label " + ((MMenuSeparator)child).getLabel());
        }
    }

    public static void printTabs(int level) {
        System.out.print("\n");
        int i = 0;
        while (i < level) {
            System.out.print("   ");
            ++i;
        }
    }

    public static void printToolOut(int level, MToolBarContribution tbc) {
        for (MToolBarElement child : tbc.getChildren()) {
            TestUtil.printTabs(level);
            System.out.print(String.valueOf(child.getClass().getSimpleName()) + ": " + child.getElementId());
            if (child instanceof MDirectToolItem) {
                System.out.print(": cmd " + ((MDirectToolItem)child).getContributionURI());
                TestUtil.printIcon(level, (MUILabel)child);
                continue;
            }
            if (child instanceof MHandledToolItem) {
                System.out.print(": cmd " + ((MHandledToolItem)child).getCommand().getElementId());
                TestUtil.printIcon(level, (MUILabel)child);
                continue;
            }
            if (!(child instanceof MToolBarSeparator)) continue;
            System.out.print(": separator ");
        }
    }

    public static void setupActionBuilderStructure(MMenu menuBar) {
        MMenu file = MenuFactoryImpl.eINSTANCE.createMenu();
        file.setElementId("file");
        file.setLabel("&File");
        menuBar.getChildren().add(file);
        MDirectMenuItem item = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item.setElementId("refresh");
        item.setLabel("Re&fresh");
        file.getChildren().add(item);
        item = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item.setElementId("exit");
        item.setLabel("&Exit");
        file.getChildren().add(item);
        MMenu edit = MenuFactoryImpl.eINSTANCE.createMenu();
        edit.setElementId("edit");
        edit.setLabel("&Edit");
        menuBar.getChildren().add(edit);
        item = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item.setElementId("cut");
        item.setLabel("Cu&t");
        edit.getChildren().add(item);
        item = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item.setElementId("copy");
        item.setLabel("&Copy");
        edit.getChildren().add(item);
        item = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item.setElementId("paste");
        item.setLabel("&Paste");
        edit.getChildren().add(item);
        MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        sep.setElementId("copy.ext");
        sep.setVisible(false);
        edit.getChildren().add(sep);
        sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        sep.setElementId("additions");
        sep.setVisible(false);
        menuBar.getChildren().add(sep);
        MMenu window = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setElementId("window");
        window.setLabel("&Window");
        menuBar.getChildren().add(window);
        item = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item.setElementId("newWindow");
        item.setLabel("&New Window");
        window.getChildren().add(item);
        item = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item.setElementId("preferences");
        item.setLabel("&Preferences");
        window.getChildren().add(item);
    }

    public static void setupActionBuilderStructure(MTrimBar coolbar) {
        MToolBar groupFile = MenuFactoryImpl.eINSTANCE.createToolBar();
        groupFile.setElementId("group.file");
        groupFile.setVisible(false);
        coolbar.getChildren().add(groupFile);
        MToolBar fileToolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        fileToolBar.setElementId("org.eclipse.ui.workbench.file");
        MToolBarSeparator sep = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        sep.setElementId("new.group");
        fileToolBar.getChildren().add(sep);
        sep = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        sep.setElementId("save.group");
        sep.setVisible(false);
        fileToolBar.getChildren().add(sep);
        sep = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        sep.setElementId("new.ext");
        sep.setVisible(false);
        fileToolBar.getChildren().add(sep);
        MDirectToolItem item = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        item.setElementId("save");
        item.setLabel("S&ave");
        fileToolBar.getChildren().add(item);
        item = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        item.setElementId("saveAll");
        item.setLabel("Sa&ve All");
        fileToolBar.getChildren().add(item);
        sep = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        sep.setElementId("save.ext");
        sep.setVisible(false);
        fileToolBar.getChildren().add(sep);
        item = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        item.setElementId("print");
        item.setLabel("&Print");
        fileToolBar.getChildren().add(item);
        sep = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        sep.setElementId("print.ext");
        sep.setVisible(false);
        fileToolBar.getChildren().add(sep);
        sep = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        sep.setElementId("build.group");
        fileToolBar.getChildren().add(sep);
        sep = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        sep.setElementId("build.ext");
        sep.setVisible(false);
        fileToolBar.getChildren().add(sep);
        sep = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        sep.setElementId("additions");
        fileToolBar.getChildren().add(sep);
        coolbar.getChildren().add(fileToolBar);
        MToolBar add = MenuFactoryImpl.eINSTANCE.createToolBar();
        add.setElementId("additions");
        add.setVisible(false);
        coolbar.getChildren().add(add);
        MToolBar groupNav = MenuFactoryImpl.eINSTANCE.createToolBar();
        groupNav.setElementId("group.nav");
        groupNav.setVisible(false);
        coolbar.getChildren().add(groupNav);
        MToolBar navToolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        navToolBar.setElementId("org.eclipse.ui.workbench.navigate");
        sep = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        sep.setElementId("history.group");
        navToolBar.getChildren().add(sep);
        sep = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        sep.setElementId("group.application");
        sep.setVisible(false);
        navToolBar.getChildren().add(sep);
        item = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        item.setElementId("backwardHistory");
        item.setLabel("Backward");
        navToolBar.getChildren().add(item);
        item = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        item.setElementId("forwardHistory");
        item.setLabel("Forward");
        navToolBar.getChildren().add(item);
        sep = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        sep.setElementId("pin.group");
        navToolBar.getChildren().add(sep);
        coolbar.getChildren().add(navToolBar);
    }

    public static void setupCommandImageService(IEclipseContext ctx) {
        CmdService cs = (CmdService)ContextInjectionFactory.make(CmdService.class, (IEclipseContext)ctx);
        CommandImageService service = new CommandImageService(new CommandImageManager(), (ICommandService)cs);
        service.readRegistry();
        ctx.set(ICommandImageService.class, (Object)service);
    }

    public static MApplication setupRenderer(IEclipseContext appContext) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(appContext);
        appContext.set(MApplication.class, (Object)application);
        MBindingContext rootContext = CommandsFactoryImpl.eINSTANCE.createBindingContext();
        rootContext.setElementId(ORG_ECLIPSE_UI_CONTEXTS_ACTION_SET);
        rootContext.setName("ActionSets");
        application.getRootContext().add(rootContext);
        EContextService ecs = (EContextService)appContext.get(EContextService.class);
        Context actionSet = ecs.getContext(ORG_ECLIPSE_UI_CONTEXTS_ACTION_SET);
        if (!actionSet.isDefined()) {
            actionSet.define("ActionSets", null, null);
        }
        TestUtil.setupRendererServices(appContext);
        TestUtil.setupCommandImageService(appContext);
        MTrimmedWindow window = BasicFactoryImpl.eINSTANCE.createTrimmedWindow();
        window.setContext(appContext.createChild("MWindowContext"));
        MMenu menuBar = MenuFactoryImpl.eINSTANCE.createMenu();
        menuBar.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(menuBar);
        MTrimBar coolbar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        coolbar.setElementId("org.eclipse.ui.main.toolbar");
        coolbar.setSide(SideValue.TOP);
        window.getTrimBars().add(coolbar);
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        window.getContext().activate();
        Display display = Display.getDefault();
        appContext.set(Display.class, (Object)display);
        final MenuManagerRenderer menuRenderer = new MenuManagerRenderer();
        final ToolBarManagerRenderer tbRenderer = new ToolBarManagerRenderer();
        appContext.set(IRendererFactory.class, (Object)new IRendererFactory(){

            public AbstractPartRenderer getRenderer(MUIElement uiElement, Object parent) {
                if (uiElement instanceof MMenu) {
                    return menuRenderer;
                }
                if (uiElement instanceof MToolBar) {
                    return tbRenderer;
                }
                return null;
            }
        });
        menuRenderer.init(appContext);
        ContextInjectionFactory.inject((Object)menuRenderer, (IEclipseContext)appContext);
        tbRenderer.init(appContext);
        ContextInjectionFactory.inject((Object)tbRenderer, (IEclipseContext)appContext);
        ((Notifier)application).eAdapters().add((Object)new UIEventPublisher(appContext));
        return application;
    }

    public static void setupRendererServices(IEclipseContext appContext) {
        appContext.set(Logger.class, (Object)new Logger(){

            public String getName() {
                return "Fake Logger";
            }

            public boolean isLoggable(int level) {
                return false;
            }

            public void log(int level, String message) {
            }

            public void log(int level, String message, Throwable exception) {
            }

            public void log(Object context, int level, String message) {
            }

            public void log(Object context, int level, String message, Throwable exception) {
            }

            public void log(ServiceReference<?> sr, int level, String message) {
            }

            public void log(ServiceReference<?> sr, int level, String message, Throwable exception) {
            }
        });
        appContext.set(IResourceUtilities.class, (Object)new ISWTResourceUtilities(){

            public ImageDescriptor imageDescriptorFromURI(URI iconPath) {
                try {
                    return ImageDescriptor.createFromURL((URL)new URL(iconPath.toString()));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        appContext.set(IPresentationEngine.class, (Object)new IPresentationEngine(){

            public Object createGui(MUIElement element) {
                return null;
            }

            public Object createGui(MUIElement element, Object parentWidget, IEclipseContext parentContext) {
                return null;
            }

            public void removeGui(MUIElement element) {
            }

            public Object run(MApplicationElement uiRoot, IEclipseContext appContext) {
                return null;
            }

            public void stop() {
            }
        });
    }

    private TestUtil() {
    }
}

