/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyValue;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.CollectionValueReference;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.UnionProperty;
import org.polarsys.capella.core.data.information.datavalue.BooleanReference;
import org.polarsys.capella.core.data.information.datavalue.ComplexValueReference;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.EnumerationReference;
import org.polarsys.capella.core.data.information.datavalue.NumericReference;
import org.polarsys.capella.core.data.information.datavalue.StringReference;
import org.polarsys.capella.core.data.information.datavalue.ValuePart;
import org.polarsys.capella.core.model.helpers.PropertyExt;
import org.polarsys.capella.docgen.util.CapellaAssociationService;
import org.polarsys.capella.docgen.util.CapellaDataValueServices;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;
import org.polarsys.kitalpha.doc.gen.business.core.util.EObjectLabelProviderHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.LabelProviderHelper;

public class CapellaPropertyServices {
    public static final Predicate<Property> isAssociationPropertyPredicate = property -> property.getAggregationKind().getValue() == 1;

    public static String getPropertyValueInformation(AbstractPropertyValue prop_p, String projectName, String outputFolder) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)prop_p, projectName, outputFolder));
        buffer.append(" ");
        buffer.append("<b>");
        buffer.append(prop_p.getName());
        buffer.append("</b>");
        buffer.append(" = ");
        buffer.append(CapellaPropertyServices.getValueFromPropertyValue(prop_p));
        return buffer.toString();
    }

    public static String getValuePartInformation(ValuePart valuepart_p, String projectName, String outputFolder) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)valuepart_p, projectName, outputFolder));
        buffer.append(" ");
        buffer.append("<b>");
        Property referencedProperty = valuepart_p.getReferencedProperty();
        String referencedPropertyLink = "&ltundefined&gt";
        if (referencedProperty != null) {
            referencedPropertyLink = CapellaServices.getHyperlinkFromElement((EObject)referencedProperty);
        }
        buffer.append("Value for " + referencedPropertyLink);
        buffer.append("</b>");
        return buffer.toString();
    }

    public static String getPropertyValueInformation(EnumerationPropertyValue prop_p) {
        if (prop_p.getType() != null && prop_p.getValue() != null && "".equals(prop_p.getValue().toString())) {
            return String.valueOf(CapellaServices.getHyperlinkFromElement((EObject)prop_p)) + " : " + prop_p.getType().getName() + "." + prop_p.getValue();
        }
        return CapellaServices.getHyperlinkFromElement((EObject)prop_p);
    }

    public static String getInformationFromPropertyIncludingAssociation(Property property, String projectName, String outputFolder) {
        StringBuilder buffer = new StringBuilder();
        if (isAssociationPropertyPredicate.test(property)) {
            buffer.append(CapellaPropertyServices.getAssociationImageAndHyperlink(property, projectName, outputFolder));
            buffer.append("<ul class=\"generatedList\">");
            buffer.append("<li>");
        }
        buffer.append(CapellaPropertyServices.getInformationFromProperty(property, projectName, outputFolder));
        if (isAssociationPropertyPredicate.test(property)) {
            buffer.append("</li>");
            buffer.append("</ul>");
        }
        return buffer.toString();
    }

    public static String getInformationFromProperty(Property property, String projectName, String outputFolder) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)property, projectName, outputFolder));
        buffer.append(" ");
        CapellaPropertyServices.getAttributesInformationFromProperty(property, buffer);
        buffer.append(" ");
        CapellaPropertyServices.getNameAndValueInformationFromProperty(property, buffer);
        if (property instanceof UnionProperty) {
            String qualifier = CapellaPropertyServices.computeUnionPropertyLabelWithQualifier((UnionProperty)property);
            buffer.append(qualifier);
        }
        if (property.getDescription() != null) {
            buffer.append("<p>");
            buffer.append(StringUtil.transformAREFString((EObject)property, property.getDescription(), projectName, outputFolder));
            buffer.append("</p>");
        }
        CapellaPropertyServices.getFeaturesInformationFromProperty(property, buffer);
        String propertyValues = CapellaPropertyServices.getPropertyValues((EList<AbstractPropertyValue>)property.getOwnedPropertyValues(), projectName, outputFolder);
        if (propertyValues != null && propertyValues.length() > 0) {
            buffer.append(propertyValues);
        }
        buffer.append("</ul>");
        return buffer.toString();
    }

    private static void getNameAndValueInformationFromProperty(Property property, StringBuilder buffer) {
        buffer.append("<b>");
        buffer.append(property.getName());
        if (property.getOwnedMinCard() != null && property.getOwnedMaxCard() != null) {
            buffer.append("[");
            buffer.append(CapellaDataValueServices.getSimpleValueOfDataValue((DataValue)property.getOwnedMinCard()));
            buffer.append(", ");
            buffer.append(CapellaDataValueServices.getSimpleValueOfDataValue((DataValue)property.getOwnedMaxCard()));
            buffer.append("]");
        }
        buffer.append("</b>");
        buffer.append(" : ");
        if (property.getType() != null) {
            buffer.append(CapellaServices.getFullDataPkgHierarchyLink((EObject)property.getType()));
        }
    }

    private static void getFeaturesInformationFromProperty(Property property, StringBuilder buffer) {
        ArrayList<String> features = new ArrayList<String>();
        if (property.getOwnedMinValue() != null) {
            features.add("<b>Min\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue(property.getOwnedMinValue()));
        }
        if (property.getOwnedMaxValue() != null) {
            features.add("<b>Max\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue(property.getOwnedMaxValue()));
        }
        if (property.getOwnedMinLength() != null) {
            features.add("<b>Min. length\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue((DataValue)property.getOwnedMinLength()));
        }
        if (property.getOwnedMaxLength() != null) {
            features.add("<b>Max. length\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue((DataValue)property.getOwnedMaxLength()));
        }
        if (property.getOwnedDefaultValue() != null) {
            features.add("<b>Default\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue(property.getOwnedDefaultValue()));
        }
        if (property.getOwnedNullValue() != null) {
            features.add("<b>Null\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue(property.getOwnedNullValue()));
        }
        buffer.append("<ul class=\"generatedList\">");
        for (String featureString : features) {
            buffer.append("<li>" + featureString + "</li>");
        }
    }

    private static void getAttributesInformationFromProperty(Property property, StringBuilder buffer) {
        buffer.append("<b>");
        if (property.isIsAbstract()) {
            buffer.append("{abstract}  ");
        }
        if (property.isIsStatic()) {
            buffer.append("{static}  ");
        }
        if (property.isIsPartOfKey()) {
            buffer.append("{key}  ");
        }
        if (property.getAggregationKind().getValue() == 1) {
            buffer.append("{ref}  ");
        }
        if (property.isIsDerived()) {
            buffer.append("{derived}  ");
        }
        if (property.isIsReadOnly()) {
            buffer.append("{readonly}  ");
        }
        if (property.isOrdered()) {
            buffer.append("{ordered}  ");
        }
        if (property.isUnique()) {
            buffer.append("{unique}  ");
        }
        buffer.append("</b>");
    }

    public static String getAssociationImageAndHyperlink(Property property, String projectName, String outputFolder) {
        Association regardingAssociation = PropertyExt.getRegardingAssociation((CapellaElement)property);
        return CapellaAssociationService.getInformationFromAssociation(regardingAssociation, projectName, outputFolder);
    }

    public static String getPropertyValues(EList<AbstractPropertyValue> ownedPropertyValues, String projectName, String outputFolder) {
        StringBuilder buffer = new StringBuilder();
        ArrayList<String> propertiesValues = new ArrayList<String>();
        for (AbstractPropertyValue currentAbstractPropertyValue : ownedPropertyValues) {
            propertiesValues.add(CapellaPropertyServices.getPropertyValueInformation(currentAbstractPropertyValue, projectName, outputFolder));
        }
        if (propertiesValues.size() > 0) {
            buffer.append("<li>");
            buffer.append("Property-values");
            buffer.append(StringUtil.stringListToBulette(propertiesValues));
            buffer.append("</li>");
        }
        return buffer.toString();
    }

    private static String computeUnionPropertyLabelWithQualifier(UnionProperty property_p) {
        String result = "";
        EList qualifier = property_p.getQualifier();
        if (qualifier != null && qualifier.size() > 0) {
            result = String.valueOf(result) + " { ";
            int i = 0;
            while (i < qualifier.size()) {
                DataValue element = (DataValue)qualifier.get(i);
                result = String.valueOf(result) + CapellaPropertyServices.getDataValueText(element, i == qualifier.size() - 1);
                ++i;
            }
            result = String.valueOf(result) + " }";
        }
        return result;
    }

    private static String getDataValueText(DataValue dataValue, boolean last) {
        if (CapellaPropertyServices.ignoreDataValue(dataValue)) {
            return String.valueOf(EObjectLabelProviderHelper.getText((EObject)dataValue)) + (last ? "" : ", ");
        }
        return String.valueOf(CapellaServices.getHyperlinkFromElement((EObject)dataValue)) + (last ? "" : ", ");
    }

    private static boolean ignoreDataValue(DataValue element) {
        return element instanceof BooleanReference || element instanceof NumericReference || element instanceof EnumerationReference || element instanceof StringReference || element instanceof ComplexValueReference || element instanceof CollectionValueReference;
    }

    private static String getValueFromPropertyValue(AbstractPropertyValue propertyValue) {
        Method methodGetValue = null;
        try {
            methodGetValue = propertyValue.getClass().getMethod("getValue", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                methodGetValue = propertyValue.getClass().getMethod("isValue", new Class[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (methodGetValue != null) {
            try {
                Object object = methodGetValue.invoke((Object)propertyValue, new Object[0]);
                if (object instanceof EObject) {
                    return LabelProviderHelper.getText((EObject)((EObject)object));
                }
                if (object != null) {
                    return object.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }
}

