/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.docgen.util.DocGenHtmlCapellaControl;
import org.polarsys.capella.docgen.util.DocGenHtmlCapellaUtil;
import org.polarsys.kitalpha.doc.gen.business.core.scope.GenerationGlobalScope;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.DocGenHtmlUtil;
import org.polarsys.kitalpha.doc.gen.business.core.util.EscapeChars;
import org.polarsys.kitalpha.doc.gen.business.core.util.LabelProviderHelper;

public class CapellaServices {
    public static final String BOLD_BEGIN = "<b>";
    public static final String BOLD_END = "</b>";
    public static final String ITALIC_BEGIN = "<i>";
    public static final String ITALIC_END = "</i>";
    public static final String SPAN_BEGIN_LABEL = "<span class=\"label\">";
    public static final String SPAN_END = "</span>";
    public static final String NEW_LINE = "<br/>";
    public static final String LI_OPEN = "<li>";
    public static final String LI_CLOSE = "</li>";
    public static final String UL_OPEN = "<ul class=\"generatedList\">";
    public static final String UL_OPEN_WITH_BORDER = "<ul class=\"generatedListWithBorder\">";
    public static final String UL_CLOSE = "</ul>";
    public static final String NONE = "None";
    public static final String NO_NAME = "<i>[No Name]</i>";
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String VALUE_PRESENTER = " : ";
    public static final String VALUE_EQUAL = " = ";
    public static final String IS_ABSTRACT = "Is Abstract\t:\t";
    public static final String IS_PRIMITIVE = "Is Primitive\t:\t";
    public static final String IS_DISCRETE = "Is Discrete\t:\t";
    public static final String PATTERN = "Pattern\t:\t";
    public static final String DEFAULT_FEATURE = "Default\t:\t";
    public static final String MIN_FEATURE = "Min\t:\t";
    public static final String MAX_FEATURE = "Max\t:\t";
    public static final String NULL_FEATURE = "Null\t:\t";
    public static final String MINLENGTH_FEATURE = "Min. length\t:\t";
    public static final String MAXLENGTH_FEATURE = "Max. length\t:\t";
    public static final String PROP_ABSTRACT = "abstract  ";
    public static final String PROP_STATIC = "static  ";
    public static final String PROP_KEY = "key  ";
    public static final String PROP_DERIVED = "derived  ";
    public static final String PROP_READONLY = "readonly  ";
    public static final String PROP_ORDERED = "ordered  ";
    public static final String PROP_UNIQUE = "unique  ";
    public static final String PROP_GENERATED = "generated  ";
    public static final String PROP_CHANGEABLE = "changeable  ";
    public static final String PROP_CRO_ABSTRACT = "{abstract}  ";
    public static final String PROP_CRO_STATIC = "{static}  ";
    public static final String PROP_CRO_KEY = "{key}  ";
    public static final String PROP_CRO_DERIVED = "{derived}  ";
    public static final String PROP_CRO_READONLY = "{readonly}  ";
    public static final String PROP_CRO_ORDERED = "{ordered}  ";
    public static final String PROP_CRO_UNIQUE = "{unique}  ";
    public static final String PROP_CRO_GENERATED = "{generated}  ";
    public static final String PROP_CRO_CHANGEABLE = "{changeable}  ";
    public static final String MIN = "MIN  ";
    public static final String MAX = "MAX  ";
    public static final String DEFAULT = "DEFAULT  ";
    public static final String NULL = "NULL  ";
    public static final String UNDEFINED = "undefined";
    public static final String UNDEFINED_CHEVRON = "&lt;undefined&gt;";
    public static final String PAR_OPEN = "(  ";
    public static final String PAR_CLOSE = " )";
    public static final String CRO_OPEN = "[";
    public static final String CRO_CLOSE = "]";
    public static final String COMMA = ", ";
    public static final String CHEV_OPEN = "&lt";
    public static final String CHEV_CLOSE = "&gt";
    protected static final String HYPERLINK_OPEN = "<a href=\"";
    protected static final String HYPERLINK_SEPARATOR = "/";
    protected static final String HYPERLINK_COMPLETE = "\">";
    protected static final String HYPERLINK_CLOSE = "</a>";
    private static final Object PATH_OPEN = "../";
    private static final Object PATH_COMPLETE = ".html";

    public static String getHyperlinkFromElement(EObject element, String label) {
        if (element instanceof DSemanticDiagram) {
            return CapellaServices.getHyperlinkFromDiagram((DSemanticDiagram)element);
        }
        int linked = CapellaServices.isLinkable(element);
        String text = label;
        text = EscapeChars.forHTML((String)text);
        StringBuffer buffer = new StringBuffer();
        if (linked != -1) {
            buffer.append(HYPERLINK_OPEN);
            if (linked == 1) {
                buffer.append(CapellaServices.getPathFromElement(element.eContainer()));
                buffer.append("#");
                buffer.append(CapellaServices.getAnchorId(element));
            } else {
                buffer.append(CapellaServices.getPathFromElement(element));
            }
            buffer.append(HYPERLINK_COMPLETE);
        }
        buffer.append(text);
        if (linked != -1) {
            buffer.append(HYPERLINK_CLOSE);
        }
        return buffer.toString();
    }

    public static String getHyperlinkFromElement(EObject element) {
        return CapellaServices.getHyperlinkFromElement(element, LabelProviderHelper.getText((EObject)element));
    }

    public static boolean isElementLinkable(EObject element) {
        return CapellaServices.isLinkable(element) >= 0;
    }

    public static int isLinkable(EObject element) {
        if (!GenerationGlobalScope.getInstance().inScope(element, true)) {
            return -1;
        }
        if (element instanceof CapellaElement) {
            if (DocGenHtmlCapellaControl.isPageCandidate((CapellaElement)element)) {
                return 0;
            }
            EObject parent = element.eContainer();
            if (parent instanceof CapellaElement && DocGenHtmlCapellaControl.isPageCandidate((CapellaElement)parent)) {
                return 1;
            }
        }
        return -1;
    }

    public static int isLinkableWithoutScope(EObject element) {
        if (element instanceof CombinedFragment || element instanceof InteractionOperand) {
            return -1;
        }
        if (element instanceof CapellaElement) {
            if (DocGenHtmlCapellaControl.isPageCandidate((CapellaElement)element)) {
                return 0;
            }
            EObject parent = element.eContainer();
            if (parent instanceof CapellaElement && DocGenHtmlCapellaControl.isPageCandidate((CapellaElement)parent)) {
                return 1;
            }
        }
        return -1;
    }

    public static String getPathFromElement(EObject element) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PATH_OPEN);
        buffer.append(DocGenHtmlUtil.getModelName((EObject)element));
        buffer.append(HYPERLINK_SEPARATOR);
        buffer.append(DocGenHtmlCapellaUtil.SERVICE.getFileName(element));
        buffer.append(PATH_COMPLETE);
        return buffer.toString();
    }

    private static String getHyperlinkFromDiagram(DSemanticDiagram diagram) {
        String text = LabelProviderHelper.getText((EObject)diagram);
        text = EscapeChars.forHTML((String)text);
        StringBuffer buffer = new StringBuffer();
        buffer.append(HYPERLINK_OPEN);
        buffer.append(CapellaServices.getPathFromElement(diagram.getTarget()));
        buffer.append("#");
        buffer.append(CapellaServices.getDiagramId(diagram));
        buffer.append(HYPERLINK_COMPLETE);
        buffer.append(text);
        buffer.append(HYPERLINK_CLOSE);
        return buffer.toString();
    }

    public static String getAnchorId(EObject element) {
        String id = "id" + EcoreUtil.getURI((EObject)element).fragment();
        return id;
    }

    @Deprecated
    public static String getDiagramId(DSemanticDiagram diagram) {
        return CapellaServices.getDiagramUid(diagram);
    }

    public static String getDiagramUid(DSemanticDiagram diagram) {
        return diagram.getUid();
    }

    public static String getImageLinkFromElement(EObject element, String projectName, String outputFolder) {
        String imageFileName = LabelProviderHelper.getImageFileName((EObject)element, (String)projectName, (String)outputFolder);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<img src=\"../icon/");
        buffer.append(imageFileName);
        buffer.append("\" alt=\"");
        buffer.append(element.eClass().getName());
        buffer.append("\" />");
        return buffer.toString();
    }

    public static String getImageLinkForDiagram(String generatedFolder, DSemanticDiagram diagram) {
        StringBuilder builder = new StringBuilder();
        String fileName = DocGenHtmlCapellaUtil.getCapellaElementFileName((CapellaElement)diagram.getTarget());
        builder.append(HYPERLINK_OPEN);
        builder.append(fileName);
        builder.append("#");
        builder.append(DiagramSessionHelper.getID((EObject)diagram));
        builder.append(HYPERLINK_COMPLETE);
        builder.append("<img id=\"");
        builder.append(diagram.hashCode());
        builder.append("\" src=\"");
        builder.append(generatedFolder);
        builder.append(HYPERLINK_SEPARATOR);
        String validFileName = DocGenHtmlUtil.getValidFileName((String)diagram.getName());
        builder.append(validFileName);
        builder.append(".jpg\" alt=\"").append(validFileName).append("\"/>");
        builder.append(HYPERLINK_CLOSE);
        return builder.toString();
    }

    public static String getFullDataPkgHierarchyLink(EObject elt) {
        return CapellaServices.getFullDataPkgHierarchyLink(elt, true);
    }

    public static String getFullDataPkgHierarchyLink(EObject elt, boolean linkedLastElement) {
        StringBuffer buffer = new StringBuffer();
        for (EObject pkg : CapellaServices.getPackageElementPath(elt)) {
            buffer.append(CapellaServices.getHyperlinkFromElement(pkg));
            buffer.append(".");
        }
        if (linkedLastElement) {
            buffer.append(CapellaServices.getHyperlinkFromElement(elt));
        } else {
            buffer.append(LabelProviderHelper.getText((EObject)elt));
        }
        return buffer.toString();
    }

    public static String getElementPath(EObject element) {
        StringBuffer buffer = new StringBuffer();
        Iterator<EObject> iterator = CapellaServices.getFullElementPath(element).iterator();
        while (iterator.hasNext()) {
            buffer.append(CapellaServices.getHyperlinkFromElement(iterator.next()));
            if (!iterator.hasNext()) continue;
            buffer.append(" > ");
        }
        return buffer.toString();
    }

    private static List<EObject> getFullElementPath(EObject element) {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        EObject parent = element.eContainer();
        if (parent instanceof EObject) {
            eObjects.addAll(CapellaServices.getFullElementPath(parent));
        }
        eObjects.add(element);
        return eObjects;
    }

    private static List<EObject> getPackageElementPath(EObject element) {
        EObject parent = element.eContainer();
        if (parent instanceof AbstractDependenciesPkg || parent instanceof Classifier) {
            return CapellaServices.getPkgTree(parent);
        }
        return Collections.emptyList();
    }

    private static List<EObject> getPkgTree(EObject pkg) {
        ArrayList<EObject> pkgs = new ArrayList<EObject>();
        pkgs.add(pkg);
        EObject parent = pkg.eContainer();
        if (parent instanceof AbstractDependenciesPkg) {
            pkgs.addAll(0, CapellaServices.getPkgTree((EObject)((AbstractDependenciesPkg)parent)));
        }
        return pkgs;
    }

    public static List<EObject> removeDuplicates(List<EObject> list) {
        HashSet<EObject> set = new HashSet<EObject>(list);
        list.clear();
        list.addAll(set);
        return list;
    }

    public static String buildHyperlinkWithIcon(String projectName, String outputFolder, EObject object) {
        StringBuffer hyperLinkBuffer = new StringBuffer();
        hyperLinkBuffer.append(CapellaServices.getImageLinkFromElement(object, projectName, outputFolder));
        hyperLinkBuffer.append(SPACE);
        hyperLinkBuffer.append(CapellaServices.getHyperlinkFromElement(object));
        return hyperLinkBuffer.toString();
    }

    public static String buildNameWithIcon(String projectName, String outputFolder, CapellaElement object) {
        StringBuffer hyperLinkBuffer = new StringBuffer();
        hyperLinkBuffer.append(CapellaServices.getImageLinkFromElement((EObject)object, projectName, outputFolder));
        hyperLinkBuffer.append(SPACE);
        hyperLinkBuffer.append(object.getLabel());
        return hyperLinkBuffer.toString();
    }
}

