/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.console.internal;

public class ConsoleDocument {
    public static final int ERROR = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int DELIMITER = 3;
    private int[] _lineTypes;
    private String[] _lines;
    private int[] _lineNestings;
    private int _writeIndex = 0;
    private int _readIndex = 0;
    private static final int BUFFER_SIZE = 200;

    public void clear() {
        this._lineTypes = null;
        this._lines = null;
        this._writeIndex = 0;
        this._readIndex = 0;
    }

    public void appendConsoleLine(int type, String line, int nesting) {
        if (this._lines == null) {
            this._lines = new String[200];
            this._lineTypes = new int[200];
            this._lineNestings = new int[200];
        }
        this._lines[this._writeIndex] = line;
        this._lineTypes[this._writeIndex] = type;
        this._lineNestings[this._writeIndex] = nesting;
        if (++this._writeIndex >= 200) {
            this._writeIndex = 0;
        }
        if (this._writeIndex == this._readIndex && ++this._readIndex >= 200) {
            this._readIndex = 0;
        }
    }

    public ConsoleLine[] getLines() {
        if (this.isEmpty()) {
            return new ConsoleLine[0];
        }
        ConsoleLine[] docLines = new ConsoleLine[this._readIndex > this._writeIndex ? 200 : this._writeIndex];
        int index = this._readIndex;
        int i = 0;
        while (i < docLines.length) {
            docLines[i] = new ConsoleLine(this._lines[index], this._lineTypes[index], this._lineNestings[index]);
            if (++index >= 200) {
                index = 0;
            }
            ++i;
        }
        return docLines;
    }

    public boolean isEmpty() {
        return this._writeIndex == this._readIndex;
    }

    public static class ConsoleLine {
        public String _line;
        public int _type;
        public int _nesting;

        ConsoleLine(String line, int type, int nesting) {
            this._line = line;
            this._type = type;
            this._nesting = nesting;
        }
    }
}

