/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.annotations;

import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.impl.NamedElementAnnotations;

public final class FBAnnotations {
    public static boolean isResourceFB(FB fb) {
        if (fb.getFbNetwork().eContainer() instanceof Resource) {
            return fb.getMapping() == null || fb.equals(fb.getMapping().getFrom());
        }
        return false;
    }

    public static FBNetwork loadCFBNetwork(CFBInstance cfb) {
        FBNetwork fbNetwork = cfb.getCfbNetwork();
        if (fbNetwork == null) {
            fbNetwork = FBNetworkHelper.copyCFBNetWork(cfb.getType().getFBNetwork(), cfb.getInterface());
            cfb.setCfbNetwork(fbNetwork);
            fbNetwork.getEventConnections().forEach(Connection::checkIfConnectionBroken);
            fbNetwork.getDataConnections().forEach(Connection::checkIfConnectionBroken);
            fbNetwork.getAdapterConnections().forEach(Connection::checkIfConnectionBroken);
        }
        return fbNetwork;
    }

    public static Stream<INamedElement> findBySimpleName(CFBInstance root, String name) {
        FBAnnotations.loadCFBNetwork(root);
        return NamedElementAnnotations.findBySimpleName(root, name);
    }

    private FBAnnotations() {
        throw new UnsupportedOperationException("The utility class SubAppAnnotations should not be instatiated");
    }
}

