/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.AsyncReadyCallback;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell parent) {
        this(parent, 65536);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, FontDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public boolean getEffectsVisible() {
        return false;
    }

    @Deprecated
    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] result = new FontData[]{this.fontData};
        return result;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        boolean success;
        int response;
        byte[] titleBytes = Converter.javaStringToCString(this.title);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        final long handle = GTK.GTK_VERSION >= OS.VERSION(4, 10, 0) ? GTK4.gtk_font_dialog_new() : GTK.gtk_font_chooser_dialog_new(titleBytes, 0L);
        if (handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
            GTK4.gtk_font_dialog_set_modal(handle, true);
            GTK4.gtk_font_dialog_set_title(handle, titleBytes);
        } else {
            if (this.parent != null) {
                long shellHandle = this.parent.topHandle();
                GTK.gtk_window_set_transient_for(handle, shellHandle);
            }
            long defaultWindowGroup = GTK.gtk_window_get_group(0L);
            GTK.gtk_window_group_add_window(defaultWindowGroup, handle);
            GTK.gtk_window_set_modal(handle, true);
        }
        display.addIdleProc();
        Dialog oldModal = display.getModalDialog();
        display.setModalDialog(this);
        if (this.fontData != null && GTK.GTK_VERSION < OS.VERSION(4, 10, 0)) {
            Font font = new Font((Device)display, this.fontData);
            long fontName = OS.pango_font_description_to_string(font.handle);
            int length = C.strlen(fontName);
            byte[] buffer = new byte[length + 1];
            C.memmove(buffer, fontName, (long)length);
            font.dispose();
            OS.g_free(fontName);
            GTK.gtk_font_chooser_set_font(handle, buffer);
        }
        int signalId = 0;
        long hookId = 0L;
        if ((this.style & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, display.emissionProc, handle, 0L);
        }
        long fontDesc = 0L;
        if (GTK.GTK4) {
            if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
                final long shellHandle = this.parent != null ? this.parent.topHandle() : 0L;
                final Font font = this.fontData != null ? new Font((Device)display, this.fontData) : null;
                fontDesc = SyncDialogUtil.run(display, new AsyncReadyCallback(){

                    @Override
                    public void async(long callback) {
                        GTK4.gtk_font_dialog_choose_font(handle, shellHandle, font != null ? font.handle : 0L, 0L, callback, 0L);
                    }

                    @Override
                    public long await(long result) {
                        return GTK4.gtk_font_dialog_choose_font_finish(handle, result, null);
                    }
                });
                if (font != null) {
                    font.dispose();
                }
                response = fontDesc != 0L ? -5 : -6;
            } else {
                response = SyncDialogUtil.run(display, handle, false);
            }
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            response = GTK3.gtk_dialog_run(handle);
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        display.setModalDialog(oldModal);
        boolean bl = success = response == -5;
        if (success) {
            if (GTK.GTK_VERSION < OS.VERSION(4, 10, 0)) {
                long fontName = GTK.gtk_font_chooser_get_font(handle);
                int length = C.strlen(fontName);
                byte[] buffer = new byte[length + 1];
                C.memmove(buffer, fontName, (long)length);
                OS.g_free(fontName);
                fontDesc = OS.pango_font_description_from_string(buffer);
            }
            Font font = Font.gtk_new(display, fontDesc);
            this.fontData = font.getFontData()[0];
            OS.pango_font_description_free(fontDesc);
        } else {
            this.fontData = null;
        }
        display.removeIdleProc();
        if (GTK.GTK4) {
            if (GTK.GTK_VERSION < OS.VERSION(4, 10, 0)) {
                GTK4.gtk_window_destroy(handle);
            }
        } else {
            GTK3.gtk_widget_destroy(handle);
        }
        return this.fontData;
    }

    public void setEffectsVisible(boolean visible) {
    }

    @Deprecated
    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

