/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnRename;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.util.PersistenceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameColumnHelper
implements IPersistable {
    private static final Logger LOG = LoggerFactory.getLogger(RenameColumnHelper.class);
    public static final String PERSISTENCE_KEY_RENAMED_COLUMN_HEADERS = ".renamedColumnHeaders";
    private final ColumnHeaderLayer columnHeaderLayer;
    protected Map<Integer, String> renamedColumnsLabelsByIndex = new TreeMap<Integer, String>();

    public RenameColumnHelper(ColumnHeaderLayer columnHeaderLayer) {
        this.columnHeaderLayer = columnHeaderLayer;
    }

    public boolean renameColumnPosition(int columnPosition, String customColumnName) {
        int index = this.columnHeaderLayer.getColumnIndexByPosition(columnPosition);
        return this.renameColumnIndex(index, customColumnName);
    }

    public boolean renameColumnIndex(int index, String customColumnName) {
        if (index >= 0) {
            if (customColumnName == null) {
                this.renamedColumnsLabelsByIndex.remove(index);
            } else {
                this.renamedColumnsLabelsByIndex.put(index, customColumnName);
            }
            return true;
        }
        return false;
    }

    public String getRenamedColumnLabel(int columnIndex) {
        return this.renamedColumnsLabelsByIndex.get(columnIndex);
    }

    public boolean isColumnRenamed(int columnIndex) {
        return this.renamedColumnsLabelsByIndex.get(columnIndex) != null;
    }

    public boolean isAnyColumnRenamed() {
        return this.renamedColumnsLabelsByIndex.size() > 0;
    }

    public void handleStructuralChanges(Collection<StructuralDiff> columnDiffs) {
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (StructuralDiff columnDiff : columnDiffs) {
            if (columnDiff.getDiffType() == null || !columnDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.DELETE)) continue;
            Range beforePositionRange = columnDiff.getBeforePositionRange();
            int i = beforePositionRange.start;
            while (i < beforePositionRange.end) {
                int index = i;
                if (index >= 0) {
                    toRemove.add(index);
                }
                ++i;
            }
        }
        for (Integer r : toRemove) {
            this.renamedColumnsLabelsByIndex.remove(r);
        }
        ArrayList<Integer> indices = new ArrayList<Integer>(this.renamedColumnsLabelsByIndex.keySet());
        Collections.sort(indices);
        TreeMap<Integer, String> modified = new TreeMap<Integer, String>();
        for (Integer column : indices) {
            int deletedBefore = 0;
            for (Integer removed : toRemove) {
                if (removed >= column) continue;
                ++deletedBefore;
            }
            int modColumn = column - deletedBefore;
            if (modColumn < 0) continue;
            modified.put(modColumn, this.renamedColumnsLabelsByIndex.get(column));
        }
        this.renamedColumnsLabelsByIndex.clear();
        this.renamedColumnsLabelsByIndex.putAll(modified);
        for (StructuralDiff columnDiff : columnDiffs) {
            if (columnDiff.getDiffType() == null || !columnDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.ADD)) continue;
            indices = new ArrayList<Integer>(this.renamedColumnsLabelsByIndex.keySet());
            Collections.sort(indices);
            Range beforePositionRange = columnDiff.getBeforePositionRange();
            Range afterPositionRange = columnDiff.getAfterPositionRange();
            TreeMap<Integer, String> modifiedColumns = new TreeMap<Integer, String>();
            int beforeIndex = this.columnHeaderLayer.getColumnIndexByPosition(beforePositionRange.start);
            for (Integer column : indices) {
                if (column >= beforeIndex) {
                    modifiedColumns.put(column + (afterPositionRange.end - afterPositionRange.start), this.renamedColumnsLabelsByIndex.get(column));
                    continue;
                }
                modifiedColumns.put(column, this.renamedColumnsLabelsByIndex.get(column));
            }
            this.renamedColumnsLabelsByIndex.clear();
            this.renamedColumnsLabelsByIndex.putAll(modifiedColumns);
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        Object property = properties.get(prefix + PERSISTENCE_KEY_RENAMED_COLUMN_HEADERS);
        try {
            this.renamedColumnsLabelsByIndex = PersistenceUtils.parseString(property);
        }
        catch (Exception e) {
            LOG.error("Error while restoring renamed column headers: {}", (Object)e.getMessage());
            LOG.error("Skipping restore.");
            this.renamedColumnsLabelsByIndex.clear();
        }
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        String string = PersistenceUtils.mapAsString(this.renamedColumnsLabelsByIndex);
        if (string != null && string.length() > 0) {
            properties.put(prefix + PERSISTENCE_KEY_RENAMED_COLUMN_HEADERS, string);
        }
    }
}

