/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.message.ParserCursor;

@Internal
public final class ContentCodingSupport {
    public static final int MAX_CODEC_LIST_LEN = 5;

    private ContentCodingSupport() {
    }

    public static List<String> parseContentCodecs(EntityDetails entityDetails) {
        if (entityDetails == null || entityDetails.getContentEncoding() == null) {
            return Collections.emptyList();
        }
        String contentEncoding = entityDetails.getContentEncoding();
        ParserCursor cursor = new ParserCursor(0, contentEncoding.length());
        ArrayList<String> codecs = new ArrayList<String>();
        MessageSupport.parseTokens((CharSequence)contentEncoding, (ParserCursor)cursor, token -> {
            String codec = token.toLowerCase(Locale.ROOT);
            if (!codec.isEmpty() && !"identity".equals(codec)) {
                codecs.add(codec);
            }
        });
        return codecs;
    }

    public static void validate(Collection<String> codecList, int maxCodecListLen) throws ProtocolException {
        if (maxCodecListLen > 0 && codecList.size() > maxCodecListLen) {
            throw new ProtocolException("Codec list exceeds maximum of " + maxCodecListLen + " elements");
        }
    }
}

