window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"ffmpeg_normalize": {"fullname": "ffmpeg_normalize", "modulename": "ffmpeg_normalize", "kind": "module", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize": {"fullname": "ffmpeg_normalize.FFmpegNormalize", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize", "kind": "class", "doc": "<p>ffmpeg-normalize class.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>normalization_type (str, optional):</strong>  Normalization type. Defaults to \"ebu\".</li>\n<li><strong>target_level (float, optional):</strong>  Target level. Defaults to -23.0.</li>\n<li><strong>print_stats (bool, optional):</strong>  Print loudnorm stats. Defaults to False.</li>\n<li><strong>loudness_range_target (float, optional):</strong>  Loudness range target. Defaults to 7.0.</li>\n<li><strong>keep_loudness_range_target (bool, optional):</strong>  Keep loudness range target. Defaults to False.</li>\n<li><strong>keep_lra_above_loudness_range_target (bool, optional):</strong>  Keep input loudness range above loudness range target. Defaults to False.</li>\n<li><strong>true_peak (float, optional):</strong>  True peak. Defaults to -2.0.</li>\n<li><strong>offset (float, optional):</strong>  Offset. Defaults to 0.0.</li>\n<li><strong>lower_only (bool, optional):</strong>  Whether the audio should not increase in loudness. Defaults to False.</li>\n<li><strong>auto_lower_loudness_target (bool, optional):</strong>  Automatically lower EBU Integrated Loudness Target.</li>\n<li><strong>dual_mono (bool, optional):</strong>  Dual mono. Defaults to False.</li>\n<li><strong>dynamic (bool, optional):</strong>  Dynamic. Defaults to False.</li>\n<li><strong>audio_codec (str, optional):</strong>  Audio codec. Defaults to \"pcm_s16le\".</li>\n<li><strong>audio_bitrate (float, optional):</strong>  Audio bitrate. Defaults to None.</li>\n<li><strong>sample_rate (int, optional):</strong>  Sample rate. Defaults to None.</li>\n<li><strong>audio_channels (int | None, optional):</strong>  Audio channels. Defaults to None.</li>\n<li><strong>keep_original_audio (bool, optional):</strong>  Keep original audio. Defaults to False.</li>\n<li><strong>pre_filter (str, optional):</strong>  Pre filter. Defaults to None.</li>\n<li><strong>post_filter (str, optional):</strong>  Post filter. Defaults to None.</li>\n<li><strong>video_codec (str, optional):</strong>  Video codec. Defaults to \"copy\".</li>\n<li><strong>video_disable (bool, optional):</strong>  Disable video. Defaults to False.</li>\n<li><strong>subtitle_disable (bool, optional):</strong>  Disable subtitles. Defaults to False.</li>\n<li><strong>metadata_disable (bool, optional):</strong>  Disable metadata. Defaults to False.</li>\n<li><strong>chapters_disable (bool, optional):</strong>  Disable chapters. Defaults to False.</li>\n<li><strong>extra_input_options (list, optional):</strong>  Extra input options. Defaults to None.</li>\n<li><strong>extra_output_options (list, optional):</strong>  Extra output options. Defaults to None.</li>\n<li><strong>output_format (str, optional):</strong>  Output format. Defaults to None.</li>\n<li><strong>extension (str, optional):</strong>  Output file extension to use for output files that were not explicitly specified. Defaults to \"mkv\".</li>\n<li><strong>dry_run (bool, optional):</strong>  Dry run. Defaults to False.</li>\n<li><strong>debug (bool, optional):</strong>  Debug. Defaults to False.</li>\n<li><strong>progress (bool, optional):</strong>  Progress. Defaults to False.</li>\n<li><strong>replaygain (bool, optional):</strong>  Write ReplayGain tags without normalizing. Defaults to False.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>FFmpegNormalizeError:</strong>  If the ffmpeg executable is not found or does not support the loudnorm filter.</li>\n</ul>\n"}, "ffmpeg_normalize.FFmpegNormalize.__init__": {"fullname": "ffmpeg_normalize.FFmpegNormalize.__init__", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">normalization_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;ebu&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rms&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;peak&#39;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;ebu&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">target_level</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mf\">23.0</span>,</span><span class=\"param\">\t<span class=\"n\">print_stats</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">loudness_range_target</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">7.0</span>,</span><span class=\"param\">\t<span class=\"n\">keep_loudness_range_target</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">keep_lra_above_loudness_range_target</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">true_peak</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"o\">-</span><span class=\"mf\">2.0</span>,</span><span class=\"param\">\t<span class=\"n\">offset</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span>,</span><span class=\"param\">\t<span class=\"n\">lower_only</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">auto_lower_loudness_target</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">dual_mono</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">dynamic</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">audio_codec</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;pcm_s16le&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">audio_bitrate</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sample_rate</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">audio_channels</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">keep_original_audio</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">pre_filter</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">post_filter</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">video_codec</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;copy&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">video_disable</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">subtitle_disable</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">metadata_disable</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">chapters_disable</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">extra_input_options</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">extra_output_options</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">output_format</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">extension</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;mkv&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">dry_run</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">debug</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">progress</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">replaygain</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span>)</span>"}, "ffmpeg_normalize.FFmpegNormalize.ffmpeg_exe": {"fullname": "ffmpeg_normalize.FFmpegNormalize.ffmpeg_exe", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.ffmpeg_exe", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities": {"fullname": "ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.has_loudnorm_capabilities", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.normalization_type": {"fullname": "ffmpeg_normalize.FFmpegNormalize.normalization_type", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.normalization_type", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.print_stats": {"fullname": "ffmpeg_normalize.FFmpegNormalize.print_stats", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.print_stats", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.loudness_range_target": {"fullname": "ffmpeg_normalize.FFmpegNormalize.loudness_range_target", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.loudness_range_target", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"fullname": "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.keep_loudness_range_target", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"fullname": "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.keep_lra_above_loudness_range_target", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.true_peak": {"fullname": "ffmpeg_normalize.FFmpegNormalize.true_peak", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.true_peak", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.offset": {"fullname": "ffmpeg_normalize.FFmpegNormalize.offset", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.offset", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.lower_only": {"fullname": "ffmpeg_normalize.FFmpegNormalize.lower_only", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.lower_only", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"fullname": "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.auto_lower_loudness_target", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.dual_mono": {"fullname": "ffmpeg_normalize.FFmpegNormalize.dual_mono", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.dual_mono", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.dynamic": {"fullname": "ffmpeg_normalize.FFmpegNormalize.dynamic", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.dynamic", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.sample_rate": {"fullname": "ffmpeg_normalize.FFmpegNormalize.sample_rate", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.sample_rate", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.audio_channels": {"fullname": "ffmpeg_normalize.FFmpegNormalize.audio_channels", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.audio_channels", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.audio_codec": {"fullname": "ffmpeg_normalize.FFmpegNormalize.audio_codec", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.audio_codec", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.audio_bitrate": {"fullname": "ffmpeg_normalize.FFmpegNormalize.audio_bitrate", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.audio_bitrate", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.keep_original_audio": {"fullname": "ffmpeg_normalize.FFmpegNormalize.keep_original_audio", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.keep_original_audio", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.video_codec": {"fullname": "ffmpeg_normalize.FFmpegNormalize.video_codec", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.video_codec", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.video_disable": {"fullname": "ffmpeg_normalize.FFmpegNormalize.video_disable", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.video_disable", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.subtitle_disable": {"fullname": "ffmpeg_normalize.FFmpegNormalize.subtitle_disable", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.subtitle_disable", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.metadata_disable": {"fullname": "ffmpeg_normalize.FFmpegNormalize.metadata_disable", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.metadata_disable", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.chapters_disable": {"fullname": "ffmpeg_normalize.FFmpegNormalize.chapters_disable", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.chapters_disable", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.extra_input_options": {"fullname": "ffmpeg_normalize.FFmpegNormalize.extra_input_options", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.extra_input_options", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.extra_output_options": {"fullname": "ffmpeg_normalize.FFmpegNormalize.extra_output_options", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.extra_output_options", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.pre_filter": {"fullname": "ffmpeg_normalize.FFmpegNormalize.pre_filter", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.pre_filter", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.post_filter": {"fullname": "ffmpeg_normalize.FFmpegNormalize.post_filter", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.post_filter", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.output_format": {"fullname": "ffmpeg_normalize.FFmpegNormalize.output_format", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.output_format", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.extension": {"fullname": "ffmpeg_normalize.FFmpegNormalize.extension", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.extension", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.dry_run": {"fullname": "ffmpeg_normalize.FFmpegNormalize.dry_run", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.dry_run", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.debug": {"fullname": "ffmpeg_normalize.FFmpegNormalize.debug", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.debug", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.progress": {"fullname": "ffmpeg_normalize.FFmpegNormalize.progress", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.progress", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.replaygain": {"fullname": "ffmpeg_normalize.FFmpegNormalize.replaygain", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.replaygain", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.stats": {"fullname": "ffmpeg_normalize.FFmpegNormalize.stats", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.stats", "kind": "variable", "doc": "<p></p>\n", "annotation": ": list[ffmpeg_normalize._streams.LoudnessStatisticsWithMetadata]"}, "ffmpeg_normalize.FFmpegNormalize.media_files": {"fullname": "ffmpeg_normalize.FFmpegNormalize.media_files", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.media_files", "kind": "variable", "doc": "<p></p>\n", "annotation": ": list[ffmpeg_normalize._media_file.MediaFile]"}, "ffmpeg_normalize.FFmpegNormalize.file_count": {"fullname": "ffmpeg_normalize.FFmpegNormalize.file_count", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.file_count", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"fullname": "ffmpeg_normalize.FFmpegNormalize.add_media_file", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.add_media_file", "kind": "function", "doc": "<p>Add a media file to normalize</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>input_file (str):</strong>  Path to input file</li>\n<li><strong>output_file (str):</strong>  Path to output file</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">input_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">output_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"fullname": "ffmpeg_normalize.FFmpegNormalize.run_normalization", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalize.run_normalization", "kind": "function", "doc": "<p>Run the normalization procedures</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "ffmpeg_normalize.FFmpegNormalizeError": {"fullname": "ffmpeg_normalize.FFmpegNormalizeError", "modulename": "ffmpeg_normalize", "qualname": "FFmpegNormalizeError", "kind": "class", "doc": "<p>Common base class for all non-exit exceptions.</p>\n", "bases": "builtins.Exception"}, "ffmpeg_normalize.MediaFile": {"fullname": "ffmpeg_normalize.MediaFile", "modulename": "ffmpeg_normalize", "qualname": "MediaFile", "kind": "class", "doc": "<p>Class that holds a file, its streams and adjustments</p>\n"}, "ffmpeg_normalize.MediaFile.__init__": {"fullname": "ffmpeg_normalize.MediaFile.__init__", "modulename": "ffmpeg_normalize", "qualname": "MediaFile.__init__", "kind": "function", "doc": "<p>Initialize a media file for later normalization by parsing the streams.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>ffmpeg_normalize (FFmpegNormalize):</strong>  reference to overall settings</li>\n<li><strong>input_file (str):</strong>  Path to input file</li>\n<li><strong>output_file (str):</strong>  Path to output file</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">ffmpeg_normalize</span><span class=\"p\">:</span> <span class=\"n\">ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">_ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">FFmpegNormalize</span>,</span><span class=\"param\">\t<span class=\"n\">input_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">output_file</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, "ffmpeg_normalize.MediaFile.ffmpeg_normalize": {"fullname": "ffmpeg_normalize.MediaFile.ffmpeg_normalize", "modulename": "ffmpeg_normalize", "qualname": "MediaFile.ffmpeg_normalize", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.MediaFile.skip": {"fullname": "ffmpeg_normalize.MediaFile.skip", "modulename": "ffmpeg_normalize", "qualname": "MediaFile.skip", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.MediaFile.input_file": {"fullname": "ffmpeg_normalize.MediaFile.input_file", "modulename": "ffmpeg_normalize", "qualname": "MediaFile.input_file", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.MediaFile.output_file": {"fullname": "ffmpeg_normalize.MediaFile.output_file", "modulename": "ffmpeg_normalize", "qualname": "MediaFile.output_file", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.MediaFile.streams": {"fullname": "ffmpeg_normalize.MediaFile.streams", "modulename": "ffmpeg_normalize", "qualname": "MediaFile.streams", "kind": "variable", "doc": "<p></p>\n", "annotation": ": ffmpeg_normalize._media_file.StreamDict"}, "ffmpeg_normalize.MediaFile.temp_file": {"fullname": "ffmpeg_normalize.MediaFile.temp_file", "modulename": "ffmpeg_normalize", "qualname": "MediaFile.temp_file", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]"}, "ffmpeg_normalize.MediaFile.parse_streams": {"fullname": "ffmpeg_normalize.MediaFile.parse_streams", "modulename": "ffmpeg_normalize", "qualname": "MediaFile.parse_streams", "kind": "function", "doc": "<p>Try to parse all input streams from file and set them in self.streams.</p>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>FFmpegNormalizeError:</strong>  If no audio streams are found</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "ffmpeg_normalize.MediaFile.run_normalization": {"fullname": "ffmpeg_normalize.MediaFile.run_normalization", "modulename": "ffmpeg_normalize", "qualname": "MediaFile.run_normalization", "kind": "function", "doc": "<p>Run the normalization process for this file.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "ffmpeg_normalize.MediaFile.get_stats": {"fullname": "ffmpeg_normalize.MediaFile.get_stats", "modulename": "ffmpeg_normalize", "qualname": "MediaFile.get_stats", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"n\">ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">_streams</span><span class=\"o\">.</span><span class=\"n\">LoudnessStatisticsWithMetadata</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "ffmpeg_normalize.AudioStream": {"fullname": "ffmpeg_normalize.AudioStream", "modulename": "ffmpeg_normalize", "qualname": "AudioStream", "kind": "class", "doc": "<p></p>\n", "bases": "ffmpeg_normalize._streams.MediaStream"}, "ffmpeg_normalize.AudioStream.__init__": {"fullname": "ffmpeg_normalize.AudioStream.__init__", "modulename": "ffmpeg_normalize", "qualname": "AudioStream.__init__", "kind": "function", "doc": "<p>Create an AudioStream object.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>ffmpeg_normalize (FFmpegNormalize):</strong>  The FFmpegNormalize object.</li>\n<li><strong>media_file (MediaFile):</strong>  The MediaFile object.</li>\n<li><strong>stream_id (int):</strong>  The stream ID.</li>\n<li><strong>sample_rate (int):</strong>  sample rate in Hz</li>\n<li><strong>bit_depth (int):</strong>  bit depth in bits</li>\n<li><strong>duration (float):</strong>  duration in seconds</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">ffmpeg_normalize</span><span class=\"p\">:</span> <span class=\"n\">ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">_ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">FFmpegNormalize</span>,</span><span class=\"param\">\t<span class=\"n\">media_file</span><span class=\"p\">:</span> <span class=\"n\">ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">_media_file</span><span class=\"o\">.</span><span class=\"n\">MediaFile</span>,</span><span class=\"param\">\t<span class=\"n\">stream_id</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">sample_rate</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">bit_depth</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">duration</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span></span>)</span>"}, "ffmpeg_normalize.AudioStream.loudness_statistics": {"fullname": "ffmpeg_normalize.AudioStream.loudness_statistics", "modulename": "ffmpeg_normalize", "qualname": "AudioStream.loudness_statistics", "kind": "variable", "doc": "<p></p>\n", "annotation": ": ffmpeg_normalize._streams.LoudnessStatistics"}, "ffmpeg_normalize.AudioStream.sample_rate": {"fullname": "ffmpeg_normalize.AudioStream.sample_rate", "modulename": "ffmpeg_normalize", "qualname": "AudioStream.sample_rate", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.AudioStream.bit_depth": {"fullname": "ffmpeg_normalize.AudioStream.bit_depth", "modulename": "ffmpeg_normalize", "qualname": "AudioStream.bit_depth", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.AudioStream.duration": {"fullname": "ffmpeg_normalize.AudioStream.duration", "modulename": "ffmpeg_normalize", "qualname": "AudioStream.duration", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.AudioStream.get_stats": {"fullname": "ffmpeg_normalize.AudioStream.get_stats", "modulename": "ffmpeg_normalize", "qualname": "AudioStream.get_stats", "kind": "function", "doc": "<p>Return loudness statistics for the stream.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>dict: A dictionary containing the loudness statistics.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">_streams</span><span class=\"o\">.</span><span class=\"n\">LoudnessStatisticsWithMetadata</span>:</span></span>", "funcdef": "def"}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"fullname": "ffmpeg_normalize.AudioStream.set_second_pass_stats", "modulename": "ffmpeg_normalize", "qualname": "AudioStream.set_second_pass_stats", "kind": "function", "doc": "<p>Set the EBU loudness statistics for the second pass.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>stats (dict):</strong>  The EBU loudness statistics.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">stats</span><span class=\"p\">:</span> <span class=\"n\">ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">_streams</span><span class=\"o\">.</span><span class=\"n\">EbuLoudnessStatistics</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"fullname": "ffmpeg_normalize.AudioStream.get_pcm_codec", "modulename": "ffmpeg_normalize", "qualname": "AudioStream.get_pcm_codec", "kind": "function", "doc": "<p>Get the PCM codec string for the stream.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>str: The PCM codec string.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "ffmpeg_normalize.AudioStream.parse_astats": {"fullname": "ffmpeg_normalize.AudioStream.parse_astats", "modulename": "ffmpeg_normalize", "qualname": "AudioStream.parse_astats", "kind": "function", "doc": "<p>Use ffmpeg with astats filter to get the mean (RMS) and max (peak) volume of the input file.</p>\n\n<h6 id=\"yields\">Yields:</h6>\n\n<blockquote>\n  <p>float: The progress of the command.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"fullname": "ffmpeg_normalize.AudioStream.parse_loudnorm_stats", "modulename": "ffmpeg_normalize", "qualname": "AudioStream.parse_loudnorm_stats", "kind": "function", "doc": "<p>Run a first pass loudnorm filter to get measured data.</p>\n\n<h6 id=\"yields\">Yields:</h6>\n\n<blockquote>\n  <p>float: The progress of the command.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"fullname": "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output", "modulename": "ffmpeg_normalize", "qualname": "AudioStream.prune_and_parse_loudnorm_output", "kind": "function", "doc": "<p>Prune ffmpeg progress lines from output and parse the loudnorm filter output.\nThere may be multiple outputs if multiple streams were processed.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>output (str):</strong>  The output from ffmpeg.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>dict[int, EbuLoudnessStatistics]: The EBU loudness statistics.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">output</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">_streams</span><span class=\"o\">.</span><span class=\"n\">EbuLoudnessStatistics</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"fullname": "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu", "modulename": "ffmpeg_normalize", "qualname": "AudioStream.get_second_pass_opts_ebu", "kind": "function", "doc": "<p>Return second pass loudnorm filter options string for ffmpeg</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"fullname": "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms", "modulename": "ffmpeg_normalize", "qualname": "AudioStream.get_second_pass_opts_peakrms", "kind": "function", "doc": "<p>Set the adjustment gain based on chosen option and mean/max volume,\nreturn the matching ffmpeg volume filter.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>str: ffmpeg volume filter string</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "ffmpeg_normalize.VideoStream": {"fullname": "ffmpeg_normalize.VideoStream", "modulename": "ffmpeg_normalize", "qualname": "VideoStream", "kind": "class", "doc": "<p></p>\n", "bases": "ffmpeg_normalize._streams.MediaStream"}, "ffmpeg_normalize.VideoStream.__init__": {"fullname": "ffmpeg_normalize.VideoStream.__init__", "modulename": "ffmpeg_normalize", "qualname": "VideoStream.__init__", "kind": "function", "doc": "<p>Create a MediaStream object.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>ffmpeg_normalize (FFmpegNormalize):</strong>  The FFmpegNormalize object.</li>\n<li><strong>media_file (MediaFile):</strong>  The MediaFile object.</li>\n<li><strong>stream_type (Literal[\"audio\", \"video\", \"subtitle\"]):</strong>  The type of the stream.</li>\n<li><strong>stream_id (int):</strong>  The stream ID.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">ffmpeg_normalize</span><span class=\"p\">:</span> <span class=\"n\">ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">_ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">FFmpegNormalize</span>,</span><span class=\"param\">\t<span class=\"n\">media_file</span><span class=\"p\">:</span> <span class=\"n\">ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">_media_file</span><span class=\"o\">.</span><span class=\"n\">MediaFile</span>,</span><span class=\"param\">\t<span class=\"n\">stream_id</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span>)</span>"}, "ffmpeg_normalize.SubtitleStream": {"fullname": "ffmpeg_normalize.SubtitleStream", "modulename": "ffmpeg_normalize", "qualname": "SubtitleStream", "kind": "class", "doc": "<p></p>\n", "bases": "ffmpeg_normalize._streams.MediaStream"}, "ffmpeg_normalize.SubtitleStream.__init__": {"fullname": "ffmpeg_normalize.SubtitleStream.__init__", "modulename": "ffmpeg_normalize", "qualname": "SubtitleStream.__init__", "kind": "function", "doc": "<p>Create a MediaStream object.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>ffmpeg_normalize (FFmpegNormalize):</strong>  The FFmpegNormalize object.</li>\n<li><strong>media_file (MediaFile):</strong>  The MediaFile object.</li>\n<li><strong>stream_type (Literal[\"audio\", \"video\", \"subtitle\"]):</strong>  The type of the stream.</li>\n<li><strong>stream_id (int):</strong>  The stream ID.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">ffmpeg_normalize</span><span class=\"p\">:</span> <span class=\"n\">ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">_ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">FFmpegNormalize</span>,</span><span class=\"param\">\t<span class=\"n\">media_file</span><span class=\"p\">:</span> <span class=\"n\">ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">_media_file</span><span class=\"o\">.</span><span class=\"n\">MediaFile</span>,</span><span class=\"param\">\t<span class=\"n\">stream_id</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span>)</span>"}, "ffmpeg_normalize.MediaStream": {"fullname": "ffmpeg_normalize.MediaStream", "modulename": "ffmpeg_normalize", "qualname": "MediaStream", "kind": "class", "doc": "<p></p>\n"}, "ffmpeg_normalize.MediaStream.__init__": {"fullname": "ffmpeg_normalize.MediaStream.__init__", "modulename": "ffmpeg_normalize", "qualname": "MediaStream.__init__", "kind": "function", "doc": "<p>Create a MediaStream object.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>ffmpeg_normalize (FFmpegNormalize):</strong>  The FFmpegNormalize object.</li>\n<li><strong>media_file (MediaFile):</strong>  The MediaFile object.</li>\n<li><strong>stream_type (Literal[\"audio\", \"video\", \"subtitle\"]):</strong>  The type of the stream.</li>\n<li><strong>stream_id (int):</strong>  The stream ID.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">ffmpeg_normalize</span><span class=\"p\">:</span> <span class=\"n\">ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">_ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">FFmpegNormalize</span>,</span><span class=\"param\">\t<span class=\"n\">media_file</span><span class=\"p\">:</span> <span class=\"n\">ffmpeg_normalize</span><span class=\"o\">.</span><span class=\"n\">_media_file</span><span class=\"o\">.</span><span class=\"n\">MediaFile</span>,</span><span class=\"param\">\t<span class=\"n\">stream_type</span><span class=\"p\">:</span> <span class=\"n\">Literal</span><span class=\"p\">[</span><span class=\"s1\">&#39;audio&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;video&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;subtitle&#39;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">stream_id</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span>)</span>"}, "ffmpeg_normalize.MediaStream.ffmpeg_normalize": {"fullname": "ffmpeg_normalize.MediaStream.ffmpeg_normalize", "modulename": "ffmpeg_normalize", "qualname": "MediaStream.ffmpeg_normalize", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.MediaStream.media_file": {"fullname": "ffmpeg_normalize.MediaStream.media_file", "modulename": "ffmpeg_normalize", "qualname": "MediaStream.media_file", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.MediaStream.stream_type": {"fullname": "ffmpeg_normalize.MediaStream.stream_type", "modulename": "ffmpeg_normalize", "qualname": "MediaStream.stream_type", "kind": "variable", "doc": "<p></p>\n"}, "ffmpeg_normalize.MediaStream.stream_id": {"fullname": "ffmpeg_normalize.MediaStream.stream_id", "modulename": "ffmpeg_normalize", "qualname": "MediaStream.stream_id", "kind": "variable", "doc": "<p></p>\n"}}, "docInfo": {"ffmpeg_normalize": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 563}, "ffmpeg_normalize.FFmpegNormalize.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 741, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.ffmpeg_exe": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.normalization_type": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.print_stats": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.loudness_range_target": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"qualname": 7, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.true_peak": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.offset": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.lower_only": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.dual_mono": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.dynamic": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.sample_rate": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.audio_channels": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.audio_codec": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.audio_bitrate": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.keep_original_audio": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.video_codec": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.video_disable": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.subtitle_disable": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.metadata_disable": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.chapters_disable": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.extra_input_options": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.extra_output_options": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.pre_filter": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.post_filter": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.output_format": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.extension": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.dry_run": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.debug": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.progress": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.replaygain": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.stats": {"qualname": 2, "fullname": 4, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.media_files": {"qualname": 3, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.file_count": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 39}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 6}, "ffmpeg_normalize.FFmpegNormalizeError": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 11}, "ffmpeg_normalize.MediaFile": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "ffmpeg_normalize.MediaFile.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 57}, "ffmpeg_normalize.MediaFile.ffmpeg_normalize": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.MediaFile.skip": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.MediaFile.input_file": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.MediaFile.output_file": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.MediaFile.streams": {"qualname": 2, "fullname": 4, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.MediaFile.temp_file": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.MediaFile.parse_streams": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 35}, "ffmpeg_normalize.MediaFile.run_normalization": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 10}, "ffmpeg_normalize.MediaFile.get_stats": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 3}, "ffmpeg_normalize.AudioStream": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 3}, "ffmpeg_normalize.AudioStream.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 119, "bases": 0, "doc": 84}, "ffmpeg_normalize.AudioStream.loudness_statistics": {"qualname": 3, "fullname": 5, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.AudioStream.sample_rate": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.AudioStream.bit_depth": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.AudioStream.duration": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.AudioStream.get_stats": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 26}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 31}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 26}, "ffmpeg_normalize.AudioStream.parse_astats": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 37}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 29}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"qualname": 6, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 60}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"qualname": 6, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 11}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"qualname": 6, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 34}, "ffmpeg_normalize.VideoStream": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 3}, "ffmpeg_normalize.VideoStream.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 66, "bases": 0, "doc": 68}, "ffmpeg_normalize.SubtitleStream": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 3}, "ffmpeg_normalize.SubtitleStream.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 66, "bases": 0, "doc": 68}, "ffmpeg_normalize.MediaStream": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.MediaStream.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 108, "bases": 0, "doc": 68}, "ffmpeg_normalize.MediaStream.ffmpeg_normalize": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.MediaStream.media_file": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.MediaStream.stream_type": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "ffmpeg_normalize.MediaStream.stream_id": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}}, "length": 77, "save": true}, "index": {"qualname": {"root": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 6, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.FFmpegNormalize.ffmpeg_exe": {"tf": 1}, "ffmpeg_normalize.MediaFile.ffmpeg_normalize": {"tf": 1}, "ffmpeg_normalize.MediaStream.ffmpeg_normalize": {"tf": 1}}, "df": 3, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.ffmpeg_exe": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.normalization_type": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.print_stats": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.true_peak": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.offset": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.lower_only": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.dual_mono": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.dynamic": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.sample_rate": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_channels": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_bitrate": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_original_audio": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.video_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.video_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.subtitle_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.metadata_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.chapters_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extra_input_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extra_output_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.pre_filter": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.post_filter": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.output_format": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extension": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.dry_run": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.debug": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.progress": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.replaygain": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.stats": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.file_count": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}}, "df": 40, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize.pre_filter": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.post_filter": {"tf": 1}}, "df": 2}}}, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.file_count": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.input_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.output_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.temp_file": {"tf": 1}, "ffmpeg_normalize.MediaStream.media_file": {"tf": 1}}, "df": 6, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.output_format": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 6}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.extra_input_options": {"tf": 1}, "ffmpeg_normalize.MediaFile.input_file": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {"ffmpeg_normalize.MediaStream.stream_id": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.ffmpeg_exe": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.extra_input_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extra_output_options": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize.extension": {"tf": 1}}, "df": 1}}}}}}}}, "b": {"docs": {}, "df": 0, "u": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"tf": 1}, "ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1}}, "df": 5}}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize.lower_only": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities": {"tf": 1}}, "df": 1}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.audio_channels": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.chapters_disable": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {"ffmpeg_normalize.FFmpegNormalize.audio_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.video_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}}, "df": 3}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.file_count": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize.normalization_type": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {"ffmpeg_normalize.MediaFile.ffmpeg_normalize": {"tf": 1}, "ffmpeg_normalize.MediaStream.ffmpeg_normalize": {"tf": 1}}, "df": 2}}}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.normalization_type": {"tf": 1}, "ffmpeg_normalize.MediaStream.stream_type": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"tf": 1}}, "df": 4}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.true_peak": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {"ffmpeg_normalize.MediaFile.temp_file": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.print_stats": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.pre_filter": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.progress": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {"ffmpeg_normalize.FFmpegNormalize.true_peak": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.post_filter": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 4}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 3}}}, "c": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.print_stats": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.stats": {"tf": 1}, "ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}}, "df": 6}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.MediaStream.stream_type": {"tf": 1}, "ffmpeg_normalize.MediaStream.stream_id": {"tf": 1}}, "df": 2, "s": {"docs": {"ffmpeg_normalize.MediaFile.streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.sample_rate": {"tf": 1}, "ffmpeg_normalize.AudioStream.sample_rate": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.subtitle_disable": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.SubtitleStream": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"ffmpeg_normalize.MediaFile.skip": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 3}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.sample_rate": {"tf": 1}, "ffmpeg_normalize.AudioStream.sample_rate": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize.dry_run": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}}, "df": 3}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize.replaygain": {"tf": 1}}, "df": 1}}}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {"ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_original_audio": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize.audio_channels": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_bitrate": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_original_audio": {"tf": 1}}, "df": 4, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.AudioStream": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1}, "ffmpeg_normalize.AudioStream.sample_rate": {"tf": 1}, "ffmpeg_normalize.AudioStream.bit_depth": {"tf": 1}, "ffmpeg_normalize.AudioStream.duration": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 14}}}}}}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.offset": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"ffmpeg_normalize.FFmpegNormalize.lower_only": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize.keep_original_audio": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.extra_input_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extra_output_options": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.extra_output_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.output_format": {"tf": 1}, "ffmpeg_normalize.MediaFile.output_file": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 4}}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize.dual_mono": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.AudioStream.duration": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"ffmpeg_normalize.FFmpegNormalize.dynamic": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.video_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.subtitle_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.metadata_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.chapters_disable": {"tf": 1}}, "df": 4}}}}}}, "r": {"docs": {}, "df": 0, "y": {"docs": {"ffmpeg_normalize.FFmpegNormalize.dry_run": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.FFmpegNormalize.debug": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"ffmpeg_normalize.AudioStream.bit_depth": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize.dual_mono": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.metadata_disable": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.MediaStream.media_file": {"tf": 1}}, "df": 3, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.MediaFile": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.MediaFile.ffmpeg_normalize": {"tf": 1}, "ffmpeg_normalize.MediaFile.skip": {"tf": 1}, "ffmpeg_normalize.MediaFile.input_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.output_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.temp_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}}, "df": 11}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.MediaStream": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.ffmpeg_normalize": {"tf": 1}, "ffmpeg_normalize.MediaStream.media_file": {"tf": 1}, "ffmpeg_normalize.MediaStream.stream_type": {"tf": 1}, "ffmpeg_normalize.MediaStream.stream_id": {"tf": 1}}, "df": 6}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.AudioStream.bit_depth": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.audio_bitrate": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize.video_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.video_disable": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.VideoStream": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 5}}}}}, "fullname": {"root": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 6, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.ffmpeg_exe": {"tf": 1.4142135623730951}, "ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.normalization_type": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.print_stats": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.true_peak": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.offset": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.lower_only": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.dual_mono": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.dynamic": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.sample_rate": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_channels": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_bitrate": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_original_audio": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.video_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.video_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.subtitle_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.metadata_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.chapters_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extra_input_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extra_output_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.pre_filter": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.post_filter": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.output_format": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extension": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.dry_run": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.debug": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.progress": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.replaygain": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.stats": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.file_count": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}, "ffmpeg_normalize.MediaFile": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.MediaFile.ffmpeg_normalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaFile.skip": {"tf": 1}, "ffmpeg_normalize.MediaFile.input_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.output_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.temp_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1}, "ffmpeg_normalize.AudioStream.sample_rate": {"tf": 1}, "ffmpeg_normalize.AudioStream.bit_depth": {"tf": 1}, "ffmpeg_normalize.AudioStream.duration": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}, "ffmpeg_normalize.VideoStream": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.ffmpeg_normalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaStream.media_file": {"tf": 1}, "ffmpeg_normalize.MediaStream.stream_type": {"tf": 1}, "ffmpeg_normalize.MediaStream.stream_id": {"tf": 1}}, "df": 77, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.ffmpeg_exe": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.normalization_type": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.print_stats": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.true_peak": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.offset": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.lower_only": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.dual_mono": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.dynamic": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.sample_rate": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_channels": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_bitrate": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_original_audio": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.video_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.video_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.subtitle_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.metadata_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.chapters_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extra_input_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extra_output_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.pre_filter": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.post_filter": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.output_format": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extension": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.dry_run": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.debug": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.progress": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.replaygain": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.stats": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.file_count": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}}, "df": 40, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize.pre_filter": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.post_filter": {"tf": 1}}, "df": 2}}}, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.file_count": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.input_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.output_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.temp_file": {"tf": 1}, "ffmpeg_normalize.MediaStream.media_file": {"tf": 1}}, "df": 6, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.output_format": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.ffmpeg_exe": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.normalization_type": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.print_stats": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.true_peak": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.offset": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.lower_only": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.dual_mono": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.dynamic": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.sample_rate": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_channels": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_bitrate": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_original_audio": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.video_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.video_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.subtitle_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.metadata_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.chapters_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extra_input_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extra_output_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.pre_filter": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.post_filter": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.output_format": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extension": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.dry_run": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.debug": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.progress": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.replaygain": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.stats": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.file_count": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}, "ffmpeg_normalize.MediaFile": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.MediaFile.ffmpeg_normalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaFile.skip": {"tf": 1}, "ffmpeg_normalize.MediaFile.input_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.output_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.temp_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1}, "ffmpeg_normalize.AudioStream.sample_rate": {"tf": 1}, "ffmpeg_normalize.AudioStream.bit_depth": {"tf": 1}, "ffmpeg_normalize.AudioStream.duration": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}, "ffmpeg_normalize.VideoStream": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.ffmpeg_normalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaStream.media_file": {"tf": 1}, "ffmpeg_normalize.MediaStream.stream_type": {"tf": 1}, "ffmpeg_normalize.MediaStream.stream_id": {"tf": 1}}, "df": 77}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize.normalization_type": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}}, "df": 3}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 6}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.extra_input_options": {"tf": 1}, "ffmpeg_normalize.MediaFile.input_file": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {"ffmpeg_normalize.MediaStream.stream_id": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.ffmpeg_exe": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.extra_input_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extra_output_options": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize.extension": {"tf": 1}}, "df": 1}}}}}}}}, "b": {"docs": {}, "df": 0, "u": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"tf": 1}, "ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1}}, "df": 5}}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize.lower_only": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities": {"tf": 1}}, "df": 1}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.audio_channels": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.chapters_disable": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {"ffmpeg_normalize.FFmpegNormalize.audio_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.video_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}}, "df": 3}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.file_count": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.normalization_type": {"tf": 1}, "ffmpeg_normalize.MediaStream.stream_type": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"tf": 1}}, "df": 4}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.true_peak": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {"ffmpeg_normalize.MediaFile.temp_file": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.print_stats": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.pre_filter": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.progress": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {"ffmpeg_normalize.FFmpegNormalize.true_peak": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.post_filter": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 4}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 3}}}, "c": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.print_stats": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.stats": {"tf": 1}, "ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}}, "df": 6}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.MediaStream.stream_type": {"tf": 1}, "ffmpeg_normalize.MediaStream.stream_id": {"tf": 1}}, "df": 2, "s": {"docs": {"ffmpeg_normalize.MediaFile.streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.sample_rate": {"tf": 1}, "ffmpeg_normalize.AudioStream.sample_rate": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.subtitle_disable": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.SubtitleStream": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"ffmpeg_normalize.MediaFile.skip": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 3}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.sample_rate": {"tf": 1}, "ffmpeg_normalize.AudioStream.sample_rate": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize.dry_run": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}}, "df": 3}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize.replaygain": {"tf": 1}}, "df": 1}}}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {"ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_original_audio": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize.audio_channels": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.audio_bitrate": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.keep_original_audio": {"tf": 1}}, "df": 4, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.AudioStream": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1}, "ffmpeg_normalize.AudioStream.sample_rate": {"tf": 1}, "ffmpeg_normalize.AudioStream.bit_depth": {"tf": 1}, "ffmpeg_normalize.AudioStream.duration": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 14}}}}}}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.offset": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"ffmpeg_normalize.FFmpegNormalize.lower_only": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize.keep_original_audio": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.extra_input_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.extra_output_options": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.extra_output_options": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.output_format": {"tf": 1}, "ffmpeg_normalize.MediaFile.output_file": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 4}}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize.dual_mono": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.AudioStream.duration": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"ffmpeg_normalize.FFmpegNormalize.dynamic": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.video_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.subtitle_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.metadata_disable": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.chapters_disable": {"tf": 1}}, "df": 4}}}}}}, "r": {"docs": {}, "df": 0, "y": {"docs": {"ffmpeg_normalize.FFmpegNormalize.dry_run": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.FFmpegNormalize.debug": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"ffmpeg_normalize.AudioStream.bit_depth": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize.dual_mono": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.metadata_disable": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.MediaStream.media_file": {"tf": 1}}, "df": 3, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.MediaFile": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.MediaFile.ffmpeg_normalize": {"tf": 1}, "ffmpeg_normalize.MediaFile.skip": {"tf": 1}, "ffmpeg_normalize.MediaFile.input_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.output_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.temp_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}}, "df": 11}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.MediaStream": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.ffmpeg_normalize": {"tf": 1}, "ffmpeg_normalize.MediaStream.media_file": {"tf": 1}, "ffmpeg_normalize.MediaStream.stream_type": {"tf": 1}, "ffmpeg_normalize.MediaStream.stream_id": {"tf": 1}}, "df": 6}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.AudioStream.bit_depth": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.audio_bitrate": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize.video_codec": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.video_disable": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.VideoStream": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 5}}}}}, "annotation": {"root": {"docs": {"ffmpeg_normalize.FFmpegNormalize.stats": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}, "ffmpeg_normalize.MediaFile.streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.temp_file": {"tf": 1}, "ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1}}, "df": 5, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.FFmpegNormalize.stats": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}}, "df": 2}}}}}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1}}, "df": 1, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.stats": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.stats": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}, "ffmpeg_normalize.MediaFile.streams": {"tf": 1}, "ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1}}, "df": 4}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1}}, "df": 2}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.MediaFile.streams": {"tf": 1}}, "df": 1}}}}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}, "ffmpeg_normalize.MediaFile.streams": {"tf": 1}}, "df": 2, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}}, "df": 1}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1}, "ffmpeg_normalize.MediaFile.streams": {"tf": 1}}, "df": 2}}}, "f": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.MediaFile.streams": {"tf": 1}, "ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.MediaFile.temp_file": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "default_value": {"root": {"docs": {}, "df": 0}}, "signature": {"root": {"0": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 2.23606797749979}}, "df": 1}, "2": {"3": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}, "docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}, "3": {"9": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 3.7416573867739413}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 2.449489742783178}}, "df": 2}, "docs": {}, "df": 0}, "7": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}, "docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 23.958297101421877}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 5.291502622129181}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 3.4641016151377544}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 6.324555320336759}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 3.4641016151377544}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 3.4641016151377544}, "ffmpeg_normalize.MediaFile.get_stats": {"tf": 5.196152422706632}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 9.539392014169456}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 4.58257569495584}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 5.385164807134504}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 3.4641016151377544}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 4.123105625617661}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 4.123105625617661}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 6}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 3.4641016151377544}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 3.4641016151377544}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 7}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 7}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 8.888194417315589}}, "df": 19, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {"ffmpeg_normalize.MediaFile.__init__": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 2}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 2}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 2}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 2}}, "df": 9}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 4}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1.7320508075688772}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}}, "df": 7}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 2.23606797749979}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 2}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}}}}}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.4142135623730951}}, "df": 1, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.4142135623730951}}, "df": 1}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.7320508075688772}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 2.449489742783178}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 4}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1.4142135623730951}}, "df": 6}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.MediaFile.__init__": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 2}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 2}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 2}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 2}}, "df": 9, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}, "s": {"1": {"6": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}}, "df": 2}}}, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 2.8284271247461903}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 7, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 4}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 2}}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 12}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 4}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.7320508075688772}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 2}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 4}}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 2}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "y": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1.4142135623730951}}, "df": 4, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 4}}}}}}}}, "k": {"docs": {}, "df": 0, "v": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1.7320508075688772}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 6}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}}, "df": 3}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.MediaFile.get_stats": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}}, "df": 2}}}}}}}, "d": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 4}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 2}}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}}, "df": 1}}}}}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.AudioStream": {"tf": 1}, "ffmpeg_normalize.VideoStream": {"tf": 1}, "ffmpeg_normalize.SubtitleStream": {"tf": 1}}, "df": 3}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.AudioStream": {"tf": 1}, "ffmpeg_normalize.VideoStream": {"tf": 1}, "ffmpeg_normalize.SubtitleStream": {"tf": 1}}, "df": 3}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream": {"tf": 1}, "ffmpeg_normalize.VideoStream": {"tf": 1}, "ffmpeg_normalize.SubtitleStream": {"tf": 1}}, "df": 3}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.AudioStream": {"tf": 1}, "ffmpeg_normalize.VideoStream": {"tf": 1}, "ffmpeg_normalize.SubtitleStream": {"tf": 1}}, "df": 3}}}}}}}}}}}}}, "doc": {"root": {"0": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 2.23606797749979}}, "df": 1}, "2": {"3": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}, "docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}, "7": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}, "docs": {"ffmpeg_normalize": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize": {"tf": 14.594519519326424}, "ffmpeg_normalize.FFmpegNormalize.__init__": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.ffmpeg_exe": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.has_loudnorm_capabilities": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.normalization_type": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.print_stats": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.loudness_range_target": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.keep_loudness_range_target": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.keep_lra_above_loudness_range_target": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.true_peak": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.offset": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.lower_only": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.auto_lower_loudness_target": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.dual_mono": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.dynamic": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.sample_rate": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.audio_channels": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.audio_codec": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.audio_bitrate": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.keep_original_audio": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.video_codec": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.video_disable": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.subtitle_disable": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.metadata_disable": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.chapters_disable": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.extra_input_options": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.extra_output_options": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.pre_filter": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.post_filter": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.output_format": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.extension": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.dry_run": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.debug": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.progress": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.replaygain": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.stats": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.media_files": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.file_count": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 4.242640687119285}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1.4142135623730951}, "ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaFile": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 4.898979485566356}, "ffmpeg_normalize.MediaFile.ffmpeg_normalize": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaFile.skip": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaFile.input_file": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaFile.output_file": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaFile.streams": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaFile.temp_file": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 3.605551275463989}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaFile.get_stats": {"tf": 1.7320508075688772}, "ffmpeg_normalize.AudioStream": {"tf": 1.7320508075688772}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 6.48074069840786}, "ffmpeg_normalize.AudioStream.loudness_statistics": {"tf": 1.7320508075688772}, "ffmpeg_normalize.AudioStream.sample_rate": {"tf": 1.7320508075688772}, "ffmpeg_normalize.AudioStream.bit_depth": {"tf": 1.7320508075688772}, "ffmpeg_normalize.AudioStream.duration": {"tf": 1.7320508075688772}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 3.4641016151377544}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 3.872983346207417}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 3.4641016151377544}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 3.4641016151377544}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 3.4641016151377544}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 4.898979485566356}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 3.3166247903554}, "ffmpeg_normalize.VideoStream": {"tf": 1.7320508075688772}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 5.830951894845301}, "ffmpeg_normalize.SubtitleStream": {"tf": 1.7320508075688772}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 5.830951894845301}, "ffmpeg_normalize.MediaStream": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 5.830951894845301}, "ffmpeg_normalize.MediaStream.ffmpeg_normalize": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaStream.media_file": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaStream.stream_type": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaStream.stream_id": {"tf": 1.7320508075688772}}, "df": 77, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1.4142135623730951}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 10, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1.4142135623730951}}, "df": 5, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 2.23606797749979}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 3.872983346207417}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 2.23606797749979}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1.4142135623730951}}, "df": 6}}}, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 2.23606797749979}, "ffmpeg_normalize.MediaFile": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 2.23606797749979}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 11, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}}, "df": 8, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1.4142135623730951}}, "df": 2}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 7}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}}, "df": 4}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 2}}, "df": 1}, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}}, "df": 1, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 3}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}, "ffmpeg_normalize.MediaFile": {"tf": 1}}, "df": 3}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 2}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1.4142135623730951}}, "df": 2}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}}, "df": 2}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}}, "df": 1}}}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 4}}}}}}, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.MediaFile": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 8, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 9}}}}}}}, "e": {"docs": {"ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}}, "df": 1}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 3}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 5, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}}, "df": 1}, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 1, "s": {"docs": {"ffmpeg_normalize.MediaFile": {"tf": 1}}, "df": 1}}}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}}, "df": 2}}, "n": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1}}, "df": 1, "d": {"docs": {"ffmpeg_normalize.MediaFile": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 5}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 5.656854249492381}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}}, "df": 6}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 3.1622776601683795}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}, "y": {"docs": {"ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}}, "df": 1}}, "h": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1.7320508075688772}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1.7320508075688772}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1.7320508075688772}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 2}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1.7320508075688772}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1.4142135623730951}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 2.23606797749979}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 2.23606797749979}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 2.23606797749979}}, "df": 15, "m": {"docs": {"ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.MediaFile": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}}, "df": 1}}}}, "s": {"1": {"6": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 2.6457513110645907}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 6, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 2}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 2}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 2}}, "df": 6, "s": {"docs": {"ffmpeg_normalize.MediaFile": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1.7320508075688772}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 4}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.get_stats": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 3}}}}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 4, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 3, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.MediaFile.__init__": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}}, "df": 2, "s": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 5.656854249492381}}, "df": 1}}, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 2}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}}, "df": 2}}}}}}, "f": {"docs": {"ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 5, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "n": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 2.449489742783178}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 2}}, "df": 4, "s": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.MediaFile.__init__": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1.7320508075688772}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1.7320508075688772}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1.7320508075688772}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1.7320508075688772}}, "df": 4}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 5.5677643628300215}}, "df": 1}}}}}}, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 2.8284271247461903}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}}, "df": 1}}}}}}, "[": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "y": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}, "o": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 3, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 2}}, "df": 1}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}}, "df": 1}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 3.1622776601683795}, "ffmpeg_normalize.AudioStream.get_stats": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 4}}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.7320508075688772}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 3}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.MediaFile.__init__": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 4}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1.4142135623730951}}, "df": 2}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1.4142135623730951}}, "df": 2}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.MediaFile.__init__": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 2}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.set_second_pass_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}}, "df": 3}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 4}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1.4142135623730951}}, "df": 1, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}}, "s": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalizeError": {"tf": 1}}, "df": 1, "d": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {"ffmpeg_normalize.MediaFile.__init__": {"tf": 1}}, "df": 1}, "e": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 2.6457513110645907}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1.4142135623730951}}, "df": 2}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.FFmpegNormalize.run_normalization": {"tf": 1}, "ffmpeg_normalize.MediaFile.run_normalization": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}}, "df": 4}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.MediaFile.__init__": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_ebu": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 3, "s": {"docs": {"ffmpeg_normalize.AudioStream.get_stats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 4}}}}}}, "m": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}}, "df": 1}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 2.449489742783178}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1.7320508075688772}}, "df": 3, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.7320508075688772}, "ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}}, "df": 5}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1.7320508075688772}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 5, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.MediaFile.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "f": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.MediaFile.parse_streams": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 3}, "s": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.MediaFile": {"tf": 1}}, "df": 1}}, "d": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1.4142135623730951}}, "df": 4}}, "w": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"ffmpeg_normalize.FFmpegNormalize.add_media_file": {"tf": 1}, "ffmpeg_normalize.MediaFile.__init__": {"tf": 1}, "ffmpeg_normalize.AudioStream.__init__": {"tf": 1}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 6, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1.4142135623730951}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 3}}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}}, "df": 1, "/": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}}, "df": 1}}}}}}}, "k": {"docs": {}, "df": 0, "v": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "x": {"docs": {"ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}}, "df": 1}, "y": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.AudioStream.prune_and_parse_loudnorm_output": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 2}, "ffmpeg_normalize.VideoStream.__init__": {"tf": 1}, "ffmpeg_normalize.SubtitleStream.__init__": {"tf": 1}, "ffmpeg_normalize.MediaStream.__init__": {"tf": 1}}, "df": 4}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1.7320508075688772}}, "df": 2}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"ffmpeg_normalize.FFmpegNormalize": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}}, "df": 2}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.MediaFile": {"tf": 1}}, "df": 1}}}}, "z": {"docs": {"ffmpeg_normalize.AudioStream.__init__": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"ffmpeg_normalize.AudioStream.get_pcm_codec": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}}, "df": 3}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"ffmpeg_normalize.AudioStream.get_second_pass_opts_peakrms": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"ffmpeg_normalize.AudioStream.parse_astats": {"tf": 1}, "ffmpeg_normalize.AudioStream.parse_loudnorm_stats": {"tf": 1}}, "df": 2}}}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();