/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.Tools;

import deadbeef.Tools.FileBufferException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileBuffer {
    private static final int BUFFERSIZE = 0x100000;
    private final byte[] buf;
    private final String fileName;
    private final FileInputStream fi;
    private final FileChannel fc;
    private long offset;
    private long offset_end;
    private final long len;

    public FileBuffer(String fname) throws FileBufferException {
        try {
            this.fileName = fname;
            this.len = new File(fname).length();
            this.buf = this.len < 0x100000L ? new byte[(int)this.len] : new byte[0x100000];
            this.fi = new FileInputStream(fname);
            this.fc = this.fi.getChannel();
            this.offset = 0L;
            this.readBuffer(this.offset);
        }
        catch (FileNotFoundException ex) {
            throw new FileBufferException("File '" + fname + "' not found");
        }
    }

    private void readBuffer(long ofs) throws FileBufferException {
        try {
            this.offset = ofs;
            this.fc.position(this.offset);
            long l = this.len - this.offset;
            if (l < 0L) {
                throw new FileBufferException("Offset " + ofs + " out of bounds for file " + this.fileName);
            }
            int numRead = l < (long)this.buf.length ? this.fi.read(this.buf, 0, (int)l) : this.fi.read(this.buf, 0, this.buf.length);
            this.offset_end = this.offset + (long)numRead - 1L;
        }
        catch (IOException ex) {
            throw new FileBufferException("IO error at offset +" + ofs + " of file '" + this.fileName + "'");
        }
        catch (IllegalArgumentException ex) {
            throw new FileBufferException("IO error at offset +" + ofs + " of file '" + this.fileName + "'");
        }
    }

    public int getByte(long ofs) throws FileBufferException {
        if (ofs < this.offset || ofs > this.offset_end) {
            this.readBuffer(ofs);
        }
        return this.buf[(int)(ofs - this.offset)] & 0xFF;
    }

    public int getWord(long ofs) throws FileBufferException {
        if (ofs < this.offset || ofs + 1L > this.offset_end) {
            this.readBuffer(ofs);
        }
        int idx = (int)(ofs - this.offset);
        return this.buf[idx + 1] & 0xFF | (this.buf[idx] & 0xFF) << 8;
    }

    public int getWordLE(long ofs) throws FileBufferException {
        if (ofs < this.offset || ofs + 1L > this.offset_end) {
            this.readBuffer(ofs);
        }
        int idx = (int)(ofs - this.offset);
        return this.buf[idx] & 0xFF | (this.buf[idx + 1] & 0xFF) << 8;
    }

    public int getDWord(long ofs) throws FileBufferException {
        if (ofs < this.offset || ofs + 3L > this.offset_end) {
            this.readBuffer(ofs);
        }
        int idx = (int)(ofs - this.offset);
        return this.buf[idx + 3] & 0xFF | (this.buf[idx + 2] & 0xFF) << 8 | (this.buf[idx + 1] & 0xFF) << 16 | (this.buf[idx] & 0xFF) << 24;
    }

    public int getDWordLE(long ofs) throws FileBufferException {
        if (ofs < this.offset || ofs + 3L > this.offset_end) {
            this.readBuffer(ofs);
        }
        int idx = (int)(ofs - this.offset);
        return this.buf[idx] & 0xFF | (this.buf[idx + 1] & 0xFF) << 8 | (this.buf[idx + 2] & 0xFF) << 16 | (this.buf[idx + 3] & 0xFF) << 24;
    }

    public void getBytes(long ofs, byte[] b, int len) throws FileBufferException {
        if (ofs < this.offset || ofs + (long)len - 1L > this.offset_end) {
            this.readBuffer(ofs);
        }
        int i = 0;
        while (i < len) {
            b[i] = this.buf[(int)(ofs - this.offset + (long)i)];
            ++i;
        }
    }

    public long getSize() {
        return this.len;
    }

    public void close() {
        try {
            if (this.fc != null) {
                this.fc.close();
            }
            if (this.fi != null) {
                this.fi.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void finalize() throws Throwable {
        if (this.fc != null) {
            this.fc.close();
        }
        if (this.fi != null) {
            this.fi.close();
        }
        super.finalize();
    }
}

