/// \file
/// \ingroup tutorial_tree
/// \notebook -nodraw
/// Example of Root macro to copy a subset of a Tree to a new Tree, selecting entries.
///
/// Only selected entries are copied to the new Tree.
/// The input file has been generated by the program in `$ROOTSYS/test/Event`
/// with `Event 1000 1 99 1`
///
/// \macro_code
///
/// \author Rene Brun

#ifdef ACTUAL_RUN  // -------- Second pass: dictionary already built --------

#include "./Event.h"  // now safe to include Event, its dictionary is loaded

void run()
{
   TFile oldfile("tree108.root");
   TTree *oldtree;
   oldfile.GetObject("t4", oldtree);

   const auto nentries = oldtree->GetEntries();

   Event *event = nullptr;
   oldtree->SetBranchAddress("event_split", &event);

   // Create a new file + a clone of old tree in new file
   TFile newfile("tree112.root", "recreate");
   auto newtree = oldtree->CloneTree(0);

   for (auto i : ROOT::TSeqI(nentries)) {
      oldtree->GetEntry(i);
      if (event->GetNtrack() > 605)
         newtree->Fill();
      event->Clear();
   }

   newtree->Print();
   newfile.Write();
}

#else  // -------- First pass: build dictionary + rerun macro --------

void tree112_copy()
{
   TString tutdir = gROOT->GetTutorialDir();
   gROOT->ProcessLine(".L " + tutdir + "/io/tree/Event.cxx+");
   gROOT->ProcessLine("#define ACTUAL_RUN yes");
   gROOT->ProcessLine("#include \"" __FILE__ "\"");
   gROOT->ProcessLine("run()");
}

#endif
