from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

SERBIAN_LANG_MODEL = {
    57: {  # 'Ђ'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.NEGATIVE,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.NEGATIVE,  # 'Г'
        38: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.NEGATIVE,  # 'К'
        48: SequenceLikelihood.NEGATIVE,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.NEGATIVE,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.NEGATIVE,  # 'П'
        43: SequenceLikelihood.NEGATIVE,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.NEGATIVE,  # 'б'
        11: SequenceLikelihood.NEGATIVE,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        12: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.NEGATIVE,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.NEGATIVE,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        7: SequenceLikelihood.NEGATIVE,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        25: SequenceLikelihood.NEGATIVE,  # 'х'
        21: SequenceLikelihood.NEGATIVE,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.NEGATIVE,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    46: {  # 'Ј'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.LIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.NEGATIVE,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.NEGATIVE,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    58: {  # 'Љ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.NEGATIVE,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.NEGATIVE,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.NEGATIVE,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.NEGATIVE,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.NEGATIVE,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        12: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        10: SequenceLikelihood.NEGATIVE,  # 'к'
        15: SequenceLikelihood.NEGATIVE,  # 'л'
        13: SequenceLikelihood.NEGATIVE,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.NEGATIVE,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.NEGATIVE,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.NEGATIVE,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    56: {  # 'Њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.NEGATIVE,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.NEGATIVE,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.NEGATIVE,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.NEGATIVE,  # 'М'
        32: SequenceLikelihood.NEGATIVE,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.NEGATIVE,  # 'П'
        43: SequenceLikelihood.NEGATIVE,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.NEGATIVE,  # 'б'
        11: SequenceLikelihood.NEGATIVE,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.NEGATIVE,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.NEGATIVE,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.NEGATIVE,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        7: SequenceLikelihood.NEGATIVE,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.NEGATIVE,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    59: {  # 'Ћ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.NEGATIVE,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.NEGATIVE,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.NEGATIVE,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.NEGATIVE,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        12: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.NEGATIVE,  # 'л'
        13: SequenceLikelihood.NEGATIVE,  # 'м'
        5: SequenceLikelihood.NEGATIVE,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.NEGATIVE,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        7: SequenceLikelihood.NEGATIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        25: SequenceLikelihood.NEGATIVE,  # 'х'
        21: SequenceLikelihood.NEGATIVE,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.NEGATIVE,  # 'ј'
        27: SequenceLikelihood.NEGATIVE,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    60: {  # 'Џ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.NEGATIVE,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.NEGATIVE,  # 'Г'
        38: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.NEGATIVE,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.NEGATIVE,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.NEGATIVE,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        10: SequenceLikelihood.NEGATIVE,  # 'к'
        15: SequenceLikelihood.NEGATIVE,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        7: SequenceLikelihood.NEGATIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        25: SequenceLikelihood.NEGATIVE,  # 'х'
        21: SequenceLikelihood.NEGATIVE,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.NEGATIVE,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    31: {  # 'А'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.LIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.LIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.LIKELY,  # 'Б'
        41: SequenceLikelihood.LIKELY,  # 'В'
        47: SequenceLikelihood.LIKELY,  # 'Г'
        38: SequenceLikelihood.POSITIVE,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.LIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.LIKELY,  # 'К'
        48: SequenceLikelihood.LIKELY,  # 'Л'
        36: SequenceLikelihood.LIKELY,  # 'М'
        32: SequenceLikelihood.POSITIVE,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.LIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.POSITIVE,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.LIKELY,  # 'Ц'
        53: SequenceLikelihood.LIKELY,  # 'Ч'
        52: SequenceLikelihood.LIKELY,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.LIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        7: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.LIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    40: {  # 'Б'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.LIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    41: {  # 'В'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.LIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.POSITIVE,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.LIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.LIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    47: {  # 'Г'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.LIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    38: {  # 'Д'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.LIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.LIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.LIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    44: {  # 'Е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.LIKELY,  # 'Њ'
        59: SequenceLikelihood.LIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.LIKELY,  # 'Б'
        41: SequenceLikelihood.LIKELY,  # 'В'
        47: SequenceLikelihood.LIKELY,  # 'Г'
        38: SequenceLikelihood.LIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.LIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.LIKELY,  # 'К'
        48: SequenceLikelihood.LIKELY,  # 'Л'
        36: SequenceLikelihood.LIKELY,  # 'М'
        32: SequenceLikelihood.LIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.LIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        42: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.LIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.LIKELY,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        10: SequenceLikelihood.LIKELY,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        7: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    55: {  # 'Ж'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.NEGATIVE,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.NEGATIVE,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.NEGATIVE,  # 'с'
        7: SequenceLikelihood.NEGATIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.NEGATIVE,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    45: {  # 'З'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.LIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.LIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.NEGATIVE,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.NEGATIVE,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.NEGATIVE,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    37: {  # 'И'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.POSITIVE,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.LIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.LIKELY,  # 'В'
        47: SequenceLikelihood.LIKELY,  # 'Г'
        38: SequenceLikelihood.LIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.LIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.LIKELY,  # 'К'
        48: SequenceLikelihood.LIKELY,  # 'Л'
        36: SequenceLikelihood.LIKELY,  # 'М'
        32: SequenceLikelihood.LIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.LIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.LIKELY,  # 'Х'
        49: SequenceLikelihood.LIKELY,  # 'Ц'
        53: SequenceLikelihood.LIKELY,  # 'Ч'
        52: SequenceLikelihood.LIKELY,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    35: {  # 'К'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.LIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.POSITIVE,  # 'О'
        29: SequenceLikelihood.LIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.POSITIVE,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        42: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.LIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.LIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    48: {  # 'Л'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.LIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.NEGATIVE,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    36: {  # 'М'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.LIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.LIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.LIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    32: {  # 'Н'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.POSITIVE,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.LIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.POSITIVE,  # 'И'
        35: SequenceLikelihood.LIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        42: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.LIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.NEGATIVE,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    34: {  # 'О'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.LIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.LIKELY,  # 'Б'
        41: SequenceLikelihood.POSITIVE,  # 'В'
        47: SequenceLikelihood.LIKELY,  # 'Г'
        38: SequenceLikelihood.LIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.LIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.LIKELY,  # 'К'
        48: SequenceLikelihood.LIKELY,  # 'Л'
        36: SequenceLikelihood.LIKELY,  # 'М'
        32: SequenceLikelihood.LIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.LIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.LIKELY,  # 'Ч'
        52: SequenceLikelihood.LIKELY,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        10: SequenceLikelihood.LIKELY,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.LIKELY,  # 'ц'
        20: SequenceLikelihood.LIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    29: {  # 'П'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.LIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.LIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.LIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.LIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.LIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    43: {  # 'Р'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.POSITIVE,  # 'А'
        40: SequenceLikelihood.LIKELY,  # 'Б'
        41: SequenceLikelihood.LIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.POSITIVE,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.LIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.LIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.LIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        42: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.NEGATIVE,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    28: {  # 'С'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.POSITIVE,  # 'А'
        40: SequenceLikelihood.LIKELY,  # 'Б'
        41: SequenceLikelihood.LIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.LIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.LIKELY,  # 'К'
        48: SequenceLikelihood.LIKELY,  # 'Л'
        36: SequenceLikelihood.LIKELY,  # 'М'
        32: SequenceLikelihood.LIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.LIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.POSITIVE,  # 'Т'
        42: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.LIKELY,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.LIKELY,  # 'х'
        21: SequenceLikelihood.LIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.LIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    39: {  # 'Т'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.LIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.POSITIVE,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.LIKELY,  # 'Н'
        34: SequenceLikelihood.POSITIVE,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.LIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    42: {  # 'У'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.LIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.LIKELY,  # 'Г'
        38: SequenceLikelihood.LIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.LIKELY,  # 'К'
        48: SequenceLikelihood.LIKELY,  # 'Л'
        36: SequenceLikelihood.LIKELY,  # 'М'
        32: SequenceLikelihood.LIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.LIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.LIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.LIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.UNLIKELY,  # 'а'
        19: SequenceLikelihood.LIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.UNLIKELY,  # 'е'
        26: SequenceLikelihood.LIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.UNLIKELY,  # 'и'
        10: SequenceLikelihood.LIKELY,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        7: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.LIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.LIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    51: {  # 'Ф'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.LIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    50: {  # 'Х'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    49: {  # 'Ц'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.LIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.LIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.NEGATIVE,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    53: {  # 'Ч'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.LIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.NEGATIVE,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        12: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.NEGATIVE,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.NEGATIVE,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.NEGATIVE,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.NEGATIVE,  # 'ј'
        27: SequenceLikelihood.NEGATIVE,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.NEGATIVE,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    52: {  # 'Ш'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.LIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.LIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.LIKELY,  # 'И'
        35: SequenceLikelihood.LIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.LIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        12: SequenceLikelihood.NEGATIVE,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.NEGATIVE,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.LIKELY,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    1: {  # 'а'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.POSITIVE,  # 'ф'
        25: SequenceLikelihood.POSITIVE,  # 'х'
        21: SequenceLikelihood.POSITIVE,  # 'ц'
        20: SequenceLikelihood.POSITIVE,  # 'ч'
        22: SequenceLikelihood.POSITIVE,  # 'ш'
        33: SequenceLikelihood.POSITIVE,  # 'ђ'
        14: SequenceLikelihood.POSITIVE,  # 'ј'
        27: SequenceLikelihood.POSITIVE,  # 'љ'
        23: SequenceLikelihood.POSITIVE,  # 'њ'
        24: SequenceLikelihood.POSITIVE,  # 'ћ'
        54: SequenceLikelihood.LIKELY,  # 'џ'
    },
    19: {  # 'б'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.NEGATIVE,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.POSITIVE,  # 'ј'
        27: SequenceLikelihood.POSITIVE,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    11: {  # 'в'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.POSITIVE,  # 'ц'
        20: SequenceLikelihood.LIKELY,  # 'ч'
        22: SequenceLikelihood.POSITIVE,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.POSITIVE,  # 'ј'
        27: SequenceLikelihood.POSITIVE,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    18: {  # 'г'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        7: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.LIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.LIKELY,  # 'љ'
        23: SequenceLikelihood.LIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    12: {  # 'д'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.LIKELY,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.LIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.POSITIVE,  # 'ј'
        27: SequenceLikelihood.LIKELY,  # 'љ'
        23: SequenceLikelihood.POSITIVE,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    4: {  # 'е'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.POSITIVE,  # 'ф'
        25: SequenceLikelihood.POSITIVE,  # 'х'
        21: SequenceLikelihood.POSITIVE,  # 'ц'
        20: SequenceLikelihood.POSITIVE,  # 'ч'
        22: SequenceLikelihood.POSITIVE,  # 'ш'
        33: SequenceLikelihood.POSITIVE,  # 'ђ'
        14: SequenceLikelihood.POSITIVE,  # 'ј'
        27: SequenceLikelihood.POSITIVE,  # 'љ'
        23: SequenceLikelihood.POSITIVE,  # 'њ'
        24: SequenceLikelihood.POSITIVE,  # 'ћ'
        54: SequenceLikelihood.LIKELY,  # 'џ'
    },
    26: {  # 'ж'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.NEGATIVE,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.NEGATIVE,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.NEGATIVE,  # 'Л'
        36: SequenceLikelihood.NEGATIVE,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.NEGATIVE,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        42: SequenceLikelihood.NEGATIVE,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.LIKELY,  # 'ђ'
        14: SequenceLikelihood.LIKELY,  # 'ј'
        27: SequenceLikelihood.LIKELY,  # 'љ'
        23: SequenceLikelihood.POSITIVE,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    17: {  # 'з'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.NEGATIVE,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.POSITIVE,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    2: {  # 'и'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.LIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.LIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.LIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.POSITIVE,  # 'ф'
        25: SequenceLikelihood.POSITIVE,  # 'х'
        21: SequenceLikelihood.POSITIVE,  # 'ц'
        20: SequenceLikelihood.POSITIVE,  # 'ч'
        22: SequenceLikelihood.POSITIVE,  # 'ш'
        33: SequenceLikelihood.LIKELY,  # 'ђ'
        14: SequenceLikelihood.POSITIVE,  # 'ј'
        27: SequenceLikelihood.POSITIVE,  # 'љ'
        23: SequenceLikelihood.POSITIVE,  # 'њ'
        24: SequenceLikelihood.POSITIVE,  # 'ћ'
        54: SequenceLikelihood.LIKELY,  # 'џ'
    },
    10: {  # 'к'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.POSITIVE,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.LIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.POSITIVE,  # 'љ'
        23: SequenceLikelihood.POSITIVE,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    15: {  # 'л'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.LIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    13: {  # 'м'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.LIKELY,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.LIKELY,  # 'ц'
        20: SequenceLikelihood.LIKELY,  # 'ч'
        22: SequenceLikelihood.LIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.POSITIVE,  # 'ј'
        27: SequenceLikelihood.POSITIVE,  # 'љ'
        23: SequenceLikelihood.LIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    5: {  # 'н'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.LIKELY,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.LIKELY,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.POSITIVE,  # 'ф'
        25: SequenceLikelihood.LIKELY,  # 'х'
        21: SequenceLikelihood.POSITIVE,  # 'ц'
        20: SequenceLikelihood.POSITIVE,  # 'ч'
        22: SequenceLikelihood.LIKELY,  # 'ш'
        33: SequenceLikelihood.LIKELY,  # 'ђ'
        14: SequenceLikelihood.LIKELY,  # 'ј'
        27: SequenceLikelihood.LIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.LIKELY,  # 'џ'
    },
    3: {  # 'о'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.POSITIVE,  # 'ф'
        25: SequenceLikelihood.POSITIVE,  # 'х'
        21: SequenceLikelihood.POSITIVE,  # 'ц'
        20: SequenceLikelihood.POSITIVE,  # 'ч'
        22: SequenceLikelihood.POSITIVE,  # 'ш'
        33: SequenceLikelihood.POSITIVE,  # 'ђ'
        14: SequenceLikelihood.POSITIVE,  # 'ј'
        27: SequenceLikelihood.POSITIVE,  # 'љ'
        23: SequenceLikelihood.POSITIVE,  # 'њ'
        24: SequenceLikelihood.POSITIVE,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    16: {  # 'п'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.LIKELY,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.POSITIVE,  # 'х'
        21: SequenceLikelihood.POSITIVE,  # 'ц'
        20: SequenceLikelihood.LIKELY,  # 'ч'
        22: SequenceLikelihood.POSITIVE,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.LIKELY,  # 'ј'
        27: SequenceLikelihood.POSITIVE,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    6: {  # 'р'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        25: SequenceLikelihood.POSITIVE,  # 'х'
        21: SequenceLikelihood.POSITIVE,  # 'ц'
        20: SequenceLikelihood.POSITIVE,  # 'ч'
        22: SequenceLikelihood.POSITIVE,  # 'ш'
        33: SequenceLikelihood.POSITIVE,  # 'ђ'
        14: SequenceLikelihood.LIKELY,  # 'ј'
        27: SequenceLikelihood.LIKELY,  # 'љ'
        23: SequenceLikelihood.LIKELY,  # 'њ'
        24: SequenceLikelihood.LIKELY,  # 'ћ'
        54: SequenceLikelihood.LIKELY,  # 'џ'
    },
    8: {  # 'с'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.LIKELY,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        25: SequenceLikelihood.POSITIVE,  # 'х'
        21: SequenceLikelihood.POSITIVE,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.POSITIVE,  # 'ј'
        27: SequenceLikelihood.LIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    7: {  # 'т'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.UNLIKELY,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.LIKELY,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        25: SequenceLikelihood.POSITIVE,  # 'х'
        21: SequenceLikelihood.LIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.LIKELY,  # 'ј'
        27: SequenceLikelihood.POSITIVE,  # 'љ'
        23: SequenceLikelihood.LIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    9: {  # 'у'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.POSITIVE,  # 'г'
        12: SequenceLikelihood.POSITIVE,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.POSITIVE,  # 'ж'
        17: SequenceLikelihood.POSITIVE,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.POSITIVE,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        25: SequenceLikelihood.POSITIVE,  # 'х'
        21: SequenceLikelihood.POSITIVE,  # 'ц'
        20: SequenceLikelihood.POSITIVE,  # 'ч'
        22: SequenceLikelihood.POSITIVE,  # 'ш'
        33: SequenceLikelihood.POSITIVE,  # 'ђ'
        14: SequenceLikelihood.POSITIVE,  # 'ј'
        27: SequenceLikelihood.POSITIVE,  # 'љ'
        23: SequenceLikelihood.LIKELY,  # 'њ'
        24: SequenceLikelihood.POSITIVE,  # 'ћ'
        54: SequenceLikelihood.LIKELY,  # 'џ'
    },
    30: {  # 'ф'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.NEGATIVE,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        7: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.NEGATIVE,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    25: {  # 'х'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    21: {  # 'ц'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.POSITIVE,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.LIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.LIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.LIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    20: {  # 'ч'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.NEGATIVE,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.NEGATIVE,  # 'О'
        29: SequenceLikelihood.NEGATIVE,  # 'П'
        43: SequenceLikelihood.NEGATIVE,  # 'Р'
        28: SequenceLikelihood.NEGATIVE,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.POSITIVE,  # 'ј'
        27: SequenceLikelihood.LIKELY,  # 'љ'
        23: SequenceLikelihood.LIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    22: {  # 'ш'
        57: SequenceLikelihood.UNLIKELY,  # 'Ђ'
        46: SequenceLikelihood.NEGATIVE,  # 'Ј'
        58: SequenceLikelihood.UNLIKELY,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.NEGATIVE,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.NEGATIVE,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.NEGATIVE,  # 'Л'
        36: SequenceLikelihood.NEGATIVE,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.NEGATIVE,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.NEGATIVE,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.LIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.POSITIVE,  # 'л'
        13: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.LIKELY,  # 'ц'
        20: SequenceLikelihood.LIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.POSITIVE,  # 'љ'
        23: SequenceLikelihood.POSITIVE,  # 'њ'
        24: SequenceLikelihood.POSITIVE,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    33: {  # 'ђ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.NEGATIVE,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.NEGATIVE,  # 'Б'
        41: SequenceLikelihood.NEGATIVE,  # 'В'
        47: SequenceLikelihood.NEGATIVE,  # 'Г'
        38: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.NEGATIVE,  # 'И'
        35: SequenceLikelihood.NEGATIVE,  # 'К'
        48: SequenceLikelihood.NEGATIVE,  # 'Л'
        36: SequenceLikelihood.NEGATIVE,  # 'М'
        32: SequenceLikelihood.NEGATIVE,  # 'Н'
        34: SequenceLikelihood.NEGATIVE,  # 'О'
        29: SequenceLikelihood.NEGATIVE,  # 'П'
        43: SequenceLikelihood.NEGATIVE,  # 'Р'
        28: SequenceLikelihood.NEGATIVE,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        42: SequenceLikelihood.NEGATIVE,  # 'У'
        51: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.NEGATIVE,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    14: {  # 'ј'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.NEGATIVE,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.POSITIVE,  # 'б'
        11: SequenceLikelihood.POSITIVE,  # 'в'
        18: SequenceLikelihood.LIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.LIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.LIKELY,  # 'л'
        13: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.LIKELY,  # 'п'
        6: SequenceLikelihood.LIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.POSITIVE,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.LIKELY,  # 'ц'
        20: SequenceLikelihood.POSITIVE,  # 'ч'
        22: SequenceLikelihood.LIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.LIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.LIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.LIKELY,  # 'џ'
    },
    27: {  # 'љ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.NEGATIVE,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.NEGATIVE,  # 'А'
        40: SequenceLikelihood.NEGATIVE,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.NEGATIVE,  # 'Г'
        38: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.NEGATIVE,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.NEGATIVE,  # 'Л'
        36: SequenceLikelihood.NEGATIVE,  # 'М'
        32: SequenceLikelihood.NEGATIVE,  # 'Н'
        34: SequenceLikelihood.NEGATIVE,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.NEGATIVE,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.NEGATIVE,  # 'У'
        51: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.LIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.POSITIVE,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.POSITIVE,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.LIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.LIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
    23: {  # 'њ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.NEGATIVE,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.NEGATIVE,  # 'Б'
        41: SequenceLikelihood.NEGATIVE,  # 'В'
        47: SequenceLikelihood.NEGATIVE,  # 'Г'
        38: SequenceLikelihood.NEGATIVE,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.NEGATIVE,  # 'К'
        48: SequenceLikelihood.NEGATIVE,  # 'Л'
        36: SequenceLikelihood.NEGATIVE,  # 'М'
        32: SequenceLikelihood.NEGATIVE,  # 'Н'
        34: SequenceLikelihood.NEGATIVE,  # 'О'
        29: SequenceLikelihood.NEGATIVE,  # 'П'
        43: SequenceLikelihood.NEGATIVE,  # 'Р'
        28: SequenceLikelihood.NEGATIVE,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.POSITIVE,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.LIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    24: {  # 'ћ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.UNLIKELY,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.UNLIKELY,  # 'Џ'
        31: SequenceLikelihood.UNLIKELY,  # 'А'
        40: SequenceLikelihood.UNLIKELY,  # 'Б'
        41: SequenceLikelihood.UNLIKELY,  # 'В'
        47: SequenceLikelihood.UNLIKELY,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.UNLIKELY,  # 'Ж'
        45: SequenceLikelihood.UNLIKELY,  # 'З'
        37: SequenceLikelihood.UNLIKELY,  # 'И'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        48: SequenceLikelihood.UNLIKELY,  # 'Л'
        36: SequenceLikelihood.UNLIKELY,  # 'М'
        32: SequenceLikelihood.UNLIKELY,  # 'Н'
        34: SequenceLikelihood.UNLIKELY,  # 'О'
        29: SequenceLikelihood.UNLIKELY,  # 'П'
        43: SequenceLikelihood.UNLIKELY,  # 'Р'
        28: SequenceLikelihood.UNLIKELY,  # 'С'
        39: SequenceLikelihood.UNLIKELY,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        50: SequenceLikelihood.UNLIKELY,  # 'Х'
        49: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        52: SequenceLikelihood.UNLIKELY,  # 'Ш'
        1: SequenceLikelihood.POSITIVE,  # 'а'
        19: SequenceLikelihood.UNLIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.POSITIVE,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.UNLIKELY,  # 'з'
        2: SequenceLikelihood.POSITIVE,  # 'и'
        10: SequenceLikelihood.LIKELY,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        3: SequenceLikelihood.LIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.UNLIKELY,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.UNLIKELY,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.UNLIKELY,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.NEGATIVE,  # 'џ'
    },
    54: {  # 'џ'
        57: SequenceLikelihood.NEGATIVE,  # 'Ђ'
        46: SequenceLikelihood.NEGATIVE,  # 'Ј'
        58: SequenceLikelihood.NEGATIVE,  # 'Љ'
        56: SequenceLikelihood.NEGATIVE,  # 'Њ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ћ'
        60: SequenceLikelihood.NEGATIVE,  # 'Џ'
        31: SequenceLikelihood.NEGATIVE,  # 'А'
        40: SequenceLikelihood.NEGATIVE,  # 'Б'
        41: SequenceLikelihood.NEGATIVE,  # 'В'
        47: SequenceLikelihood.NEGATIVE,  # 'Г'
        38: SequenceLikelihood.UNLIKELY,  # 'Д'
        44: SequenceLikelihood.UNLIKELY,  # 'Е'
        55: SequenceLikelihood.NEGATIVE,  # 'Ж'
        45: SequenceLikelihood.NEGATIVE,  # 'З'
        37: SequenceLikelihood.NEGATIVE,  # 'И'
        35: SequenceLikelihood.NEGATIVE,  # 'К'
        48: SequenceLikelihood.NEGATIVE,  # 'Л'
        36: SequenceLikelihood.NEGATIVE,  # 'М'
        32: SequenceLikelihood.NEGATIVE,  # 'Н'
        34: SequenceLikelihood.NEGATIVE,  # 'О'
        29: SequenceLikelihood.NEGATIVE,  # 'П'
        43: SequenceLikelihood.NEGATIVE,  # 'Р'
        28: SequenceLikelihood.NEGATIVE,  # 'С'
        39: SequenceLikelihood.NEGATIVE,  # 'Т'
        42: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.NEGATIVE,  # 'Ф'
        50: SequenceLikelihood.NEGATIVE,  # 'Х'
        49: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        52: SequenceLikelihood.NEGATIVE,  # 'Ш'
        1: SequenceLikelihood.LIKELY,  # 'а'
        19: SequenceLikelihood.LIKELY,  # 'б'
        11: SequenceLikelihood.UNLIKELY,  # 'в'
        18: SequenceLikelihood.UNLIKELY,  # 'г'
        12: SequenceLikelihood.UNLIKELY,  # 'д'
        4: SequenceLikelihood.LIKELY,  # 'е'
        26: SequenceLikelihood.UNLIKELY,  # 'ж'
        17: SequenceLikelihood.NEGATIVE,  # 'з'
        2: SequenceLikelihood.LIKELY,  # 'и'
        10: SequenceLikelihood.UNLIKELY,  # 'к'
        15: SequenceLikelihood.UNLIKELY,  # 'л'
        13: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        3: SequenceLikelihood.UNLIKELY,  # 'о'
        16: SequenceLikelihood.UNLIKELY,  # 'п'
        6: SequenceLikelihood.UNLIKELY,  # 'р'
        8: SequenceLikelihood.UNLIKELY,  # 'с'
        7: SequenceLikelihood.UNLIKELY,  # 'т'
        9: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        25: SequenceLikelihood.UNLIKELY,  # 'х'
        21: SequenceLikelihood.UNLIKELY,  # 'ц'
        20: SequenceLikelihood.NEGATIVE,  # 'ч'
        22: SequenceLikelihood.UNLIKELY,  # 'ш'
        33: SequenceLikelihood.NEGATIVE,  # 'ђ'
        14: SequenceLikelihood.UNLIKELY,  # 'ј'
        27: SequenceLikelihood.NEGATIVE,  # 'љ'
        23: SequenceLikelihood.UNLIKELY,  # 'њ'
        24: SequenceLikelihood.UNLIKELY,  # 'ћ'
        54: SequenceLikelihood.UNLIKELY,  # 'џ'
    },
}

# Character Mapping Table(s):
CP855_SERBIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 33,  # 'ђ'
    129: 57,  # 'Ђ'
    130: 0,  # 'ѓ'
    131: 0,  # 'Ѓ'
    132: 0,  # 'ё'
    133: 0,  # 'Ё'
    134: 0,  # 'є'
    135: 0,  # 'Є'
    136: 0,  # 'ѕ'
    137: 0,  # 'Ѕ'
    138: 0,  # 'і'
    139: 0,  # 'І'
    140: 0,  # 'ї'
    141: 0,  # 'Ї'
    142: 14,  # 'ј'
    143: 46,  # 'Ј'
    144: 27,  # 'љ'
    145: 58,  # 'Љ'
    146: 23,  # 'њ'
    147: 56,  # 'Њ'
    148: 24,  # 'ћ'
    149: 59,  # 'Ћ'
    150: 0,  # 'ќ'
    151: 0,  # 'Ќ'
    152: 0,  # 'ў'
    153: 0,  # 'Ў'
    154: 54,  # 'џ'
    155: 60,  # 'Џ'
    156: 0,  # 'ю'
    157: 0,  # 'Ю'
    158: 0,  # 'ъ'
    159: 0,  # 'Ъ'
    160: 1,  # 'а'
    161: 31,  # 'А'
    162: 19,  # 'б'
    163: 40,  # 'Б'
    164: 21,  # 'ц'
    165: 49,  # 'Ц'
    166: 12,  # 'д'
    167: 38,  # 'Д'
    168: 4,  # 'е'
    169: 44,  # 'Е'
    170: 30,  # 'ф'
    171: 51,  # 'Ф'
    172: 18,  # 'г'
    173: 47,  # 'Г'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 25,  # 'х'
    182: 50,  # 'Х'
    183: 2,  # 'и'
    184: 37,  # 'И'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 0,  # 'й'
    190: 0,  # 'Й'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 10,  # 'к'
    199: 35,  # 'К'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 15,  # 'л'
    209: 48,  # 'Л'
    210: 13,  # 'м'
    211: 36,  # 'М'
    212: 5,  # 'н'
    213: 32,  # 'Н'
    214: 3,  # 'о'
    215: 34,  # 'О'
    216: 16,  # 'п'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: 29,  # 'П'
    222: 0,  # 'я'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Я'
    225: 6,  # 'р'
    226: 43,  # 'Р'
    227: 8,  # 'с'
    228: 28,  # 'С'
    229: 7,  # 'т'
    230: 39,  # 'Т'
    231: 9,  # 'у'
    232: 42,  # 'У'
    233: 26,  # 'ж'
    234: 55,  # 'Ж'
    235: 11,  # 'в'
    236: 41,  # 'В'
    237: 0,  # 'ь'
    238: 0,  # 'Ь'
    239: CharacterCategory.SYMBOL,  # '№'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: 0,  # 'ы'
    242: 0,  # 'Ы'
    243: 17,  # 'з'
    244: 45,  # 'З'
    245: 22,  # 'ш'
    246: 52,  # 'Ш'
    247: 0,  # 'э'
    248: 0,  # 'Э'
    249: 0,  # 'щ'
    250: 0,  # 'Щ'
    251: 20,  # 'ч'
    252: 53,  # 'Ч'
    253: CharacterCategory.SYMBOL,  # '§'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP855_SERBIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP855",
    language="Serbian",
    char_to_order_map=CP855_SERBIAN_CHAR_TO_ORDER,
    language_model=SERBIAN_LANG_MODEL,
    typical_positive_ratio=0.9795590075457377,
    keep_ascii_letters=False,
    alphabet="ЂЈЉЊЋЏАБВГДЕЖЗИКЛМНОПРСТУФХЦЧШабвгдежзиклмнопрстуфхцчшђјљњћџ",
)

CP866_SERBIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 31,  # 'А'
    129: 40,  # 'Б'
    130: 41,  # 'В'
    131: 47,  # 'Г'
    132: 38,  # 'Д'
    133: 44,  # 'Е'
    134: 55,  # 'Ж'
    135: 45,  # 'З'
    136: 0,  # 'И'
    137: 0,  # 'Й'
    138: 35,  # 'К'
    139: 48,  # 'Л'
    140: 36,  # 'М'
    141: 32,  # 'Н'
    142: 34,  # 'О'
    143: 29,  # 'П'
    144: 43,  # 'Р'
    145: 28,  # 'С'
    146: 39,  # 'Т'
    147: 42,  # 'У'
    148: 51,  # 'Ф'
    149: 50,  # 'Х'
    150: 49,  # 'Ц'
    151: 53,  # 'Ч'
    152: 52,  # 'Ш'
    153: 0,  # 'Щ'
    154: 0,  # 'Ъ'
    155: 0,  # 'Ы'
    156: 0,  # 'Ь'
    157: 0,  # 'Э'
    158: 0,  # 'Ю'
    159: 0,  # 'Я'
    160: 1,  # 'а'
    161: 19,  # 'б'
    162: 11,  # 'в'
    163: 18,  # 'г'
    164: 12,  # 'д'
    165: 4,  # 'е'
    166: 26,  # 'ж'
    167: 17,  # 'з'
    168: 0,  # 'и'
    169: 0,  # 'й'
    170: 10,  # 'к'
    171: 15,  # 'л'
    172: 13,  # 'м'
    173: 5,  # 'н'
    174: 3,  # 'о'
    175: 16,  # 'п'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 6,  # 'р'
    225: 8,  # 'с'
    226: 7,  # 'т'
    227: 9,  # 'у'
    228: 30,  # 'ф'
    229: 25,  # 'х'
    230: 21,  # 'ц'
    231: 20,  # 'ч'
    232: 22,  # 'ш'
    233: 0,  # 'щ'
    234: 0,  # 'ъ'
    235: 0,  # 'ы'
    236: 0,  # 'ь'
    237: 0,  # 'э'
    238: 0,  # 'ю'
    239: 0,  # 'я'
    240: 0,  # 'Ё'
    241: 0,  # 'ё'
    242: 0,  # 'Є'
    243: 0,  # 'є'
    244: 0,  # 'Ї'
    245: 0,  # 'ї'
    246: 0,  # 'Ў'
    247: 0,  # 'ў'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: CharacterCategory.SYMBOL,  # '№'
    253: CharacterCategory.SYMBOL,  # '¤'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP866_SERBIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP866",
    language="Serbian",
    char_to_order_map=CP866_SERBIAN_CHAR_TO_ORDER,
    language_model=SERBIAN_LANG_MODEL,
    typical_positive_ratio=0.9811307138175327,
    keep_ascii_letters=False,
    alphabet="ЂЈЉЊЋЏАБВГДЕЖЗИКЛМНОПРСТУФХЦЧШабвгдежзиклмнопрстуфхцчшђјљњћџ",
)

ISO_8859_5_SERBIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ё'
    162: 57,  # 'Ђ'
    163: 0,  # 'Ѓ'
    164: 0,  # 'Є'
    165: 0,  # 'Ѕ'
    166: 0,  # 'І'
    167: 0,  # 'Ї'
    168: 46,  # 'Ј'
    169: 58,  # 'Љ'
    170: 56,  # 'Њ'
    171: 59,  # 'Ћ'
    172: 0,  # 'Ќ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'Ў'
    175: 60,  # 'Џ'
    176: 31,  # 'А'
    177: 40,  # 'Б'
    178: 41,  # 'В'
    179: 47,  # 'Г'
    180: 38,  # 'Д'
    181: 44,  # 'Е'
    182: 55,  # 'Ж'
    183: 45,  # 'З'
    184: 37,  # 'И'
    185: 0,  # 'Й'
    186: 35,  # 'К'
    187: 48,  # 'Л'
    188: 36,  # 'М'
    189: 32,  # 'Н'
    190: 34,  # 'О'
    191: 29,  # 'П'
    192: 43,  # 'Р'
    193: 28,  # 'С'
    194: 39,  # 'Т'
    195: 42,  # 'У'
    196: 51,  # 'Ф'
    197: 50,  # 'Х'
    198: 49,  # 'Ц'
    199: 53,  # 'Ч'
    200: 52,  # 'Ш'
    201: 0,  # 'Щ'
    202: 0,  # 'Ъ'
    203: 0,  # 'Ы'
    204: 0,  # 'Ь'
    205: 0,  # 'Э'
    206: 0,  # 'Ю'
    207: 0,  # 'Я'
    208: 1,  # 'а'
    209: 19,  # 'б'
    210: 11,  # 'в'
    211: 18,  # 'г'
    212: 12,  # 'д'
    213: 4,  # 'е'
    214: 26,  # 'ж'
    215: 17,  # 'з'
    216: 2,  # 'и'
    217: 0,  # 'й'
    218: 10,  # 'к'
    219: 15,  # 'л'
    220: 13,  # 'м'
    221: 5,  # 'н'
    222: 3,  # 'о'
    223: 16,  # 'п'
    224: 6,  # 'р'
    225: 8,  # 'с'
    226: 7,  # 'т'
    227: 9,  # 'у'
    228: 30,  # 'ф'
    229: 25,  # 'х'
    230: 21,  # 'ц'
    231: 20,  # 'ч'
    232: 22,  # 'ш'
    233: 0,  # 'щ'
    234: 0,  # 'ъ'
    235: 0,  # 'ы'
    236: 0,  # 'ь'
    237: 0,  # 'э'
    238: 0,  # 'ю'
    239: 0,  # 'я'
    240: CharacterCategory.SYMBOL,  # '№'
    241: 0,  # 'ё'
    242: 33,  # 'ђ'
    243: 0,  # 'ѓ'
    244: 0,  # 'є'
    245: 0,  # 'ѕ'
    246: 0,  # 'і'
    247: 0,  # 'ї'
    248: 14,  # 'ј'
    249: 27,  # 'љ'
    250: 23,  # 'њ'
    251: 24,  # 'ћ'
    252: 0,  # 'ќ'
    253: CharacterCategory.SYMBOL,  # '§'
    254: 0,  # 'ў'
    255: 54,  # 'џ'
}

ISO_8859_5_SERBIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-5",
    language="Serbian",
    char_to_order_map=ISO_8859_5_SERBIAN_CHAR_TO_ORDER,
    language_model=SERBIAN_LANG_MODEL,
    typical_positive_ratio=0.9795590075457377,
    keep_ascii_letters=False,
    alphabet="ЂЈЉЊЋЏАБВГДЕЖЗИКЛМНОПРСТУФХЦЧШабвгдежзиклмнопрстуфхцчшђјљњћџ",
)

KOI8_R_SERBIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '─'
    129: CharacterCategory.SYMBOL,  # '│'
    130: CharacterCategory.SYMBOL,  # '┌'
    131: CharacterCategory.SYMBOL,  # '┐'
    132: CharacterCategory.SYMBOL,  # '└'
    133: CharacterCategory.SYMBOL,  # '┘'
    134: CharacterCategory.SYMBOL,  # '├'
    135: CharacterCategory.SYMBOL,  # '┤'
    136: CharacterCategory.SYMBOL,  # '┬'
    137: CharacterCategory.SYMBOL,  # '┴'
    138: CharacterCategory.SYMBOL,  # '┼'
    139: CharacterCategory.SYMBOL,  # '▀'
    140: CharacterCategory.SYMBOL,  # '▄'
    141: CharacterCategory.SYMBOL,  # '█'
    142: CharacterCategory.SYMBOL,  # '▌'
    143: CharacterCategory.SYMBOL,  # '▐'
    144: CharacterCategory.SYMBOL,  # '░'
    145: CharacterCategory.SYMBOL,  # '▒'
    146: CharacterCategory.SYMBOL,  # '▓'
    147: CharacterCategory.SYMBOL,  # '⌠'
    148: CharacterCategory.SYMBOL,  # '■'
    149: CharacterCategory.SYMBOL,  # '∙'
    150: CharacterCategory.SYMBOL,  # '√'
    151: CharacterCategory.SYMBOL,  # '≈'
    152: CharacterCategory.SYMBOL,  # '≤'
    153: CharacterCategory.SYMBOL,  # '≥'
    154: CharacterCategory.CONTROL,  # '\xa0'
    155: CharacterCategory.SYMBOL,  # '⌡'
    156: CharacterCategory.SYMBOL,  # '°'
    157: CharacterCategory.DIGIT,  # '²'
    158: CharacterCategory.SYMBOL,  # '·'
    159: CharacterCategory.SYMBOL,  # '÷'
    160: CharacterCategory.SYMBOL,  # '═'
    161: CharacterCategory.SYMBOL,  # '║'
    162: CharacterCategory.SYMBOL,  # '╒'
    163: 0,  # 'ё'
    164: CharacterCategory.SYMBOL,  # '╓'
    165: CharacterCategory.SYMBOL,  # '╔'
    166: CharacterCategory.SYMBOL,  # '╕'
    167: CharacterCategory.SYMBOL,  # '╖'
    168: CharacterCategory.SYMBOL,  # '╗'
    169: CharacterCategory.SYMBOL,  # '╘'
    170: CharacterCategory.SYMBOL,  # '╙'
    171: CharacterCategory.SYMBOL,  # '╚'
    172: CharacterCategory.SYMBOL,  # '╛'
    173: CharacterCategory.SYMBOL,  # '╜'
    174: CharacterCategory.SYMBOL,  # '╝'
    175: CharacterCategory.SYMBOL,  # '╞'
    176: CharacterCategory.SYMBOL,  # '╟'
    177: CharacterCategory.SYMBOL,  # '╠'
    178: CharacterCategory.SYMBOL,  # '╡'
    179: 0,  # 'Ё'
    180: CharacterCategory.SYMBOL,  # '╢'
    181: CharacterCategory.SYMBOL,  # '╣'
    182: CharacterCategory.SYMBOL,  # '╤'
    183: CharacterCategory.SYMBOL,  # '╥'
    184: CharacterCategory.SYMBOL,  # '╦'
    185: CharacterCategory.SYMBOL,  # '╧'
    186: CharacterCategory.SYMBOL,  # '╨'
    187: CharacterCategory.SYMBOL,  # '╩'
    188: CharacterCategory.SYMBOL,  # '╪'
    189: CharacterCategory.SYMBOL,  # '╫'
    190: CharacterCategory.SYMBOL,  # '╬'
    191: CharacterCategory.SYMBOL,  # '©'
    192: 0,  # 'ю'
    193: 1,  # 'а'
    194: 19,  # 'б'
    195: 21,  # 'ц'
    196: 12,  # 'д'
    197: 4,  # 'е'
    198: 30,  # 'ф'
    199: 18,  # 'г'
    200: 25,  # 'х'
    201: 2,  # 'и'
    202: 0,  # 'й'
    203: 10,  # 'к'
    204: 15,  # 'л'
    205: 13,  # 'м'
    206: 5,  # 'н'
    207: 3,  # 'о'
    208: 16,  # 'п'
    209: 0,  # 'я'
    210: 6,  # 'р'
    211: 8,  # 'с'
    212: 7,  # 'т'
    213: 9,  # 'у'
    214: 26,  # 'ж'
    215: 11,  # 'в'
    216: 0,  # 'ь'
    217: 0,  # 'ы'
    218: 17,  # 'з'
    219: 22,  # 'ш'
    220: 0,  # 'э'
    221: 0,  # 'щ'
    222: 20,  # 'ч'
    223: 0,  # 'ъ'
    224: 0,  # 'Ю'
    225: 31,  # 'А'
    226: 40,  # 'Б'
    227: 49,  # 'Ц'
    228: 38,  # 'Д'
    229: 44,  # 'Е'
    230: 51,  # 'Ф'
    231: 47,  # 'Г'
    232: 50,  # 'Х'
    233: 37,  # 'И'
    234: 0,  # 'Й'
    235: 35,  # 'К'
    236: 48,  # 'Л'
    237: 36,  # 'М'
    238: 32,  # 'Н'
    239: 34,  # 'О'
    240: 29,  # 'П'
    241: 0,  # 'Я'
    242: 43,  # 'Р'
    243: 28,  # 'С'
    244: 39,  # 'Т'
    245: 42,  # 'У'
    246: 55,  # 'Ж'
    247: 41,  # 'В'
    248: 0,  # 'Ь'
    249: 0,  # 'Ы'
    250: 45,  # 'З'
    251: 52,  # 'Ш'
    252: 0,  # 'Э'
    253: 0,  # 'Щ'
    254: 53,  # 'Ч'
    255: 0,  # 'Ъ'
}

KOI8_R_SERBIAN_MODEL = SingleByteCharSetModel(
    charset_name="KOI8-R",
    language="Serbian",
    char_to_order_map=KOI8_R_SERBIAN_CHAR_TO_ORDER,
    language_model=SERBIAN_LANG_MODEL,
    typical_positive_ratio=0.9811307138175327,
    keep_ascii_letters=False,
    alphabet="ЂЈЉЊЋЏАБВГДЕЖЗИКЛМНОПРСТУФХЦЧШабвгдежзиклмнопрстуфхцчшђјљњћџ",
)

MACCYRILLIC_SERBIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 31,  # 'А'
    129: 40,  # 'Б'
    130: 41,  # 'В'
    131: 47,  # 'Г'
    132: 38,  # 'Д'
    133: 44,  # 'Е'
    134: 55,  # 'Ж'
    135: 45,  # 'З'
    136: 37,  # 'И'
    137: 0,  # 'Й'
    138: 35,  # 'К'
    139: 48,  # 'Л'
    140: 36,  # 'М'
    141: 32,  # 'Н'
    142: 34,  # 'О'
    143: 29,  # 'П'
    144: 43,  # 'Р'
    145: 28,  # 'С'
    146: 39,  # 'Т'
    147: 42,  # 'У'
    148: 51,  # 'Ф'
    149: 50,  # 'Х'
    150: 49,  # 'Ц'
    151: 53,  # 'Ч'
    152: 52,  # 'Ш'
    153: 0,  # 'Щ'
    154: 0,  # 'Ъ'
    155: 0,  # 'Ы'
    156: 0,  # 'Ь'
    157: 0,  # 'Э'
    158: 0,  # 'Ю'
    159: 0,  # 'Я'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: 0,  # 'Ґ'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'І'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: 57,  # 'Ђ'
    172: 33,  # 'ђ'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Ѓ'
    175: 0,  # 'ѓ'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: 0,  # 'і'
    181: 0,  # 'µ'
    182: 0,  # 'ґ'
    183: 46,  # 'Ј'
    184: 0,  # 'Є'
    185: 0,  # 'є'
    186: 0,  # 'Ї'
    187: 0,  # 'ї'
    188: 58,  # 'Љ'
    189: 27,  # 'љ'
    190: 56,  # 'Њ'
    191: 23,  # 'њ'
    192: 14,  # 'ј'
    193: 0,  # 'Ѕ'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 59,  # 'Ћ'
    204: 24,  # 'ћ'
    205: 0,  # 'Ќ'
    206: 0,  # 'ќ'
    207: 0,  # 'ѕ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '„'
    216: 0,  # 'Ў'
    217: 0,  # 'ў'
    218: 60,  # 'Џ'
    219: 54,  # 'џ'
    220: CharacterCategory.SYMBOL,  # '№'
    221: 0,  # 'Ё'
    222: 0,  # 'ё'
    223: 0,  # 'я'
    224: 1,  # 'а'
    225: 19,  # 'б'
    226: 11,  # 'в'
    227: 18,  # 'г'
    228: 12,  # 'д'
    229: 4,  # 'е'
    230: 26,  # 'ж'
    231: 17,  # 'з'
    232: 2,  # 'и'
    233: 0,  # 'й'
    234: 10,  # 'к'
    235: 15,  # 'л'
    236: 13,  # 'м'
    237: 5,  # 'н'
    238: 3,  # 'о'
    239: 16,  # 'п'
    240: 6,  # 'р'
    241: 8,  # 'с'
    242: 7,  # 'т'
    243: 9,  # 'у'
    244: 30,  # 'ф'
    245: 25,  # 'х'
    246: 21,  # 'ц'
    247: 20,  # 'ч'
    248: 22,  # 'ш'
    249: 0,  # 'щ'
    250: 0,  # 'ъ'
    251: 0,  # 'ы'
    252: 0,  # 'ь'
    253: 0,  # 'э'
    254: 0,  # 'ю'
    255: CharacterCategory.SYMBOL,  # '€'
}

MACCYRILLIC_SERBIAN_MODEL = SingleByteCharSetModel(
    charset_name="MacCyrillic",
    language="Serbian",
    char_to_order_map=MACCYRILLIC_SERBIAN_CHAR_TO_ORDER,
    language_model=SERBIAN_LANG_MODEL,
    typical_positive_ratio=0.9795590075457377,
    keep_ascii_letters=False,
    alphabet="ЂЈЉЊЋЏАБВГДЕЖЗИКЛМНОПРСТУФХЦЧШабвгдежзиклмнопрстуфхцчшђјљњћџ",
)

WINDOWS_1251_SERBIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 57,  # 'Ђ'
    129: 0,  # 'Ѓ'
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ѓ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.SYMBOL,  # '€'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 58,  # 'Љ'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 56,  # 'Њ'
    141: 0,  # 'Ќ'
    142: 59,  # 'Ћ'
    143: 60,  # 'Џ'
    144: 33,  # 'ђ'
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: 27,  # 'љ'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 23,  # 'њ'
    157: 0,  # 'ќ'
    158: 24,  # 'ћ'
    159: 54,  # 'џ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ў'
    162: 0,  # 'ў'
    163: 46,  # 'Ј'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ґ'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ё'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Є'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ї'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: 0,  # 'І'
    179: 0,  # 'і'
    180: 0,  # 'ґ'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ё'
    185: CharacterCategory.SYMBOL,  # '№'
    186: 0,  # 'є'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 14,  # 'ј'
    189: 0,  # 'Ѕ'
    190: 0,  # 'ѕ'
    191: 0,  # 'ї'
    192: 31,  # 'А'
    193: 40,  # 'Б'
    194: 41,  # 'В'
    195: 47,  # 'Г'
    196: 38,  # 'Д'
    197: 44,  # 'Е'
    198: 55,  # 'Ж'
    199: 45,  # 'З'
    200: 37,  # 'И'
    201: 0,  # 'Й'
    202: 35,  # 'К'
    203: 48,  # 'Л'
    204: 36,  # 'М'
    205: 32,  # 'Н'
    206: 34,  # 'О'
    207: 29,  # 'П'
    208: 43,  # 'Р'
    209: 28,  # 'С'
    210: 39,  # 'Т'
    211: 42,  # 'У'
    212: 51,  # 'Ф'
    213: 50,  # 'Х'
    214: 49,  # 'Ц'
    215: 53,  # 'Ч'
    216: 52,  # 'Ш'
    217: 0,  # 'Щ'
    218: 0,  # 'Ъ'
    219: 0,  # 'Ы'
    220: 0,  # 'Ь'
    221: 0,  # 'Э'
    222: 0,  # 'Ю'
    223: 0,  # 'Я'
    224: 1,  # 'а'
    225: 19,  # 'б'
    226: 11,  # 'в'
    227: 18,  # 'г'
    228: 12,  # 'д'
    229: 4,  # 'е'
    230: 26,  # 'ж'
    231: 17,  # 'з'
    232: 2,  # 'и'
    233: 0,  # 'й'
    234: 10,  # 'к'
    235: 15,  # 'л'
    236: 13,  # 'м'
    237: 5,  # 'н'
    238: 3,  # 'о'
    239: 16,  # 'п'
    240: 6,  # 'р'
    241: 8,  # 'с'
    242: 7,  # 'т'
    243: 9,  # 'у'
    244: 30,  # 'ф'
    245: 25,  # 'х'
    246: 21,  # 'ц'
    247: 20,  # 'ч'
    248: 22,  # 'ш'
    249: 0,  # 'щ'
    250: 0,  # 'ъ'
    251: 0,  # 'ы'
    252: 0,  # 'ь'
    253: 0,  # 'э'
    254: 0,  # 'ю'
    255: 0,  # 'я'
}

WINDOWS_1251_SERBIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1251",
    language="Serbian",
    char_to_order_map=WINDOWS_1251_SERBIAN_CHAR_TO_ORDER,
    language_model=SERBIAN_LANG_MODEL,
    typical_positive_ratio=0.9795590075457377,
    keep_ascii_letters=False,
    alphabet="ЂЈЉЊЋЏАБВГДЕЖЗИКЛМНОПРСТУФХЦЧШабвгдежзиклмнопрстуфхцчшђјљњћџ",
)
