/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.general.MD5Digest;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.PBEParametersGenerator;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class OpenSSLPBEParametersGenerator<T extends Parameters>
extends PBEParametersGenerator<T> {
    private Digest digest = new MD5Digest();

    public OpenSSLPBEParametersGenerator(T t) {
        super(t);
    }

    public void init(byte[] byArray, byte[] byArray2) {
        super.init(byArray, byArray2, 1);
    }

    private byte[] generateDerivedKey(int n) {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (true) {
            this.digest.update(this.password, 0, this.password.length);
            this.digest.update(this.salt, 0, this.salt.length);
            this.digest.doFinal(byArray, 0);
            int n3 = n > byArray.length ? byArray.length : n;
            System.arraycopy(byArray, 0, byArray2, n2, n3);
            n2 += n3;
            if ((n -= n3) == 0) break;
            this.digest.reset();
            this.digest.update(byArray, 0, byArray.length);
        }
        return byArray2;
    }

    @Override
    public CipherParameters generateDerivedParameters(int n) {
        byte[] byArray = this.generateDerivedKey(n /= 8);
        return new KeyParameterImpl(byArray);
    }

    @Override
    public CipherParameters generateDerivedParameters(int n, int n2) {
        byte[] byArray = this.generateDerivedKey((n /= 8) + (n2 /= 8));
        return new ParametersWithIV(new KeyParameterImpl(Arrays.copyOfRange(byArray, 0, n)), byArray, n, n2);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int n) {
        return this.generateDerivedParameters(n);
    }

    @Override
    public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n) {
        return this.generateDerivedKey(n);
    }

    @Override
    public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n, int n2) {
        byte[] byArray = this.generateDerivedKey(n + n2);
        return new byte[][]{Arrays.copyOfRange(byArray, 0, n), Arrays.copyOfRange(byArray, n, n + n2)};
    }
}

